/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.load.java.AbstractJavaClassFinder;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaClassFinderImpl;", "Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;", "()V", "javaFacade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "findClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "request", "Lorg/jetbrains/kotlin/load/java/JavaClassFinder$Request;", "findPackage", "Lorg/jetbrains/kotlin/load/java/structure/JavaPackage;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "knownClassNamesInPackage", "", "", "packageFqName", "setProjectInstance", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "frontend.java"})
public final class JavaClassFinderImpl
extends AbstractJavaClassFinder {
    private KotlinJavaPsiFacade javaFacade;

    @Override
    @Inject
    public void setProjectInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        super.setProjectInstance(project);
        KotlinJavaPsiFacade kotlinJavaPsiFacade = KotlinJavaPsiFacade.getInstance(project);
        Intrinsics.checkNotNullExpressionValue(kotlinJavaPsiFacade, "getInstance(project)");
        this.javaFacade = kotlinJavaPsiFacade;
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException("javaFacade");
            throw null;
        }
        return kotlinJavaPsiFacade.findClass(request, this.getJavaSearchScope());
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName2) {
        JavaPackageImpl javaPackageImpl;
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Object object = this.javaFacade;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException("javaFacade");
            throw null;
        }
        PsiPackage psiPackage = ((KotlinJavaPsiFacade)object).findPackage(fqName2.asString(), this.getJavaSearchScope());
        if (psiPackage == null) {
            javaPackageImpl = null;
        } else {
            object = psiPackage;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            javaPackageImpl = new JavaPackageImpl((PsiPackage)it, this.getJavaSearchScope());
        }
        return javaPackageImpl;
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException("javaFacade");
            throw null;
        }
        return kotlinJavaPsiFacade.knownClassNamesInPackage(packageFqName, this.getJavaSearchScope());
    }
}

