/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/CatchTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "catches", "", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Ljava/util/List;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getCatches", "()Ljava/util/List;", "getPsi", "()Lcom/intellij/psi/PsiElement;", "isDynamic", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsCatch;", "translateCatchBody", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "catchClause", "translateCatches", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "initialCatchParameterRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "", "js.translator"})
public final class CatchTranslator
extends AbstractTranslator {
    @NotNull
    private final List<KtCatchClause> catches;
    @NotNull
    private final PsiElement psi;

    public CatchTranslator(@NotNull List<? extends KtCatchClause> catches, @NotNull PsiElement psi, @NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(catches, "catches");
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
        this.catches = catches;
        this.psi = psi;
    }

    @NotNull
    public final List<KtCatchClause> getCatches() {
        return this.catches;
    }

    @NotNull
    public final PsiElement getPsi() {
        return this.psi;
    }

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        KtCatchClause firstCatch = CollectionsKt.first(this.catches);
        KtParameter catchParameter = firstCatch.getCatchParameter();
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkNotNull(catchParameter);
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(bindingContext, catchParameter);
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getDescriptorForElement(bindingContext(), catchParameter!!)");
        DeclarationDescriptor parameterDescriptor = declarationDescriptor;
        String string2 = this.context().getNameForDescriptor(parameterDescriptor).getIdent();
        Intrinsics.checkNotNullExpressionValue(string2, "context().getNameForDescriptor(parameterDescriptor).ident");
        String parameterName = string2;
        JsCatch jsCatch = new JsCatch(this.context().scope(), parameterName);
        JsNameRef jsNameRef = jsCatch.getParameter().getName().makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "jsCatch.parameter.name.makeRef()");
        JsNameRef parameterRef = jsNameRef;
        TranslationContext translationContext = this.context().innerContextWithAliased(parameterDescriptor, parameterRef);
        Intrinsics.checkNotNullExpressionValue(translationContext, "context().innerContextWithAliased(parameterDescriptor, parameterRef)");
        TranslationContext catchContext = translationContext;
        jsCatch.setBody(new JsBlock(this.translateCatches(catchContext, parameterRef, this.catches.iterator())));
        return jsCatch;
    }

    private final JsStatement translateCatches(TranslationContext context2, JsNameRef initialCatchParameterRef, Iterator<? extends KtCatchClause> catches) {
        SourceInfoAwareJsNode sourceInfoAwareJsNode;
        SourceInfoAwareJsNode sourceInfoAwareJsNode2;
        Object parameterAlias;
        KtTypeReference ktTypeReference;
        KtParameter $this$translateCatches_u24lambda_u2d02;
        if (!catches.hasNext()) {
            JsThrow jsThrow = new JsThrow(initialCatchParameterRef);
            boolean bl = false;
            boolean bl2 = false;
            JsThrow $this$translateCatches_u24lambda_u2d02 = jsThrow;
            boolean bl3 = false;
            $this$translateCatches_u24lambda_u2d02.setSource(this.getPsi());
            return jsThrow;
        }
        Object nextContext = context2;
        KtCatchClause ktCatchClause = catches.next();
        Object bl3 = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull(bl3);
        KtParameter param = $this$translateCatches_u24lambda_u2d02 = bl3;
        BindingContext bindingContext = this.bindingContext();
        Object object = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull(object);
        bl3 = BindingUtils.getDescriptorForElement(bindingContext, (PsiElement)object);
        Intrinsics.checkNotNullExpressionValue(bl3, "getDescriptorForElement(bindingContext(), catch.catchParameter!!)");
        Object parameterDescriptor = bl3;
        object = this.context().getNameForDescriptor((DeclarationDescriptor)parameterDescriptor);
        Intrinsics.checkNotNullExpressionValue(object, "context().getNameForDescriptor(parameterDescriptor)");
        Object parameterName = object;
        KtTypeReference ktTypeReference2 = param.getTypeReference();
        Intrinsics.checkNotNull(ktTypeReference2);
        KtTypeReference paramType = ktTypeReference = ktTypeReference2;
        boolean bl = false;
        List additionalStatements2 = new ArrayList();
        if (!Intrinsics.areEqual(((JsName)parameterName).getIdent(), initialCatchParameterRef.getIdent())) {
            Object object2 = JsScope.declareTemporaryName(((JsName)parameterName).getIdent());
            Intrinsics.checkNotNullExpressionValue(object2, "declareTemporaryName(parameterName.ident)");
            parameterAlias = object2;
            object2 = additionalStatements2;
            sourceInfoAwareJsNode2 = JsAstUtils.newVar((JsName)parameterAlias, initialCatchParameterRef);
            boolean bl4 = false;
            object2.add(sourceInfoAwareJsNode2);
            sourceInfoAwareJsNode2 = JsAstUtils.pureFqn((JsName)parameterAlias, null);
            Intrinsics.checkNotNullExpressionValue(sourceInfoAwareJsNode2, "pureFqn(parameterAlias, null)");
            SourceInfoAwareJsNode ref = sourceInfoAwareJsNode2;
            sourceInfoAwareJsNode = ref;
        } else {
            sourceInfoAwareJsNode = initialCatchParameterRef;
        }
        JsNameRef parameterRef = sourceInfoAwareJsNode;
        parameterAlias = ((TranslationContext)nextContext).innerContextWithAliased((DeclarationDescriptor)parameterDescriptor, parameterRef);
        Intrinsics.checkNotNullExpressionValue(parameterAlias, "nextContext.innerContextWithAliased(parameterDescriptor, parameterRef)");
        nextContext = parameterAlias;
        JsBlock thenBlock = this.translateCatchBody((TranslationContext)nextContext, ktCatchClause);
        thenBlock.getStatements().addAll(0, additionalStatements2);
        if (this.isDynamic(paramType)) {
            return thenBlock;
        }
        PatternTranslator patternTranslator = Translation.patternTranslator((TranslationContext)nextContext);
        boolean bl5 = false;
        boolean bl6 = false;
        PatternTranslator $this$translateCatches_u24lambda_u2d1 = patternTranslator;
        boolean bl7 = false;
        SourceInfoAwareJsNode sourceInfoAwareJsNode3 = $this$translateCatches_u24lambda_u2d1.translateIsCheck(initialCatchParameterRef, paramType);
        Intrinsics.checkNotNull(sourceInfoAwareJsNode3);
        SourceInfoAwareJsNode typeCheck = sourceInfoAwareJsNode2 = sourceInfoAwareJsNode3;
        JsStatement elseBlock = this.translateCatches(context2, initialCatchParameterRef, catches);
        sourceInfoAwareJsNode3 = new JsIf(((JsExpression)typeCheck).source(ktCatchClause), thenBlock, elseBlock);
        boolean bl8 = false;
        bl5 = false;
        SourceInfoAwareJsNode $this$translateCatches_u24lambda_u2d2 = sourceInfoAwareJsNode3;
        boolean bl9 = false;
        $this$translateCatches_u24lambda_u2d2.setSource(ktCatchClause);
        return (JsStatement)((Object)sourceInfoAwareJsNode3);
    }

    private final JsBlock translateCatchBody(TranslationContext context2, KtCatchClause catchClause) {
        KtExpression catchBody2 = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody2 != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody2, context2) : JsAstUtils.asSyntheticStatement(new JsNullLiteral());
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkNotNullExpressionValue(jsBlock, "convertToBlock(jsCatchBody)");
        return jsBlock;
    }

    private final boolean isDynamic(KtTypeReference $this$isDynamic) {
        Object v = BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $this$isDynamic);
        Intrinsics.checkNotNullExpressionValue(v, "getNotNull(bindingContext(), BindingContext.TYPE, this)");
        return DynamicTypesKt.isDynamic((KotlinType)v);
    }
}

