/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsExternalChecker;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u001e\u001a\u00020\u001a*\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010 \u001a\u00020\u001a*\u00020!H\u0002J\f\u0010\"\u001a\u00020\u001a*\u00020!H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExternalChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "DEFINED_EXTERNALLY_PROPERTY_NAMES", "", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getDEFINED_EXTERNALLY_PROPERTY_NAMES", "()Ljava/util/Set;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkAnonymousInitializer", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkBody", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkConstructorPropertyParam", "checkDelegation", "checkEnumEntry", "isDirectlyExternal", "", "isPrivateMemberOfExternalClass", "hasValidExternalBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "isDefinedExternallyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNonAbstractMemberOfInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isNullableProperty", "js.frontend"})
public final class JsExternalChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExternalChecker INSTANCE = new JsExternalChecker();
    @NotNull
    private static final Set<FqNameUnsafe> DEFINED_EXTERNALLY_PROPERTY_NAMES;

    private JsExternalChecker() {
    }

    @NotNull
    public final Set<FqNameUnsafe> getDEFINED_EXTERNALLY_PROPERTY_NAMES() {
        return DEFINED_EXTERNALLY_PROPERTY_NAMES;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Object classKind;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!AnnotationsUtils.isNativeObject(descriptor2)) {
            return;
        }
        BindingTrace trace = context2.getTrace();
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2) && this.isDirectlyExternal(declaration2, descriptor2) && !(descriptor2 instanceof PropertyAccessorDescriptor)) {
            trace.report(ErrorsJs.NESTED_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration2)));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Object object = ((ClassDescriptor)descriptor2).isData() ? "data class" : (((ClassDescriptor)descriptor2).isInner() ? "inner class" : (((ClassDescriptor)descriptor2).isInline() ? "inline class" : (((ClassDescriptor)descriptor2).isValue() ? "value class" : (((ClassDescriptor)descriptor2).isFun() ? "fun interface" : (classKind = DescriptorUtils.isAnnotationClass(descriptor2) ? "annotation class" : null)))));
            if (classKind != null) {
                trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration2), (String)classKind));
            }
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor && this.isDirectlyExternal(declaration2, descriptor2)) {
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration2), "property accessor"));
        } else if (this.isPrivateMemberOfExternalClass(descriptor2)) {
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration2), "private member of class"));
        }
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() != ClassKind.INTERFACE) {
            classKind = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            boolean bl = false;
            boolean bl2 = false;
            Object it = classKind;
            boolean bl3 = false;
            boolean bl4 = it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.INTERFACE;
            if (bl4) {
                trace.report(ErrorsJs.NESTED_CLASS_IN_EXTERNAL_INTERFACE.on((KtExpression)((PsiElement)declaration2)));
            }
        }
        if (!(descriptor2 instanceof PropertyAccessorDescriptor) && DescriptorUtilsKt.isExtension(descriptor2)) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            String target = declarationDescriptor instanceof FunctionDescriptor ? "extension function" : (declarationDescriptor instanceof PropertyDescriptor ? "extension property" : "extension member");
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration2), target));
        }
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block18: {
                Set superClasses2 = CollectionsKt.toMutableSet(CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2)), (Iterable)DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor2)));
                if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_CLASS || ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                    CollectionsKt.removeAll(superClasses2, (Function1)check.2.INSTANCE);
                }
                Iterable $this$any$iv = superClasses2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ClassDescriptor it = (ClassDescriptor)element$iv;
                        boolean bl5 = false;
                        if (!(!AnnotationsUtils.isNativeObject(it) && !Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(it), StandardNames.FqNames.throwable))) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) {
                trace.report(ErrorsJs.EXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE.on((KtElement)((PsiElement)declaration2)));
            }
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isInline()) {
            trace.report(ErrorsJs.INLINE_EXTERNAL_DECLARATION.on((KtDeclaration)((PsiElement)declaration2)));
        }
        Object object = ErrorsJs.INLINE_CLASS_IN_EXTERNAL_DECLARATION;
        Intrinsics.checkNotNullExpressionValue(object, "INLINE_CLASS_IN_EXTERNAL_DECLARATION");
        JsExternalChecker.check$reportOnParametersAndReturnTypesIf(descriptor2, declaration2, trace, object, check.4.INSTANCE);
        object = ErrorsJs.EXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION;
        Intrinsics.checkNotNullExpressionValue(object, "EXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION");
        JsExternalChecker.check$reportOnParametersAndReturnTypesIf(descriptor2, declaration2, trace, object, check.5.INSTANCE);
        if (descriptor2 instanceof CallableMemberDescriptor && this.isNonAbstractMemberOfInterface((CallableMemberDescriptor)descriptor2) && !this.isNullableProperty((CallableMemberDescriptor)descriptor2)) {
            trace.report(ErrorsJs.NON_ABSTRACT_MEMBER_OF_EXTERNAL_INTERFACE.on((KtExpression)((PsiElement)declaration2)));
        }
        DiagnosticSink diagnosticSink = trace;
        object = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(object, "trace.bindingContext");
        this.checkBody(declaration2, descriptor2, diagnosticSink, (BindingContext)object);
        this.checkDelegation(declaration2, descriptor2, trace);
        this.checkAnonymousInitializer(declaration2, trace);
        this.checkEnumEntry(declaration2, trace);
        this.checkConstructorPropertyParam(declaration2, descriptor2, trace);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBody(KtDeclaration declaration2, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder, BindingContext bindingContext) {
        Object object;
        if (declaration2 instanceof KtProperty && descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        if (declaration2 instanceof KtDeclarationWithBody && !this.hasValidExternalBody((KtDeclarationWithBody)declaration2, bindingContext)) {
            object = ((KtDeclarationWithBody)declaration2).getBodyExpression();
            Intrinsics.checkNotNull(object);
            diagnosticHolder.report(ErrorsJs.WRONG_BODY_OF_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)object)));
        } else if (declaration2 instanceof KtDeclarationWithInitializer && Intrinsics.areEqual((object = ((KtDeclarationWithInitializer)declaration2).getInitializer()) == null ? null : Boolean.valueOf(this.isDefinedExternallyExpression((KtExpression)object, bindingContext)), false)) {
            object = ((KtDeclarationWithInitializer)declaration2).getInitializer();
            Intrinsics.checkNotNull(object);
            diagnosticHolder.report(ErrorsJs.WRONG_INITIALIZER_OF_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)object)));
        }
        if (declaration2 instanceof KtCallableDeclaration) {
            void $this$mapNotNullTo$iv$iv;
            List<KtParameter> list2 = ((KtCallableDeclaration)declaration2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "declaration.valueParameters");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtExpression ktExpression;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getDefaultValue() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                KtExpression it$iv$iv = ktExpression;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (KtExpression defaultValue2 : (List)destination$iv$iv) {
                Intrinsics.checkNotNullExpressionValue(defaultValue2, "defaultValue");
                if (this.isDefinedExternallyExpression(defaultValue2, bindingContext)) continue;
                diagnosticHolder.report(ErrorsJs.WRONG_DEFAULT_VALUE_FOR_EXTERNAL_FUN_PARAMETER.on((KtExpression)((PsiElement)defaultValue2)));
            }
        }
    }

    private final void checkDelegation(KtDeclaration declaration2, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        KtPropertyDelegate ktPropertyDelegate;
        if (!(descriptor2 instanceof MemberDescriptor) || !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
            return;
        }
        if (declaration2 instanceof KtClassOrObject) {
            for (KtSuperTypeListEntry superTypeEntry : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
                KtSuperTypeListEntry ktSuperTypeListEntry = superTypeEntry;
                if (ktSuperTypeListEntry instanceof KtSuperTypeCallEntry) {
                    KtValueArgumentList ktValueArgumentList = ((KtSuperTypeCallEntry)superTypeEntry).getValueArgumentList();
                    Intrinsics.checkNotNull(ktValueArgumentList);
                    diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATED_CONSTRUCTOR_CALL.on((KtElement)((PsiElement)ktValueArgumentList)));
                    continue;
                }
                if (!(ktSuperTypeListEntry instanceof KtDelegatedSuperTypeEntry)) continue;
                diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATION.on((KtElement)((PsiElement)superTypeEntry)));
            }
        } else if (declaration2 instanceof KtSecondaryConstructor) {
            KtConstructorDelegationCall delegationCall = ((KtSecondaryConstructor)declaration2).getDelegationCall();
            if (!delegationCall.isImplicit()) {
                diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATED_CONSTRUCTOR_CALL.on((KtElement)((PsiElement)delegationCall)));
            }
        } else if (declaration2 instanceof KtProperty && !(descriptor2 instanceof PropertyAccessorDescriptor) && (ktPropertyDelegate = ((KtProperty)declaration2).getDelegate()) != null) {
            KtPropertyDelegate ktPropertyDelegate2 = ktPropertyDelegate;
            boolean bl = false;
            boolean bl2 = false;
            KtPropertyDelegate delegate = ktPropertyDelegate2;
            boolean bl3 = false;
            diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATION.on((KtElement)((PsiElement)delegate)));
        }
    }

    private final void checkAnonymousInitializer(KtDeclaration declaration2, DiagnosticSink diagnosticHolder) {
        if (!(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        for (KtAnonymousInitializer anonymousInitializer : ((KtClassOrObject)declaration2).getAnonymousInitializers()) {
            diagnosticHolder.report(ErrorsJs.EXTERNAL_ANONYMOUS_INITIALIZER.on((KtAnonymousInitializer)((PsiElement)anonymousInitializer)));
        }
    }

    private final void checkEnumEntry(KtDeclaration declaration2, DiagnosticSink diagnosticHolder) {
        if (!(declaration2 instanceof KtEnumEntry)) {
            return;
        }
        KtClassBody ktClassBody = ((KtEnumEntry)declaration2).getBody();
        if (ktClassBody != null) {
            KtClassBody ktClassBody2 = ktClassBody;
            boolean bl = false;
            boolean bl2 = false;
            KtClassBody it = ktClassBody2;
            boolean bl3 = false;
            diagnosticHolder.report(ErrorsJs.EXTERNAL_ENUM_ENTRY_WITH_BODY.on((KtClassBody)((PsiElement)it)));
        }
    }

    private final void checkConstructorPropertyParam(KtDeclaration declaration2, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        if (!(descriptor2 instanceof PropertyDescriptor) || !(declaration2 instanceof KtParameter)) {
            return;
        }
        ClassDescriptor containingClass = (ClassDescriptor)((PropertyDescriptor)descriptor2).getContainingDeclaration();
        if (containingClass.isData() || DescriptorUtils.isAnnotationClass(containingClass)) {
            return;
        }
        diagnosticHolder.report(ErrorsJs.EXTERNAL_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)declaration2));
    }

    private final boolean isDirectlyExternal(KtDeclaration declaration2, DeclarationDescriptor descriptor2) {
        if (declaration2 instanceof KtProperty && descriptor2 instanceof PropertyAccessorDescriptor) {
            return false;
        }
        return declaration2.hasModifier(KtTokens.EXTERNAL_KEYWORD) || AnnotationsUtils.hasAnnotation(descriptor2, PredefinedAnnotation.NATIVE);
    }

    private final boolean isPrivateMemberOfExternalClass(DeclarationDescriptor descriptor2) {
        ClassDescriptor classDescriptor2;
        if (descriptor2 instanceof PropertyAccessorDescriptor && Intrinsics.areEqual(((PropertyAccessorDescriptor)descriptor2).getVisibility(), ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty().getVisibility())) {
            return false;
        }
        if (!(descriptor2 instanceof MemberDescriptor) || !Intrinsics.areEqual(((MemberDescriptor)descriptor2).getVisibility(), DescriptorVisibilities.PRIVATE)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((MemberDescriptor)descriptor2).getContainingDeclaration();
        ClassDescriptor classDescriptor3 = classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor containingDeclaration2 = classDescriptor2;
        return AnnotationsUtils.isNativeObject(containingDeclaration2);
    }

    private final boolean isNonAbstractMemberOfInterface(CallableMemberDescriptor $this$isNonAbstractMemberOfInterface) {
        return $this$isNonAbstractMemberOfInterface.getModality() != Modality.ABSTRACT && DescriptorUtils.isInterface($this$isNonAbstractMemberOfInterface.getContainingDeclaration()) && !($this$isNonAbstractMemberOfInterface instanceof PropertyAccessorDescriptor);
    }

    private final boolean isNullableProperty(CallableMemberDescriptor $this$isNullableProperty) {
        return $this$isNullableProperty instanceof PropertyDescriptor && TypeUtils.isNullableType(((PropertyDescriptor)$this$isNullableProperty).getType());
    }

    private final boolean hasValidExternalBody(KtDeclarationWithBody $this$hasValidExternalBody, BindingContext bindingContext) {
        boolean bl;
        KtExpression ktExpression;
        if (!$this$hasValidExternalBody.hasBody()) {
            return true;
        }
        KtExpression ktExpression2 = $this$hasValidExternalBody.getBodyExpression();
        Intrinsics.checkNotNull(ktExpression2);
        KtExpression body2 = ktExpression = ktExpression2;
        if (!$this$hasValidExternalBody.hasBlockBody()) {
            bl = this.isDefinedExternallyExpression(body2, bindingContext);
        } else if (body2 instanceof KtBlockExpression) {
            List<KtExpression> list2 = ((KtBlockExpression)body2).getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "body.statements");
            ktExpression2 = CollectionsKt.singleOrNull(list2);
            if (ktExpression2 == null) {
                return false;
            }
            KtExpression statement2 = ktExpression2;
            bl = this.isDefinedExternallyExpression(statement2, bindingContext);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isDefinedExternallyExpression(KtExpression $this$isDefinedExternallyExpression, BindingContext bindingContext) {
        boolean bl;
        block5: {
            PropertyDescriptor propertyDescriptor;
            Object object = CallUtilKt.getResolvedCall($this$isDefinedExternallyExpression, bindingContext);
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot = object == null ? null : object.getResultingDescriptor();
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor = declarationDescriptorNonRoot instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptorNonRoot : null;
            if (propertyDescriptor == null) {
                return false;
            }
            PropertyDescriptor descriptor2 = propertyDescriptor;
            object = descriptor2.getContainingDeclaration();
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 = declarationDescriptorNonRoot = object instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)object : null;
            if (declarationDescriptorNonRoot == null) {
                return false;
            }
            DeclarationDescriptorNonRoot container2 = declarationDescriptorNonRoot;
            Iterable $this$any$iv = DEFINED_EXTERNALLY_PROPERTY_NAMES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqNameUnsafe it = (FqNameUnsafe)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(container2), it.parent()) && Intrinsics.areEqual(descriptor2.getName(), it.shortName()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super KotlinType, Boolean> $condition, BindingTrace $trace, DiagnosticFactory0<KtElement> $diagnosticFactory, KotlinType type2, KtElement elementToReport) {
        if ($condition.invoke(type2).booleanValue()) {
            $trace.report($diagnosticFactory.on((KtElement)((PsiElement)elementToReport)));
        }
    }

    private static final void check$reportOnParametersAndReturnTypesIf(DeclarationDescriptor $descriptor, KtDeclaration $declaration, BindingTrace $trace, DiagnosticFactory0<KtElement> diagnosticFactory, Function1<? super KotlinType, Boolean> condition) {
        if (!(!($descriptor instanceof CallableMemberDescriptor) || $descriptor instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)$descriptor).isDefault())) {
            for (ValueParameterDescriptor p : ((CallableMemberDescriptor)$descriptor).getValueParameters()) {
                Object object;
                SourceElement sourceElement = p.getSource();
                Intrinsics.checkNotNullExpressionValue(sourceElement, "p.source");
                Object object2 = KotlinSourceElementKt.getPsi(sourceElement);
                Object object3 = object2 instanceof KtParameter ? (KtParameter)object2 : null;
                KtDeclaration ktParam = object3 == null ? $declaration : (KtDeclaration)object3;
                object3 = p.getVarargElementType();
                if (object3 == null) {
                    object2 = p.getType();
                    Intrinsics.checkNotNullExpressionValue(object2, "p.type");
                    object = object2;
                } else {
                    object = object3;
                }
                JsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $trace, diagnosticFactory, (KotlinType)object, ktParam);
            }
            KtModifierListOwner ktModifierListOwner = $declaration;
            KtModifierListOwner elementToReport = ktModifierListOwner instanceof KtCallableDeclaration ? (KtModifierListOwner)((KtCallableDeclaration)$declaration).getTypeReference() : (ktModifierListOwner instanceof KtPropertyAccessor ? (KtModifierListOwner)((KtPropertyAccessor)$declaration).getReturnTypeReference() : (KtModifierListOwner)$declaration);
            ktModifierListOwner = elementToReport;
            if (ktModifierListOwner != null) {
                KtModifierListOwner ktModifierListOwner2 = ktModifierListOwner;
                boolean bl = false;
                boolean bl2 = false;
                KtModifierListOwner it = ktModifierListOwner2;
                boolean bl3 = false;
                KotlinType kotlinType = ((CallableMemberDescriptor)$descriptor).getReturnType();
                Intrinsics.checkNotNull(kotlinType);
                KotlinType kotlinType2 = kotlinType;
                JsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $trace, diagnosticFactory, kotlinType2, it);
            }
        }
    }

    static {
        FqNameUnsafe[] fqNameUnsafeArray = new FqNameUnsafe[]{new FqNameUnsafe("kotlin.js.noImpl"), new FqNameUnsafe("kotlin.js.definedExternally")};
        DEFINED_EXTERNALLY_PROPERTY_NAMES = SetsKt.setOf(fqNameUnsafeArray);
    }
}

