/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\fJ\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "definedValues", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "definitions", "", "hasChanges", "", "localVariables", "", "namesToSubstitute", "", "namesWithSideEffects", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "statementsToRemove", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "temporary", "usages", "analyze", "", "apply", "assignVariable", "name", "value", "cleanUp", "isTrivial", "expr", "perform", "shouldConsiderTemporary", "shouldConsiderUnused", "useVariable", "SubstitutionCandidateFinder", "js.translator"})
public final class TemporaryVariableElimination {
    @NotNull
    private final JsFunction function;
    @NotNull
    private final JsBlock root;
    @NotNull
    private final Map<JsName, Integer> definitions;
    @NotNull
    private final Map<JsName, Integer> usages;
    @NotNull
    private final Map<JsName, JsExpression> definedValues;
    @NotNull
    private final Set<JsName> temporary;
    private boolean hasChanges;
    @NotNull
    private final Set<JsName> localVariables;
    @NotNull
    private final Set<JsName> namesToSubstitute;
    @NotNull
    private final Set<JsNode> statementsToRemove;
    @NotNull
    private final Set<JsName> namesWithSideEffects;

    public TemporaryVariableElimination(@NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        this.function = function2;
        JsBlock jsBlock = this.function.getBody();
        Intrinsics.checkNotNullExpressionValue(jsBlock, "function.body");
        this.root = jsBlock;
        boolean bl = false;
        this.definitions = new LinkedHashMap();
        bl = false;
        this.usages = new LinkedHashMap();
        bl = false;
        this.definedValues = new LinkedHashMap();
        bl = false;
        this.temporary = new LinkedHashSet();
        this.localVariables = CollectUtilsKt.collectLocalVariables$default(this.function, false, 1, null);
        bl = false;
        this.namesToSubstitute = new LinkedHashSet();
        bl = false;
        this.statementsToRemove = new LinkedHashSet();
        bl = false;
        this.namesWithSideEffects = new LinkedHashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        this.cleanUp();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final Set<JsName> currentScope;
            @NotNull
            private Set<JsName> localVars;
            final /* synthetic */ TemporaryVariableElimination this$0;
            {
                this.this$0 = $receiver;
                List<JsParameter> list2 = TemporaryVariableElimination.access$getFunction$p(this.this$0).getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "function.parameters");
                this.currentScope = SequencesKt.toMutableSet(SequencesKt.map(CollectionsKt.asSequence((Iterable)list2), analyze.currentScope.1.INSTANCE));
                boolean bl = false;
                this.localVars = new LinkedHashSet<E>();
            }

            @NotNull
            public final Set<JsName> getCurrentScope() {
                return this.currentScope;
            }

            @NotNull
            public final Set<JsName> getLocalVars() {
                return this.localVars;
            }

            public final void setLocalVars(@NotNull Set<JsName> set) {
                Intrinsics.checkNotNullParameter(set, "<set-?>");
                this.localVars = set;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                JsBinaryOperation jsBinaryOperation;
                Intrinsics.checkNotNullParameter(x, "x");
                JsExpression jsExpression = x.getExpression();
                JsBinaryOperation jsBinaryOperation2 = jsBinaryOperation = jsExpression instanceof JsBinaryOperation ? (JsBinaryOperation)jsExpression : null;
                if (jsBinaryOperation != null) {
                    jsExpression = jsBinaryOperation;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsExpression expression2 = jsExpression;
                    boolean bl3 = false;
                    this.processBinaryExpression((JsBinaryOperation)expression2, MetadataProperties.getSynthetic(x), new Function0<Unit>(this, x){
                        final /* synthetic */ analyze.1 this$0;
                        final /* synthetic */ JsExpressionStatement $x;
                        {
                            this.this$0 = $receiver;
                            this.$x = $x;
                            super(0);
                        }

                        public final void invoke() {
                            analyze.1.access$visitExpressionStatement$s-11928845(this.this$0, this.$x);
                        }
                    });
                    return;
                }
                super.visitExpressionStatement(x);
            }

            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.processBinaryExpression(x, false, new Function0<Unit>(this, x){
                    final /* synthetic */ analyze.1 this$0;
                    final /* synthetic */ JsBinaryOperation $x;
                    {
                        this.this$0 = $receiver;
                        this.$x = $x;
                        super(0);
                    }

                    public final void invoke() {
                        analyze.1.access$visitBinaryExpression$s-11928845(this.this$0, this.$x);
                    }
                });
            }

            private final void processBinaryExpression(JsBinaryOperation expression2, boolean synthetic, Function0<Unit> orElse) {
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName name2 = pair.component1();
                    JsExpression value2 = pair.component2();
                    if (TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name2)) {
                        Intrinsics.checkNotNullExpressionValue(name2, "name");
                        Intrinsics.checkNotNullExpressionValue(value2, "value");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, name2, value2);
                        this.addVar(name2);
                        this.accept((JsNode)value2);
                        if (synthetic) {
                            TemporaryVariableElimination temporaryVariableElimination = this.this$0;
                            Collection collection = TemporaryVariableElimination.access$getTemporary$p(temporaryVariableElimination);
                            boolean bl = false;
                            collection.add(name2);
                        }
                        return;
                    }
                }
                orElse.invoke();
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkNotNullParameter(x, "x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsName name2 = v.getName();
                    JsExpression value2 = v.getInitExpression();
                    if (!TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name2)) continue;
                    if (MetadataProperties.getSynthetic(x)) {
                        TemporaryVariableElimination temporaryVariableElimination = this.this$0;
                        Collection collection = TemporaryVariableElimination.access$getTemporary$p(temporaryVariableElimination);
                        boolean bl = false;
                        collection.add(name2);
                    }
                    if (value2 == null) continue;
                    Intrinsics.checkNotNullExpressionValue(name2, "name");
                    TemporaryVariableElimination.access$assignVariable(this.this$0, name2, value2);
                    this.addVar(name2);
                    this.accept((JsNode)value2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter(nameRef, "nameRef");
                JsName name2 = nameRef.getName();
                if (name2 != null && TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name2)) {
                    TemporaryVariableElimination.access$useVariable(this.this$0, name2);
                    if (!this.currentScope.contains(name2)) {
                        JsExpression jsExpression = Namer.getUndefinedExpression();
                        Intrinsics.checkNotNullExpressionValue(jsExpression, "getUndefinedExpression()");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, name2, jsExpression);
                    }
                    return;
                }
                super.visitNameRef(nameRef);
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter(x, "x");
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkNotNullParameter(x, "x");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitLoop(@NotNull JsLoop x) {
                Intrinsics.checkNotNullParameter(x, "x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    boolean bl = false;
                    this_$iv.setLocalVars((Set<JsName>)new LinkedHashSet<E>());
                    boolean bl2 = false;
                    super.visitLoop(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    analyze.1 var6_9 = this_$iv;
                    Collection collection = var6_9.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitIf(@NotNull JsIf x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.accept((JsNode)x.getIfExpression());
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    boolean bl = false;
                    this_$iv.setLocalVars((Set<JsName>)new LinkedHashSet<E>());
                    boolean bl2 = false;
                    this.accept((JsNode)x.getThenStatement());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    analyze.1 bl2 = this_$iv;
                    Collection collection = bl2.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
                JsStatement jsStatement = x.getElseStatement();
                if (jsStatement != null) {
                    JsStatement jsStatement2 = jsStatement;
                    boolean bl = false;
                    boolean bl3 = false;
                    JsStatement it = jsStatement2;
                    boolean bl4 = false;
                    analyze.1 this_$iv2 = this;
                    boolean $i$f$withNewScope2 = false;
                    Set<JsName> localVarsBackup$iv2 = this_$iv2.getLocalVars();
                    try {
                        boolean bl5 = false;
                        this_$iv2.setLocalVars((Set<JsName>)new LinkedHashSet<E>());
                        boolean bl6 = false;
                        this.accept((JsNode)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        analyze.1 var12_26 = this_$iv2;
                        Collection collection = var12_26.getCurrentScope();
                        Iterable iterable = this_$iv2.getLocalVars();
                        boolean bl7 = false;
                        CollectionsKt.removeAll(collection, iterable);
                        this_$iv2.setLocalVars(localVarsBackup$iv2);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCase(@NotNull JsCase x) {
                Intrinsics.checkNotNullParameter(x, "x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    boolean bl = false;
                    this_$iv.setLocalVars((Set<JsName>)new LinkedHashSet<E>());
                    boolean bl2 = false;
                    super.visitCase(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    analyze.1 var6_9 = this_$iv;
                    Collection collection = var6_9.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitDefault(@NotNull JsDefault x) {
                Intrinsics.checkNotNullParameter(x, "x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    boolean bl = false;
                    this_$iv.setLocalVars((Set<JsName>)new LinkedHashSet<E>());
                    boolean bl2 = false;
                    super.visitDefault(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    analyze.1 var6_9 = this_$iv;
                    Collection collection = var6_9.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter(x, "x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    boolean bl = false;
                    this_$iv.setLocalVars((Set<JsName>)new LinkedHashSet<E>());
                    boolean bl2 = false;
                    super.visitCatch(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    analyze.1 var6_9 = this_$iv;
                    Collection collection = var6_9.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    boolean bl = false;
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter(x, "x");
                for (JsName freeVar : CollectUtilsKt.collectFreeVariables(x)) {
                    TemporaryVariableElimination.access$useVariable(this.this$0, freeVar);
                    TemporaryVariableElimination.access$useVariable(this.this$0, freeVar);
                }
            }

            private final void addVar(JsName name2) {
                analyze.1 var2_2 = this;
                Collection collection = var2_2.currentScope;
                boolean bl = false;
                collection.add(name2);
                this.localVars.add(name2);
            }

            public static final /* synthetic */ void access$visitBinaryExpression$s-11928845(analyze.1 $this, JsBinaryOperation x) {
                super.visitBinaryExpression(x);
            }

            public static final /* synthetic */ void access$visitExpressionStatement$s-11928845(analyze.1 $this, JsExpressionStatement x) {
                super.visitExpressionStatement(x);
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final List<Pair<JsName, JsNode>> lastAssignedVars;
            final /* synthetic */ TemporaryVariableElimination this$0;
            {
                this.this$0 = $receiver;
                boolean bl = false;
                this.lastAssignedVars = new ArrayList<E>();
            }

            @NotNull
            public final List<Pair<JsName, JsNode>> getLastAssignedVars() {
                return this.lastAssignedVars;
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter(x, "x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
                JsExpression expression2 = jsExpression;
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName name2 = pair.component1();
                    JsExpression value2 = pair.component2();
                    Intrinsics.checkNotNullExpressionValue(name2, "name");
                    Intrinsics.checkNotNullExpressionValue(value2, "value");
                    this.handleDefinition(name2, value2, x);
                } else if (this.handleExpression(expression2)) {
                    this.invalidateTemporaries();
                }
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkNotNullParameter(x, "x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsExpression initializer2 = v.getInitExpression();
                    if (initializer2 == null) continue;
                    JsName jsName = v.getName();
                    Intrinsics.checkNotNullExpressionValue(jsName, "v.name");
                    Intrinsics.checkNotNullExpressionValue(v, "v");
                    this.handleDefinition(jsName, initializer2, v);
                }
            }

            private final void handleDefinition(JsName name2, JsExpression value2, JsNode node) {
                boolean sideEffects;
                boolean bl = sideEffects = this.handleExpression(value2) || !TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name2);
                if (TemporaryVariableElimination.access$shouldConsiderTemporary(this.this$0, name2)) {
                    if (TemporaryVariableElimination.access$isTrivial(this.this$0, value2)) {
                        TemporaryVariableElimination temporaryVariableElimination = this.this$0;
                        Collection collection = TemporaryVariableElimination.access$getStatementsToRemove$p(temporaryVariableElimination);
                        boolean bl2 = false;
                        collection.add(node);
                        temporaryVariableElimination = this.this$0;
                        collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(temporaryVariableElimination);
                        bl2 = false;
                        collection.add(name2);
                    } else {
                        Object object = this;
                        Collection collection = object.lastAssignedVars;
                        Pair<JsName, JsNode> pair = new Pair<JsName, JsNode>(name2, node);
                        boolean bl3 = false;
                        collection.add(pair);
                        if (sideEffects) {
                            object = this.this$0;
                            collection = TemporaryVariableElimination.access$getNamesWithSideEffects$p((TemporaryVariableElimination)object);
                            boolean bl4 = false;
                            collection.add(name2);
                        }
                    }
                } else if (sideEffects) {
                    this.invalidateTemporaries();
                }
            }

            public void visitIf(@NotNull JsIf x) {
                Intrinsics.checkNotNullParameter(x, "x");
                JsNode jsNode = x.getIfExpression();
                Intrinsics.checkNotNullExpressionValue(jsNode, "x.ifExpression");
                this.handleExpression((JsExpression)jsNode);
                this.invalidateTemporaries();
                this.accept((JsNode)x.getThenStatement());
                this.invalidateTemporaries();
                jsNode = x.getElseStatement();
                if (jsNode != null) {
                    JsNode jsNode2 = jsNode;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsNode it = jsNode2;
                    boolean bl3 = false;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkNotNullParameter(x, "x");
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression jsExpression2 = jsExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsExpression it = jsExpression2;
                    boolean bl3 = false;
                    this.handleExpression(it);
                }
                this.invalidateTemporaries();
            }

            public void visitThrow(@NotNull JsThrow x) {
                Intrinsics.checkNotNullParameter(x, "x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkNotNullParameter(x, "x");
                Object object = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(object, "x.expression");
                this.handleExpression((JsExpression)object);
                this.invalidateTemporaries();
                object = x.getCases();
                Intrinsics.checkNotNullExpressionValue(object, "x.cases");
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsSwitchMember it = (JsSwitchMember)element$iv;
                    boolean bl = false;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkNotNullParameter(x, "x");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.invalidateTemporaries();
                super.visitWhile(x);
                this.invalidateTemporaries();
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.invalidateTemporaries();
                super.visitDoWhile(x);
                this.invalidateTemporaries();
            }

            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkNotNullParameter(x, "x");
                JsExpression jsExpression = x.getObjectExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "x.objectExpression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitFor(@NotNull JsFor x) {
                JsVars it;
                boolean bl;
                boolean bl2;
                JsVars jsVars;
                Intrinsics.checkNotNullParameter(x, "x");
                SourceInfoAwareJsNode sourceInfoAwareJsNode = x.getInitVars();
                if (sourceInfoAwareJsNode != null) {
                    jsVars = sourceInfoAwareJsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl3 = false;
                    this.accept((JsNode)it);
                }
                sourceInfoAwareJsNode = x.getInitExpression();
                if (sourceInfoAwareJsNode != null) {
                    jsVars = sourceInfoAwareJsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl4 = false;
                    this.handleExpression((JsExpression)((Object)it));
                }
                this.invalidateTemporaries();
                sourceInfoAwareJsNode = x.getCondition();
                if (sourceInfoAwareJsNode != null) {
                    jsVars = sourceInfoAwareJsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl5 = false;
                    this.accept((JsNode)it);
                }
                sourceInfoAwareJsNode = x.getIncrementExpression();
                if (sourceInfoAwareJsNode != null) {
                    jsVars = sourceInfoAwareJsNode;
                    bl2 = false;
                    bl = false;
                    it = jsVars;
                    boolean bl6 = false;
                    this.accept((JsNode)it);
                }
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitTry(@NotNull JsTry x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.invalidateTemporaries();
                super.visitTry(x);
                this.invalidateTemporaries();
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.invalidateTemporaries();
                super.visitCatch(x);
                this.invalidateTemporaries();
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.invalidateTemporaries();
                super.visitLabel(x);
                this.invalidateTemporaries();
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.invalidateTemporaries();
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.invalidateTemporaries();
            }

            private final void invalidateTemporaries() {
                this.lastAssignedVars.clear();
            }

            private final boolean handleExpression(JsExpression expression2) {
                SubstitutionCandidateFinder candidateFinder = this.this$0.new SubstitutionCandidateFinder();
                candidateFinder.accept((JsNode)expression2);
                List<JsName> candidates2 = candidateFinder.getSubstitutableVariableReferences();
                while (true) {
                    Object object = this.lastAssignedVars;
                    boolean bl = false;
                    if (!(!object.isEmpty())) break;
                    object = CollectionsKt.last(this.lastAssignedVars);
                    JsName assignedVar = (JsName)((Pair)object).component1();
                    JsNode assignedStatement = (JsNode)((Pair)object).component2();
                    int candidateIndex = candidates2.lastIndexOf(assignedVar);
                    if (candidateIndex < 0) break;
                    TemporaryVariableElimination temporaryVariableElimination = this.this$0;
                    Collection collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(temporaryVariableElimination);
                    boolean bl2 = false;
                    collection.add(assignedVar);
                    temporaryVariableElimination = this.this$0;
                    collection = TemporaryVariableElimination.access$getStatementsToRemove$p(temporaryVariableElimination);
                    bl2 = false;
                    collection.add(assignedStatement);
                    if (TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0).contains(assignedVar)) {
                        candidateFinder.setSideEffectOccurred(true);
                    }
                    candidates2 = candidates2.subList(0, candidateIndex);
                    this.lastAssignedVars.remove(CollectionsKt.getLastIndex(this.lastAssignedVars));
                }
                return candidateFinder.getSideEffectOccurred();
            }
        }.accept((JsNode)this.root);
    }

    private final void cleanUp() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryVariableElimination this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsVars x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                Collection<JsVars.JsVar> collection = x.getVars();
                Intrinsics.checkNotNullExpressionValue(collection, "x.vars");
                collection = collection;
                Object object = (List<JsVars.JsVar>)((Object)TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0));
                boolean bl = false;
                if (TypeIntrinsics.asMutableCollection(collection).removeAll((Collection<?>)object)) {
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                }
                object = x.getVars();
                Intrinsics.checkNotNullExpressionValue(object, "x.vars");
                List<Pair<List<JsVars.JsVar>, S>> ranges2 = UtilsKt.splitToRanges(object, (Function1)new Function1<JsVars.JsVar, Boolean>(this.this$0){
                    final /* synthetic */ TemporaryVariableElimination this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final boolean invoke(JsVars.JsVar it) {
                        JsName jsName = it.getName();
                        Intrinsics.checkNotNullExpressionValue(jsName, "it.name");
                        return TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, jsName);
                    }
                });
                if (ranges2.size() == 1 && !((Boolean)ranges2.get(0).getSecond()).booleanValue()) {
                    return super.visit(x, ctx);
                }
                TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                for (Pair pair : ranges2) {
                    void $this$visit_u24lambda_u2d3;
                    Unit unit;
                    JsContext<JsNode> jsContext;
                    Object $this$mapNotNullTo$iv$iv;
                    List subList = (List)pair.component1();
                    boolean isRemoved = (Boolean)pair.component2();
                    Iterable $this$mapNotNull$iv = subList;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        JsExpression jsExpression;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        JsVars.JsVar it = (JsVars.JsVar)element$iv$iv;
                        boolean bl3 = false;
                        if (it.getInitExpression() == null) continue;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        JsExpression it$iv$iv = jsExpression;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List initializers = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = initializers;
                    boolean $i$f$forEach2 = false;
                    $this$mapNotNullTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$mapNotNullTo$iv$iv.hasNext()) {
                        T element$iv = $this$mapNotNullTo$iv$iv.next();
                        JsExpression it = (JsExpression)element$iv;
                        boolean bl7 = false;
                        this.accept((JsNode)it);
                    }
                    if (isRemoved) {
                        for (JsExpression initializer2 : initializers) {
                            void $this$visit_u24lambda_u2d2;
                            $this$mapNotNullTo$iv$iv = new JsExpressionStatement((JsExpression)this.accept((JsNode)initializer2));
                            boolean element$iv = false;
                            boolean it = false;
                            Object bl7 = $this$mapNotNullTo$iv$iv;
                            jsContext = ctx;
                            boolean bl8 = false;
                            MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u2d2, true);
                            unit = Unit.INSTANCE;
                            jsContext.addPrevious((JsNode)$this$mapNotNullTo$iv$iv);
                        }
                        continue;
                    }
                    Object $this$toTypedArray$iv = subList;
                    boolean $i$f$toTypedArray = false;
                    Object thisCollection$iv = $this$toTypedArray$iv;
                    JsVars.JsVar[] jsVarArray = thisCollection$iv.toArray(new JsVars.JsVar[0]);
                    if (jsVarArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Object object2 = jsVarArray;
                    JsVars.JsVar[] jsVarArray2 = new JsVars.JsVar[((JsVars.JsVar[])object2).length];
                    System.arraycopy(object2, 0, jsVarArray2, 0, ((JsVars.JsVar[])object2).length);
                    object2 = new JsVars(jsVarArray2);
                    boolean bl9 = false;
                    boolean bl10 = false;
                    thisCollection$iv = object2;
                    jsContext = ctx;
                    boolean bl11 = false;
                    MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u2d3, true);
                    unit = Unit.INSTANCE;
                    jsContext.addPrevious((JsNode)object2);
                }
                ctx.removeMe();
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Pair<JsName, JsExpression> assignment;
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                if (TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    ctx.removeMe();
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                    return false;
                }
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null && CollectionsKt.contains(TemporaryVariableElimination.access$getLocalVariables$p(this.this$0), ((JsNameRef)expression2).getName())) {
                    MetadataProperties.setSynthetic(x, true);
                }
                if ((assignment = JsAstUtils.decomposeAssignmentToVariable(expression2)) != null) {
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName name2 = pair.component1();
                    JsExpression value2 = pair.component2();
                    Intrinsics.checkNotNullExpressionValue(name2, "name");
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, name2)) {
                        void $this$visit_u24lambda_u2d4;
                        TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                        JsNode jsNode = this.accept((JsNode)new JsExpressionStatement(value2));
                        boolean bl = false;
                        boolean bl2 = false;
                        JsExpressionStatement jsExpressionStatement = (JsExpressionStatement)jsNode;
                        JsContext<JsNode> jsContext = ctx;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue($this$visit_u24lambda_u2d4, "");
                        MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u2d4, true);
                        Unit unit = Unit.INSTANCE;
                        jsContext.replaceMe(jsNode);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
                return super.visit(x, ctx);
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                JsName name2 = x.getName();
                if (name2 != null && x.getQualifier() == null && TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0).contains(name2)) {
                    void $this$visit_u24lambda_u2d5;
                    JsExpression jsExpression = (JsExpression)TemporaryVariableElimination.access$getDefinedValues$p(this.this$0).get(name2);
                    Intrinsics.checkNotNull(jsExpression);
                    JsExpression replacement = (JsExpression)this.accept((JsNode)jsExpression);
                    jsExpression = replacement.deepCopy();
                    boolean bl = false;
                    boolean bl2 = false;
                    JsExpression jsExpression2 = jsExpression;
                    JsContext<JsNode> jsContext = ctx;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue($this$visit_u24lambda_u2d5, "");
                    MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u2d5, true);
                    Unit unit = Unit.INSTANCE;
                    jsContext.replaceMe((JsNode)jsExpression);
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                return false;
            }

            public boolean visit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                return false;
            }

            public boolean visit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void endVisit(@NotNull JsBinaryOperation x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x);
                if (assignment != null) {
                    JsName name2 = assignment.getFirst();
                    Intrinsics.checkNotNullExpressionValue(name2, "name");
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, name2)) {
                        void $this$endVisit_u24lambda_u2d6;
                        JsNode jsNode = this.accept((JsNode)x.getArg2());
                        boolean bl = false;
                        boolean bl2 = false;
                        JsExpression jsExpression = (JsExpression)jsNode;
                        JsContext<JsNode> jsContext = ctx;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue($this$endVisit_u24lambda_u2d6, "");
                        MetadataProperties.setSynthetic((HasMetadata)$this$endVisit_u24lambda_u2d6, true);
                        Unit unit = Unit.INSTANCE;
                        jsContext.replaceMe(jsNode);
                    }
                }
                super.endVisit(x, ctx);
            }
        }.accept((JsNode)this.root);
    }

    private final void assignVariable(JsName name2, JsExpression value2) {
        Map<JsName, Object> map2 = this.definitions;
        Integer n = this.definitions.get(name2);
        n = (n == null ? 0 : n) + 1;
        boolean bl = false;
        map2.put(name2, n);
        map2 = this.definedValues;
        boolean bl2 = false;
        map2.put(name2, (Integer)((Object)value2));
    }

    private final void useVariable(JsName name2) {
        Map<JsName, Integer> map2 = this.usages;
        Integer n = this.usages.get(name2);
        n = (n == null ? 0 : n) + 1;
        boolean bl = false;
        map2.put(name2, n);
    }

    private final boolean shouldConsiderUnused(JsName name2) {
        Integer n = this.definitions.get(name2);
        return (n == null ? 0 : n) > 0 && ((n = this.usages.get(name2)) == null ? 0 : n) == 0 && this.temporary.contains(name2) && !MetadataProperties.getImported(name2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderTemporary(JsName name2) {
        Integer n = this.definitions.get(name2);
        int n2 = 1;
        if (n == null) return false;
        if (n != n2) return false;
        if (!this.temporary.contains(name2)) {
            return false;
        }
        JsExpression expr = this.definedValues.get(name2);
        if (expr != null) {
            if (this.isTrivial(expr)) return true;
        }
        Integer n3 = this.usages.get(name2);
        int n4 = 1;
        if (n3 == null) return false;
        if (n3 != n4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrivial(JsExpression expr) {
        JsExpression jsExpression = expr;
        if (jsExpression instanceof JsNameRef) {
            boolean bl;
            JsExpression qualifier = ((JsNameRef)expr).getQualifier();
            if (MetadataProperties.getSideEffects(expr) == SideEffectKind.PURE && (qualifier == null || this.isTrivial(qualifier))) {
                if (CollectionsKt.contains((Iterable)this.temporary, ((JsNameRef)expr).getName())) return false;
                return true;
            }
            JsName name2 = ((JsNameRef)expr).getName();
            if (!CollectionsKt.contains((Iterable)this.localVariables, name2)) return false;
            Map<JsName, Integer> map2 = this.definitions;
            boolean bl2 = false;
            Integer n = map2.get(name2);
            if (n == null) {
                return true;
            }
            boolean bl3 = false;
            if (n == 0) {
                return true;
            }
            boolean bl4 = false;
            if (bl4) {
                return true;
            }
            Integer n2 = n;
            int n3 = 1;
            if (n2 == null) return false;
            if (n2 != n3) return false;
            if (!CollectionsKt.contains((Iterable)this.namesToSubstitute, name2)) return true;
            Map<JsName, JsExpression> map3 = this.definedValues;
            boolean bl5 = false;
            JsExpression jsExpression2 = map3.get(name2);
            if (jsExpression2 == null) {
                return false;
            }
            JsExpression jsExpression3 = jsExpression2;
            boolean bl6 = false;
            boolean bl7 = false;
            JsExpression it = jsExpression3;
            boolean bl8 = false;
            boolean bl9 = bl = this.isTrivial(it);
            if (!bl9) return false;
            return true;
        }
        if (jsExpression instanceof JsLiteral.JsValueLiteral) {
            if (expr.toString().length() >= 10) return false;
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression it;
            if (MetadataProperties.getSideEffects(expr) != SideEffectKind.PURE) return false;
            Object qualifier = ((JsInvocation)expr).getQualifier();
            Intrinsics.checkNotNullExpressionValue(qualifier, "expr.qualifier");
            if (!this.isTrivial((JsExpression)qualifier)) return false;
            qualifier = ((JsInvocation)expr).getArguments();
            Intrinsics.checkNotNullExpressionValue(qualifier, "expr.arguments");
            Iterable $this$all$iv = (Iterable)qualifier;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (JsExpression)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
            } while (this.isTrivial(it));
            return false;
        }
        if (!(jsExpression instanceof JsArrayAccess)) return false;
        JsExpression jsExpression4 = ((JsArrayAccess)expr).getArrayExpression();
        Intrinsics.checkNotNullExpressionValue(jsExpression4, "expr.arrayExpression");
        if (!this.isTrivial(jsExpression4)) return false;
        jsExpression4 = ((JsArrayAccess)expr).getIndexExpression();
        Intrinsics.checkNotNullExpressionValue(jsExpression4, "expr.indexExpression");
        if (!this.isTrivial(jsExpression4)) return false;
        if (MetadataProperties.getSideEffects(expr) != SideEffectKind.PURE) return false;
        return true;
    }

    public static final /* synthetic */ JsFunction access$getFunction$p(TemporaryVariableElimination $this) {
        return $this.function;
    }

    public static final /* synthetic */ void access$assignVariable(TemporaryVariableElimination $this, JsName name2, JsExpression value2) {
        $this.assignVariable(name2, value2);
    }

    public static final /* synthetic */ Set access$getTemporary$p(TemporaryVariableElimination $this) {
        return $this.temporary;
    }

    public static final /* synthetic */ void access$useVariable(TemporaryVariableElimination $this, JsName name2) {
        $this.useVariable(name2);
    }

    public static final /* synthetic */ boolean access$isTrivial(TemporaryVariableElimination $this, JsExpression expr) {
        return $this.isTrivial(expr);
    }

    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryVariableElimination $this) {
        return $this.statementsToRemove;
    }

    public static final /* synthetic */ Set access$getNamesWithSideEffects$p(TemporaryVariableElimination $this) {
        return $this.namesWithSideEffects;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryVariableElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    public static final /* synthetic */ boolean access$shouldConsiderUnused(TemporaryVariableElimination $this, JsName name2) {
        return $this.shouldConsiderUnused(name2);
    }

    public static final /* synthetic */ Map access$getDefinedValues$p(TemporaryVariableElimination $this) {
        return $this.definedValues;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020'H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination$SubstitutionCandidateFinder;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;)V", "sideEffectOccurred", "", "getSideEffectOccurred", "()Z", "setSideEffectOccurred", "(Z)V", "substitutableVariableReferences", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getSubstitutableVariableReferences", "()Ljava/util/List;", "visitArray", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayLiteral;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "visitConditional", "Lorg/jetbrains/kotlin/js/backend/ast/JsConditional;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitNew", "Lorg/jetbrains/kotlin/js/backend/ast/JsNew;", "visitObjectLiteral", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "visitPostfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "js.translator"})
    private final class SubstitutionCandidateFinder
    extends RecursiveJsVisitor {
        @NotNull
        private final List<JsName> substitutableVariableReferences;
        private boolean sideEffectOccurred;

        public SubstitutionCandidateFinder() {
            Intrinsics.checkNotNullParameter(TemporaryVariableElimination.this, "this$0");
            boolean bl = false;
            this.substitutableVariableReferences = new ArrayList();
        }

        @NotNull
        public final List<JsName> getSubstitutableVariableReferences() {
            return this.substitutableVariableReferences;
        }

        public final boolean getSideEffectOccurred() {
            return this.sideEffectOccurred;
        }

        public final void setSideEffectOccurred(boolean bl) {
            this.sideEffectOccurred = bl;
        }

        @Override
        public void visitFunction(@NotNull JsFunction x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
            Intrinsics.checkNotNullParameter(x, "x");
            for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                this.accept((JsNode)initializer2.getValueExpr());
            }
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitNew(@NotNull JsNew x) {
            Intrinsics.checkNotNullParameter(x, "x");
            super.visitNew(x);
            if (MetadataProperties.getSideEffects(x) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitInvocation(@NotNull JsInvocation invocation) {
            Intrinsics.checkNotNullParameter(invocation, "invocation");
            super.visitInvocation(invocation);
            if (MetadataProperties.getSideEffects(invocation) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitConditional(@NotNull JsConditional x) {
            Intrinsics.checkNotNullParameter(x, "x");
            this.accept((JsNode)x.getTestExpression());
        }

        @Override
        public void visitArrayAccess(@NotNull JsArrayAccess x) {
            Intrinsics.checkNotNullParameter(x, "x");
            super.visitArrayAccess(x);
            if (MetadataProperties.getSideEffects(x) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitArray(@NotNull JsArrayLiteral x) {
            Intrinsics.checkNotNullParameter(x, "x");
            super.visitArray(x);
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
            Intrinsics.checkNotNullParameter(x, "x");
            super.visitPrefixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            int n = jsUnaryOperator == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsUnaryOperator.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
            Intrinsics.checkNotNullParameter(x, "x");
            super.visitPostfixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            int n = jsUnaryOperator == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsUnaryOperator.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitNameRef(@NotNull JsNameRef nameRef) {
            Intrinsics.checkNotNullParameter(nameRef, "nameRef");
            JsName name2 = nameRef.getName();
            if (name2 != null && TemporaryVariableElimination.this.localVariables.contains(name2)) {
                if (!TemporaryVariableElimination.this.namesToSubstitute.contains(name2) && TemporaryVariableElimination.this.shouldConsiderTemporary(name2) && !this.sideEffectOccurred) {
                    SubstitutionCandidateFinder substitutionCandidateFinder = this;
                    Collection collection = substitutionCandidateFinder.substitutableVariableReferences;
                    boolean bl = false;
                    collection.add(name2);
                }
            } else {
                super.visitNameRef(nameRef);
                if (MetadataProperties.getSideEffects(nameRef) == SideEffectKind.AFFECTS_STATE) {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
            Intrinsics.checkNotNullParameter(x, "x");
            if (x.getOperator() == JsBinaryOperator.ASG) {
                JsExpression left = x.getArg1();
                JsExpression right = x.getArg2();
                if (left instanceof JsNameRef) {
                    JsExpression qualifier = ((JsNameRef)left).getQualifier();
                    if (qualifier != null) {
                        this.accept((JsNode)qualifier);
                    }
                } else if (left instanceof JsArrayAccess) {
                    this.accept((JsNode)((JsArrayAccess)left).getArrayExpression());
                    this.accept((JsNode)((JsArrayAccess)left).getIndexExpression());
                }
                this.accept((JsNode)right);
                this.sideEffectOccurred = true;
            } else if (x.getOperator() == JsBinaryOperator.AND || x.getOperator() == JsBinaryOperator.OR) {
                this.accept((JsNode)x.getArg1());
                this.sideEffectOccurred = true;
                this.accept((JsNode)x.getArg2());
            } else {
                super.visitBinaryExpression(x);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsUnaryOperator.values().length];
                nArray[JsUnaryOperator.INC.ordinal()] = 1;
                nArray[JsUnaryOperator.DEC.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

