/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverterKt;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\u000e\u001a\u00020\u0005J\u001f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ComplementarySourceFilesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "value", "get", "sourceFile", "remove", "file", "set", "", "complementaryFiles", "kotlin-build-common"})
public final class ComplementarySourceFilesMap
extends BasicStringMap<Collection<? extends String>> {
    @NotNull
    private final FileToPathConverter pathConverter;

    public ComplementarySourceFilesMap(@NotNull File storageFile, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(pathConverter, "pathConverter");
        super(storageFile, PathStringDescriptor.INSTANCE, (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }

    public final void set(@NotNull File sourceFile, @NotNull Collection<? extends File> complementaryFiles) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Intrinsics.checkNotNullParameter(complementaryFiles, "complementaryFiles");
        this.getStorage().set(this.pathConverter.toPath(sourceFile), FileToPathConverterKt.toPaths(this.pathConverter, complementaryFiles));
    }

    @NotNull
    public final Collection<File> get(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
        Collection collection = (Collection)this.getStorage().get(this.pathConverter.toPath(sourceFile));
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            collection2 = CollectionsKt.emptyList();
        }
        Collection paths = collection2;
        return FileToPathConverterKt.toFiles(this.pathConverter, paths);
    }

    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        return IncrementalJvmCacheKt.dumpCollection(value2);
    }

    @NotNull
    public final Collection<File> remove(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Collection<File> collection = this.get(file2);
        boolean bl = false;
        boolean bl2 = false;
        Collection<File> it = collection;
        boolean bl3 = false;
        this.getStorage().remove(this.pathConverter.toPath(file2));
        return collection;
    }
}

