/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBooleanTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitIntTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitStringTypeRef;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContextBase;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;", "", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "generateDataClassComponentBody", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "generateDataClassCopyBody", "generateDataClassMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateInlineClassMembers", "Companion", "MyDataClassMethodsGenerator", "fir2ir"})
public final class DataClassMembersGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private static final Name copyName;
    @NotNull
    private static final Name equalsName;
    @NotNull
    private static final Name hashCodeName;
    @NotNull
    private static final Name toStringName;

    public DataClassMembersGenerator(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.components = components2;
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    @NotNull
    public final List<FirDeclaration> generateInlineClassMembers(@NotNull FirClass<?> klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_INLINE_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    @NotNull
    public final List<FirDeclaration> generateDataClassMembers(@NotNull FirClass<?> klass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        return new MyDataClassMethodsGenerator(irClass2, klass.getSymbol().toLookupTag(), IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generate(klass);
    }

    public final void generateDataClassComponentBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(lookupTag, "lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateComponentBody(irFunction2);
    }

    public final void generateDataClassCopyBody(@NotNull IrFunction irFunction2, @NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(lookupTag, "lookupTag");
        new MyDataClassMethodsGenerator(IrUtilsKt.getParentAsClass(irFunction2), lookupTag, IrDeclarationOrigin.GENERATED_DATA_CLASS_MEMBER.INSTANCE).generateCopyBody(irFunction2);
    }

    static {
        Name name2 = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"copy\")");
        copyName = name2;
        name2 = Name.identifier("equals");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"equals\")");
        equalsName = name2;
        name2 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"hashCode\")");
        hashCodeName = name2;
        name2 = Name.identifier("toString");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"toString\")");
        toStringName = name2;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0013H\u0002J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.J\u000e\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u000e\u00101\u001a\u0002002\u0006\u0010&\u001a\u00020\u001eJ\u0016\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u00103\u001a\u000204R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0018\u0010\u0019\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0018\u0010\u001b\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "origin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irDataClassMembersGenerator", "org/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1", "Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$MyDataClassMethodsGenerator$irDataClassMembersGenerator$1;", "getLookupTag", "()Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "getOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "matchesDataClassSyntheticMemberSignatures", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "createSyntheticIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "name", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "otherParameterNeeded", "createSyntheticIrParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irFunction", "type", "index", "", "generate", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "generateComponentBody", "", "generateCopyBody", "generateDispatchReceiverParameter", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/ir/descriptors/WrappedValueParameterDescriptor;", "fir2ir"})
    private final class MyDataClassMethodsGenerator {
        @NotNull
        private final IrClass irClass;
        @NotNull
        private final ConeClassLikeLookupTag lookupTag;
        @NotNull
        private final IrDeclarationOrigin origin;
        @NotNull
        private final irDataClassMembersGenerator.1 irDataClassMembersGenerator;

        public MyDataClassMethodsGenerator(@NotNull IrClass irClass2, @NotNull ConeClassLikeLookupTag lookupTag, IrDeclarationOrigin origin) {
            Intrinsics.checkNotNullParameter(DataClassMembersGenerator.this, "this$0");
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            Intrinsics.checkNotNullParameter(lookupTag, "lookupTag");
            Intrinsics.checkNotNullParameter(origin, "origin");
            this.irClass = irClass2;
            this.lookupTag = lookupTag;
            this.origin = origin;
            IrGeneratorContextBase irGeneratorContextBase = new IrGeneratorContextBase(DataClassMembersGenerator.this.getComponents().getIrBuiltIns());
            SymbolTable symbolTable = DataClassMembersGenerator.this.getComponents().getSymbolTable();
            IrClass irClass3 = this.irClass;
            IrDeclarationOrigin irDeclarationOrigin = this.origin;
            this.irDataClassMembersGenerator = new org.jetbrains.kotlin.ir.util.DataClassMembersGenerator(DataClassMembersGenerator.this, irGeneratorContextBase, symbolTable, irClass3, irDeclarationOrigin){
                final /* synthetic */ DataClassMembersGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                }

                @NotNull
                public IrFunction declareSimpleFunction(int startOffset, int endOffset, @NotNull FunctionDescriptor functionDescriptor) {
                    Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
                    throw new IllegalStateException("Not expect to see function declaration.");
                }

                public void generateSyntheticFunctionParameterDeclarations(@NotNull IrFunction irFunction2) {
                    Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
                }

                @Nullable
                public IrProperty getProperty(@Nullable ValueParameterDescriptor parameter, @Nullable IrValueParameter irValueParameter) {
                    IrProperty irProperty2;
                    IrValueParameter irValueParameter2 = irValueParameter;
                    if (irValueParameter2 == null) {
                        irProperty2 = null;
                    } else {
                        IrValueParameter irValueParameter3 = irValueParameter2;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrValueParameter it = irValueParameter3;
                        boolean bl3 = false;
                        Sequence<IrProperty> $this$single$iv = IrUtilsKt.getProperties(this.getIrClass());
                        boolean $i$f$single = false;
                        IrProperty single$iv = null;
                        boolean found$iv = false;
                        Iterator<IrProperty> iterator2 = $this$single$iv.iterator();
                        while (iterator2.hasNext()) {
                            IrField irField;
                            IrProperty element$iv;
                            IrProperty irProperty3 = element$iv = iterator2.next();
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual(irProperty3.getName(), irValueParameter.getName()) && Intrinsics.areEqual((irField = irProperty3.getBackingField()) == null ? null : irField.getType(), irValueParameter.getType()))) continue;
                            if (found$iv) {
                                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        irProperty2 = single$iv;
                    }
                    return irProperty2;
                }

                @NotNull
                public IrType transform(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                    Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
                    return this.this$0.getComponents().getIrBuiltIns().getAnyType();
                }

                public void commitSubstituted(@NotNull IrMemberAccessExpression<?> irMemberAccessExpression, @NotNull CallableDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter(irMemberAccessExpression, "irMemberAccessExpression");
                    Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                }
            };
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @NotNull
        public final ConeClassLikeLookupTag getLookupTag() {
            return this.lookupTag;
        }

        @NotNull
        public final IrDeclarationOrigin getOrigin() {
            return this.origin;
        }

        @NotNull
        public final IrValueParameter generateDispatchReceiverParameter(@NotNull IrFunction irFunction2, @NotNull WrappedValueParameterDescriptor valueParameterDescriptor) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            Intrinsics.checkNotNullParameter(valueParameterDescriptor, "valueParameterDescriptor");
            IrValueParameter irValueParameter = ConversionUtilsKt.declareThisReceiverParameter(irFunction2, DataClassMembersGenerator.this.getComponents().getSymbolTable(), IrUtilsKt.getDefaultType(this.irClass), this.origin, -1, -1);
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameter $this$generateDispatchReceiverParameter_u24lambda_u2d0 = irValueParameter;
            boolean bl3 = false;
            valueParameterDescriptor.bind((IrDeclaration)$this$generateDispatchReceiverParameter_u24lambda_u2d0);
            return irValueParameter;
        }

        private final boolean getMatchesEqualsSignature(FirSimpleFunction $this$matchesEqualsSignature) {
            return $this$matchesEqualsSignature.getValueParameters().size() == 1 && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getValueParameters().get(0).getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getAnyNType()) && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesEqualsSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType());
        }

        private final boolean getMatchesHashCodeSignature(FirSimpleFunction $this$matchesHashCodeSignature) {
            return $this$matchesHashCodeSignature.getValueParameters().isEmpty() && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesHashCodeSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType());
        }

        private final boolean getMatchesToStringSignature(FirSimpleFunction $this$matchesToStringSignature) {
            return $this$matchesToStringSignature.getValueParameters().isEmpty() && Intrinsics.areEqual(Fir2IrTypeConverterKt.toIrType$default($this$matchesToStringSignature.getReturnTypeRef(), DataClassMembersGenerator.this.getComponents().getTypeConverter(), null, 2, null), DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType());
        }

        private final boolean getMatchesDataClassSyntheticMemberSignatures(FirSimpleFunction $this$matchesDataClassSyntheticMemberSignatures) {
            return Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), equalsName) && this.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), hashCodeName) && this.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), toStringName) && this.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<FirDeclaration> generate(@NotNull FirClass<?> klass) {
            Object element$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            int n;
            Intrinsics.checkNotNullParameter(klass, "klass");
            Object object = IrUtilsKt.getPrimaryConstructor(this.irClass);
            List<IrValueParameter> list2 = object == null ? null : IrUtilsKt.getExplicitParameters((IrFunction)object);
            int propertyParametersCount = list2 == null ? 0 : (n = list2.size());
            object = this.irClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            void var6_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = CollectionsKt.take((List)destination$iv$iv, propertyParametersCount);
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo232 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrProperty irProperty2 = (IrProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PropertyDescriptor propertyDescriptor = it.getDescriptor();
                collection.add(propertyDescriptor);
            }
            List properties2 = (List)destination$iv$iv;
            if (properties2.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            $i$f$map = false;
            List result2 = new ArrayList();
            Iterable $this$mapNotNull$iv = klass.getDeclarations();
            boolean $i$f$mapNotNull232 = false;
            Iterable $i$f$mapTo232 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name name2;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirDeclaration it = (FirDeclaration)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof FirSimpleFunction && this.getMatchesDataClassSyntheticMemberSignatures((FirSimpleFunction)it) ? ((FirSimpleFunction)it).getName() : null) == null) continue;
                name2 = name2;
                boolean bl3 = false;
                boolean bl4 = false;
                Name it$iv$iv = name2;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List contributedFunctionsInThisType = (List)destination$iv$iv2;
            DataClassMembersGenerator $i$f$mapNotNull232 = DataClassMembersGenerator.this;
            boolean bl = false;
            boolean bl6 = false;
            bl6 = false;
            Map<Name, FirSimpleFunction> map2 = MapsKt.createMapBuilder();
            boolean bl7 = false;
            boolean bl8 = false;
            Map<Name, FirSimpleFunction> $this$generate_u24lambda_u2d3 = map2;
            boolean bl9 = false;
            element$iv$iv = new Name[]{equalsName, hashCodeName, toStringName};
            for (Name name3 : CollectionsKt.listOf(element$iv$iv)) {
                KotlinScopeProviderKt.unsubstitutedScope(klass, $i$f$mapNotNull232.getComponents().getSession(), $i$f$mapNotNull232.getComponents().getScopeSession(), true).processFunctionsByName(name3, new Function1<FirFunctionSymbol<?>, Unit>(this, $this$generate_u24lambda_u2d3){
                    final /* synthetic */ MyDataClassMethodsGenerator this$0;
                    final /* synthetic */ Map<Name, FirSimpleFunction> $this_anonymous;
                    {
                        this.this$0 = $receiver;
                        this.$this_anonymous = $receiver2;
                        super(1);
                    }

                    public final void invoke(@NotNull FirFunctionSymbol<?> it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        FirFunction declaration2 = (FirFunction)it.getFir();
                        if (declaration2 instanceof FirSimpleFunction && MyDataClassMethodsGenerator.access$getMatchesDataClassSyntheticMemberSignatures(this.this$0, (FirSimpleFunction)declaration2)) {
                            this.$this_anonymous.putIfAbsent(((FirSimpleFunction)declaration2).getName(), (FirSimpleFunction)declaration2);
                        }
                    }
                });
            }
            Map contributedFunctionsInSupertypes2 = MapsKt.build(map2);
            if (!contributedFunctionsInThisType.contains(equalsName) && MyDataClassMethodsGenerator.generate$isOverridableDeclaration(contributedFunctionsInSupertypes2, equalsName)) {
                result2.add(MapsKt.getValue(contributedFunctionsInSupertypes2, equalsName));
                IrFunction equalsFunction = this.createSyntheticIrFunction(equalsName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getBooleanType(), true);
                this.irDataClassMembersGenerator.generateEqualsMethod(equalsFunction, (List<? extends PropertyDescriptor>)properties2);
                this.irClass.getDeclarations().add(equalsFunction);
            }
            if (!contributedFunctionsInThisType.contains(hashCodeName) && MyDataClassMethodsGenerator.generate$isOverridableDeclaration(contributedFunctionsInSupertypes2, hashCodeName)) {
                result2.add(MapsKt.getValue(contributedFunctionsInSupertypes2, hashCodeName));
                IrFunction hashCodeFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, hashCodeName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getIntType(), false, 4, null);
                this.irDataClassMembersGenerator.generateHashCodeMethod(hashCodeFunction, (List<? extends PropertyDescriptor>)properties2);
                this.irClass.getDeclarations().add(hashCodeFunction);
            }
            if (!contributedFunctionsInThisType.contains(toStringName) && MyDataClassMethodsGenerator.generate$isOverridableDeclaration(contributedFunctionsInSupertypes2, toStringName)) {
                result2.add(MapsKt.getValue(contributedFunctionsInSupertypes2, toStringName));
                IrFunction toStringFunction = MyDataClassMethodsGenerator.createSyntheticIrFunction$default(this, toStringName, DataClassMembersGenerator.this.getComponents().getIrBuiltIns().getStringType(), false, 4, null);
                this.irDataClassMembersGenerator.generateToStringMethod(toStringFunction, (List<? extends PropertyDescriptor>)properties2);
                this.irClass.getDeclarations().add(toStringFunction);
            }
            return result2;
        }

        public final void generateComponentBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            Integer n = Companion.getComponentIndex(irFunction2);
            Intrinsics.checkNotNull(n);
            int index2 = n;
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull(irConstructor2);
            IrValueParameter valueParameter = irConstructor2.getValueParameters().get(index2 - 1);
            IrProperty irProperty2 = this.irDataClassMembersGenerator.getProperty(null, valueParameter);
            Intrinsics.checkNotNull(irProperty2);
            IrProperty irProperty3 = irProperty2;
            this.irDataClassMembersGenerator.generateComponentFunction(irFunction2, irProperty3);
        }

        public final void generateCopyBody(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(this.irClass);
            Intrinsics.checkNotNull(irConstructor2);
            this.irDataClassMembersGenerator.generateCopyFunction(irFunction2, (IrConstructorSymbol)irConstructor2.getSymbol());
        }

        /*
         * WARNING - void declaration
         */
        private final IrFunction createSyntheticIrFunction(Name name2, IrType returnType2, boolean otherParameterNeeded) {
            Object v2;
            IrSimpleFunction $this$createSyntheticIrFunction_u24lambda_u2d9;
            IrSimpleFunction irSimpleFunction;
            Object object;
            Object object2;
            Object object3;
            block12: {
                void $this$singleOrNull$iv;
                Iterable $this$toTypedArray$iv;
                Collection<ConeStarProjection> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Object object4;
                FirTypeRef firTypeRef;
                WrappedValueParameterDescriptor thisReceiverDescriptor = new WrappedValueParameterDescriptor();
                DataClassMembersGenerator dataClassMembersGenerator = DataClassMembersGenerator.this;
                boolean $i$f$buildSimpleFunction = false;
                boolean bl = false;
                object3 = new FirSimpleFunctionBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                FirSimpleFunctionBuilder $this$createSyntheticIrFunction_u24lambda_u2d6 = object3;
                boolean bl4 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d6.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                $this$createSyntheticIrFunction_u24lambda_u2d6.setName(name2);
                $this$createSyntheticIrFunction_u24lambda_u2d6.setSymbol(new FirNamedFunctionSymbol(new CallableId(this.getLookupTag().getClassId(), name2)));
                $this$createSyntheticIrFunction_u24lambda_u2d6.setStatus(new FirDeclarationStatusImpl(Visibilities.Public.INSTANCE, Modality.FINAL));
                $this$createSyntheticIrFunction_u24lambda_u2d6.setSession(dataClassMembersGenerator.getComponents().getSession());
                object2 = returnType2;
                if (Intrinsics.areEqual(object2, dataClassMembersGenerator.getComponents().getIrBuiltIns().getBooleanType())) {
                    firTypeRef = new FirImplicitBooleanTypeRef(null);
                } else if (Intrinsics.areEqual(object2, dataClassMembersGenerator.getComponents().getIrBuiltIns().getIntType())) {
                    firTypeRef = new FirImplicitIntTypeRef(null);
                } else if (Intrinsics.areEqual(object2, dataClassMembersGenerator.getComponents().getIrBuiltIns().getStringType())) {
                    firTypeRef = new FirImplicitStringTypeRef(null);
                } else {
                    String string2 = Intrinsics.stringPlus("Unexpected synthetic data class function return type: ", returnType2);
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                $this$createSyntheticIrFunction_u24lambda_u2d6.setReturnTypeRef(firTypeRef);
                if (otherParameterNeeded) {
                    void $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4;
                    boolean $i$f$buildValueParameter = false;
                    boolean bl6 = false;
                    FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    FirValueParameterBuilder firValueParameterBuilder2 = firValueParameterBuilder;
                    object4 = $this$createSyntheticIrFunction_u24lambda_u2d6.getValueParameters();
                    boolean bl9 = false;
                    Name name3 = Name.identifier("other");
                    Intrinsics.checkNotNullExpressionValue(name3, "identifier(\"other\")");
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setName(name3);
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setOrigin(FirDeclarationOrigin.Synthetic.INSTANCE);
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setSession(dataClassMembersGenerator.getComponents().getSession());
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setReturnTypeRef(new FirImplicitNullableAnyTypeRef(null));
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setSymbol(new FirVariableSymbol<FirValueParameter>($this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.getName()));
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setCrossinline(false);
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setNoinline(false);
                    $this$createSyntheticIrFunction_u24lambda_u2d6_u24lambda_u2d4.setVararg(false);
                    object = Unit.INSTANCE;
                    object4.add(firValueParameterBuilder.build());
                }
                Iterable $i$f$buildValueParameter = new IntRange(1, this.getIrClass().getTypeParameters().size());
                object = this.getLookupTag();
                object4 = $this$createSyntheticIrFunction_u24lambda_u2d6;
                boolean $i$f$map = false;
                void var15_22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator bl9 = $this$mapTo$iv$iv.iterator();
                while (bl9.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)bl9).nextInt();
                    collection = destination$iv$iv;
                    boolean bl10 = false;
                    ConeStarProjection coneStarProjection = ConeStarProjection.INSTANCE;
                    collection.add(coneStarProjection);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ConeStarProjection[] coneStarProjectionArray = thisCollection$iv.toArray(new ConeStarProjection[0]);
                if (coneStarProjectionArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ((FirSimpleFunctionBuilder)object4).setDispatchReceiverType(TypeConstructionUtilsKt.constructType$default((ConeClassifierLookupTag)object, coneStarProjectionArray, false, null, 4, null));
                FirSimpleFunction firFunction = ((FirSimpleFunctionBuilder)object3).build();
                IdSignature signature2 = this.lookupTag.getClassId().isLocal() ? null : Fir2IrSignatureComposer.DefaultImpls.composeSignature$default(DataClassMembersGenerator.this.getComponents().getSignatureComposer(), firFunction, null, 2, null);
                irSimpleFunction = DataClassMembersGenerator.this.getComponents().getDeclarationStorage().declareIrSimpleFunction$fir2ir(signature2, null, (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(DataClassMembersGenerator.this, this, name2, returnType2, otherParameterNeeded, firFunction){
                    final /* synthetic */ DataClassMembersGenerator this$0;
                    final /* synthetic */ MyDataClassMethodsGenerator this$1;
                    final /* synthetic */ Name $name;
                    final /* synthetic */ IrType $returnType;
                    final /* synthetic */ boolean $otherParameterNeeded;
                    final /* synthetic */ FirSimpleFunction $firFunction;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$name = $name;
                        this.$returnType = $returnType;
                        this.$otherParameterNeeded = $otherParameterNeeded;
                        this.$firFunction = $firFunction;
                        super(1);
                    }

                    @NotNull
                    public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol symbol2) {
                        Intrinsics.checkNotNullParameter(symbol2, "symbol");
                        IrFactory irFactory = this.this$0.getComponents().getIrFactory();
                        IrDeclarationOrigin irDeclarationOrigin = this.this$1.getOrigin();
                        Object object = DescriptorVisibilities.PUBLIC;
                        Intrinsics.checkNotNullExpressionValue(object, "PUBLIC");
                        object = IrFactory.DefaultImpls.createFunction$default(irFactory, -1, -1, irDeclarationOrigin, symbol2, this.$name, (DescriptorVisibility)object, Modality.OPEN, this.$returnType, false, false, false, false, false, false, false, false, null, 65536, null);
                        boolean bl = this.$otherParameterNeeded;
                        MyDataClassMethodsGenerator myDataClassMethodsGenerator = this.this$1;
                        FirSimpleFunction firSimpleFunction = this.$firFunction;
                        DataClassMembersGenerator dataClassMembersGenerator = this.this$0;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Object $this$invoke_u24lambda_u2d0 = object;
                        boolean bl4 = false;
                        if (bl) {
                            IrValueParameter irValueParameter = MyDataClassMethodsGenerator.createSyntheticIrParameter$default(myDataClassMethodsGenerator, (IrFunction)$this$invoke_u24lambda_u2d0, CollectionsKt.first(firSimpleFunction.getValueParameters()).getName(), dataClassMembersGenerator.getComponents().getIrBuiltIns().getAnyNType(), 0, 8, null);
                            ((IrFunction)$this$invoke_u24lambda_u2d0).setValueParameters(CollectionsKt.listOf(irValueParameter));
                        }
                        $this$invoke_u24lambda_u2d0.setMetadata(new FirMetadataSource.Function(firSimpleFunction));
                        return object;
                    }
                });
                object3 = DataClassMembersGenerator.this;
                bl2 = false;
                bl3 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d9 = irSimpleFunction;
                boolean bl11 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d9.setParent(this.getIrClass());
                $this$createSyntheticIrFunction_u24lambda_u2d9.setDispatchReceiverParameter(this.generateDispatchReceiverParameter($this$createSyntheticIrFunction_u24lambda_u2d9, thisReceiverDescriptor));
                $this$toTypedArray$iv = ((ClassDescriptor)((DataClassMembersGenerator)object3).getComponents().getIrBuiltIns().getAnyClass().getDescriptor()).getUnsubstitutedMemberScope().getContributedFunctions($this$createSyntheticIrFunction_u24lambda_u2d9.getName(), NoLookupLocation.FROM_BACKEND);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    SimpleFunctionDescriptor function2 = (SimpleFunctionDescriptor)element$iv;
                    boolean bl12 = false;
                    if (!Intrinsics.areEqual(function2.getName(), $this$createSyntheticIrFunction_u24lambda_u2d9.getName())) continue;
                    if (found$iv) {
                        v2 = null;
                        break block12;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            object = v2;
            if (object != null) {
                object2 = object;
                boolean bl = false;
                boolean bl13 = false;
                Object it = object2;
                boolean bl14 = false;
                $this$createSyntheticIrFunction_u24lambda_u2d9.setOverriddenSymbols(CollectionsKt.listOf(((DataClassMembersGenerator)object3).getComponents().getSymbolTable().referenceSimpleFunction((FunctionDescriptor)it)));
            }
            return irSimpleFunction;
        }

        static /* synthetic */ IrFunction createSyntheticIrFunction$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, Name name2, IrType irType, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return myDataClassMethodsGenerator.createSyntheticIrFunction(name2, irType, bl);
        }

        private final IrValueParameter createSyntheticIrParameter(IrFunction irFunction2, Name name2, IrType type2, int index2) {
            WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor();
            IrValueParameter irValueParameter = SymbolTable.declareValueParameter$default(DataClassMembersGenerator.this.getComponents().getSymbolTable(), -1, -1, this.origin, descriptor2, type2, null, null, new Function1<IrValueParameterSymbol, IrValueParameter>(DataClassMembersGenerator.this, this, name2, index2, type2){
                final /* synthetic */ DataClassMembersGenerator this$0;
                final /* synthetic */ MyDataClassMethodsGenerator this$1;
                final /* synthetic */ Name $name;
                final /* synthetic */ int $index;
                final /* synthetic */ IrType $type;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$name = $name;
                    this.$index = $index;
                    this.$type = $type;
                    super(1);
                }

                @NotNull
                public final IrValueParameter invoke(@NotNull IrValueParameterSymbol symbol2) {
                    Intrinsics.checkNotNullParameter(symbol2, "symbol");
                    return this.this$0.getComponents().getIrFactory().createValueParameter(-1, -1, this.this$1.getOrigin(), symbol2, this.$name, this.$index, this.$type, null, false, false, false, false);
                }
            }, 96, null);
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameter $this$createSyntheticIrParameter_u24lambda_u2d10 = irValueParameter;
            boolean bl3 = false;
            $this$createSyntheticIrParameter_u24lambda_u2d10.setParent(irFunction2);
            descriptor2.bind((IrDeclaration)$this$createSyntheticIrParameter_u24lambda_u2d10);
            return irValueParameter;
        }

        static /* synthetic */ IrValueParameter createSyntheticIrParameter$default(MyDataClassMethodsGenerator myDataClassMethodsGenerator, IrFunction irFunction2, Name name2, IrType irType, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            return myDataClassMethodsGenerator.createSyntheticIrParameter(irFunction2, name2, irType, n);
        }

        private static final boolean generate$isOverridableDeclaration(Map<Name, ? extends FirSimpleFunction> $contributedFunctionsInSupertypes, Name name2) {
            FirSimpleFunction firSimpleFunction = $contributedFunctionsInSupertypes.get(name2);
            if (firSimpleFunction == null) {
                return false;
            }
            FirSimpleFunction declaration2 = firSimpleFunction;
            FirMemberDeclaration $this$modality$iv = declaration2;
            boolean $i$f$getModality = false;
            return $this$modality$iv.getStatus().getModality() != Modality.FINAL;
        }

        public static final /* synthetic */ boolean access$getMatchesDataClassSyntheticMemberSignatures(MyDataClassMethodsGenerator $this, FirSimpleFunction $receiver) {
            return $this.getMatchesDataClassSyntheticMemberSignatures($receiver);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/backend/generators/DataClassMembersGenerator$Companion;", "", "()V", "copyName", "Lorg/jetbrains/kotlin/name/Name;", "equalsName", "hashCodeName", "toStringName", "getComponentIndex", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/lang/Integer;", "isComponentN", "", "isCopy", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCopy(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            return Intrinsics.areEqual(irFunction2.getName(), copyName);
        }

        public final boolean isComponentN(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            if (irFunction2.getName().isSpecial()) {
                return false;
            }
            String string2 = irFunction2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "irFunction.name.identifier");
            String name2 = string2;
            if (!StringsKt.startsWith$default(name2, "component", false, 2, null)) {
                return false;
            }
            Integer n = this.getComponentIndex(irFunction2);
            return n != null && n > 0;
        }

        @Nullable
        public final Integer getComponentIndex(@NotNull IrFunction irFunction2) {
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            String string2 = irFunction2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string2, "irFunction.name.identifier");
            int n = "component".length();
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
            return StringsKt.toIntOrNull(string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

