/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderer;
import org.jetbrains.kotlin.fir.analysis.diagnostics.SourceElementPositioningStrategy;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\b\u0012\u0004\u0012\u0002H\u00030\u0007B%\b\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0004J\u0012\u0010$\u001a\u00020%2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0004R4\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00102\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0001\u0004&'()\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/AbstractFirDiagnosticFactory;", "E", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "D", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "P", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "positioningStrategy", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;)V", "<anonymous parameter 0>", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "defaultRenderer", "getDefaultRenderer", "()Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "setDefaultRenderer", "(Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;)V", "firRenderer", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticRenderer;", "getFirRenderer", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticRenderer;", "getName", "()Ljava/lang/String;", "getPositioningStrategy", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "getTextRanges", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "diagnostic", "isValid", "", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory1;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory2;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory3;", "checkers"})
public abstract class AbstractFirDiagnosticFactory<E extends FirSourceElement, D extends FirDiagnostic<? extends E>, P extends PsiElement>
extends DiagnosticFactory<D> {
    @NotNull
    private final String name;
    @NotNull
    private final Severity severity;
    @NotNull
    private final SourceElementPositioningStrategy<P> positioningStrategy;

    private AbstractFirDiagnosticFactory(String name2, Severity severity, SourceElementPositioningStrategy<? super P> positioningStrategy) {
        super(name2, severity);
        this.name = name2;
        this.severity = severity;
        this.positioningStrategy = positioningStrategy;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @NotNull
    public final SourceElementPositioningStrategy<P> getPositioningStrategy() {
        return this.positioningStrategy;
    }

    @NotNull
    public abstract FirDiagnosticRenderer<D> getFirRenderer();

    @Override
    @Nullable
    public DiagnosticRenderer<D> getDefaultRenderer() {
        return this.getFirRenderer();
    }

    @Override
    public void setDefaultRenderer(@Nullable DiagnosticRenderer<? super D> $noName_0) {
    }

    @NotNull
    public final List<TextRange> getTextRanges(@NotNull FirDiagnostic<?> diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        return this.positioningStrategy.markDiagnostic(diagnostic);
    }

    public final boolean isValid(@NotNull FirDiagnostic<?> diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Object element = diagnostic.getElement();
        return this.positioningStrategy.isValid((FirSourceElement)element);
    }

    public /* synthetic */ AbstractFirDiagnosticFactory(String name2, Severity severity, SourceElementPositioningStrategy positioningStrategy, DefaultConstructorMarker $constructor_marker) {
        this(name2, severity, positioningStrategy);
    }
}

