/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationInspector;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirConflictsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\u0012\u001a\u00020\u0006*\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u00132\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u001e\u0010\u001c\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationInspector;", "checkRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "forEachNonSingle", "", "", "", "action", "Lkotlin/Function2;", "reportConflictingDeclarations", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "declarations", "reportConflictingOverloads", "checkers"})
public final class FirConflictsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsChecker INSTANCE = new FirConflictsChecker();

    private FirConflictsChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter2, "reporter");
        FirDeclarationInspector inspector = new FirDeclarationInspector(null, 1, null);
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirFile) {
            this.checkFile((FirFile)declaration2, inspector);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkRegularClass((FirRegularClass)declaration2, inspector);
        } else {
            return;
        }
        this.forEachNonSingle(inspector.getFunctionDeclarations(), (Function2<? super FirDeclaration, ? super String, Unit>)new Function2<FirDeclaration, String, Unit>(this, reporter2){
            final /* synthetic */ FirConflictsChecker this$0;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                super(2);
            }

            public final void invoke(@NotNull FirDeclaration it, @NotNull String hint2) {
                Intrinsics.checkNotNullParameter(it, "it");
                Intrinsics.checkNotNullParameter(hint2, "hint");
                FirConflictsChecker.access$reportConflictingOverloads(this.this$0, this.$reporter, it.getSource(), hint2);
            }
        });
        this.forEachNonSingle(inspector.getOtherDeclarations(), (Function2<? super FirDeclaration, ? super String, Unit>)new Function2<FirDeclaration, String, Unit>(this, reporter2){
            final /* synthetic */ FirConflictsChecker this$0;
            final /* synthetic */ DiagnosticReporter $reporter;
            {
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                super(2);
            }

            public final void invoke(@NotNull FirDeclaration it, @NotNull String hint2) {
                Intrinsics.checkNotNullParameter(it, "it");
                Intrinsics.checkNotNullParameter(hint2, "hint");
                FirConflictsChecker.access$reportConflictingDeclarations(this.this$0, this.$reporter, it.getSource(), hint2);
            }
        });
    }

    private final void forEachNonSingle(Map<String, ? extends List<? extends FirDeclaration>> $this$forEachNonSingle, Function2<? super FirDeclaration, ? super String, Unit> action) {
        for (List<? extends FirDeclaration> list2 : $this$forEachNonSingle.values()) {
            if (list2.size() <= 1) continue;
            String hint2 = CollectionsKt.joinToString$default(list2, null, null, null, 0, null, forEachNonSingle.hint.1.INSTANCE, 31, null);
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                action.invoke(it, hint2);
            }
        }
    }

    private final void checkFile(FirFile declaration2, FirDeclarationInspector inspector) {
        for (FirDeclaration it : declaration2.getDeclarations()) {
            inspector.collect(it);
        }
    }

    private final void checkRegularClass(FirRegularClass declaration2, FirDeclarationInspector inspector) {
        for (FirDeclaration it : declaration2.getDeclarations()) {
            inspector.collect(it);
        }
    }

    private final void reportConflictingOverloads(DiagnosticReporter $this$reportConflictingOverloads, FirSourceElement source, String declarations2) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportConflictingOverloads.report((FirDiagnostic)FirErrors.INSTANCE.getCONFLICTING_OVERLOADS().on(it, declarations2));
        }
    }

    private final void reportConflictingDeclarations(DiagnosticReporter $this$reportConflictingDeclarations, FirSourceElement source, String declarations2) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportConflictingDeclarations.report((FirDiagnostic)FirErrors.INSTANCE.getREDECLARATION().on(it, declarations2));
        }
    }

    public static final /* synthetic */ void access$reportConflictingOverloads(FirConflictsChecker $this, DiagnosticReporter $receiver, FirSourceElement source, String declarations2) {
        $this.reportConflictingOverloads($receiver, source, declarations2);
    }

    public static final /* synthetic */ void access$reportConflictingDeclarations(FirConflictsChecker $this, DiagnosticReporter $receiver, FirSourceElement source, String declarations2) {
        $this.reportConflictingDeclarations($receiver, source, declarations2);
    }
}

