/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters2Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters3Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParametersMultiRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.MultiRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SimpleDiagnosticRenderer;

public final class DiagnosticFactoryToRendererMap {
    private final Map<DiagnosticFactory<?>, DiagnosticRenderer<?>> map = new HashMap();
    private boolean immutable = false;
    private final String name;

    public DiagnosticFactoryToRendererMap(String name2) {
        this.name = name2;
    }

    public DiagnosticFactoryToRendererMap() {
        this("<unnamed>");
    }

    public String toString() {
        return "DiagnosticFactory#" + this.name;
    }

    private void checkMutability() {
        if (this.immutable) {
            throw new IllegalStateException("factory to renderer map is already immutable");
        }
    }

    public <E extends PsiElement> void put(@NotNull DiagnosticFactory0<E> factory2, @NotNull String message2) {
        if (factory2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(1);
        }
        this.checkMutability();
        this.map.put(factory2, new SimpleDiagnosticRenderer(message2));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactory1<E, A> factory2, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA) {
        if (factory2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(3);
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParameters1Renderer<A>(message2, rendererA));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactory1<E, A> factory2, @NotNull String message2, @NotNull MultiRenderer<? super A> rendererA) {
        if (factory2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(4);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(5);
        }
        if (rendererA == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(6);
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParametersMultiRenderer<A>(message2, rendererA));
    }

    public <E extends PsiElement, A, B> void put(@NotNull DiagnosticFactory2<E, A, B> factory2, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB) {
        if (factory2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(7);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(8);
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParameters2Renderer<A, B>(message2, rendererA, rendererB));
    }

    public <E extends PsiElement, A, B, C> void put(@NotNull DiagnosticFactory3<E, A, B, C> factory2, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB, @Nullable DiagnosticParameterRenderer<? super C> rendererC) {
        if (factory2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(9);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(10);
        }
        this.checkMutability();
        this.map.put(factory2, new DiagnosticWithParameters3Renderer<A, B, C>(message2, rendererA, rendererB, rendererC));
    }

    public void put(@NotNull DiagnosticFactory<?> factory2, @NotNull DiagnosticRenderer<?> renderer) {
        if (factory2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(11);
        }
        if (renderer == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(12);
        }
        this.checkMutability();
        this.map.put(factory2, renderer);
    }

    @Nullable
    public DiagnosticRenderer<?> get(@NotNull DiagnosticFactory<?> factory2) {
        if (factory2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(13);
        }
        return this.map.get(factory2);
    }

    public void setImmutable() {
        this.immutable = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererA";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

