/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import gnu.trove.THashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(0);
        }
        if (superMethod == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(1);
        }
        HierarchicalMethodSignature signature2 = method.getHierarchicalMethodSignature();
        for (HierarchicalMethodSignature supsig : signature2.getSuperSignatures()) {
            PsiMethod supsigme = supsig.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass2, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (superClass2 == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(2);
        }
        if (superSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(3);
        }
        if (derivedSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(4);
        }
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(superClass2.getProject());
            superSubstitutor = factory2.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
        }
        THashMap<PsiTypeParameter, PsiType> map2 = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass2)) {
            PsiType type2 = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type2);
            if (map2 == null) {
                map2 = new THashMap<PsiTypeParameter, PsiType>();
            }
            map2.put(typeParameter, t);
        }
        PsiSubstitutor psiSubstitutor = map2 == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getElementFactory(superClass2.getProject()).createSubstitutor(map2);
        if (psiSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static Map<MethodSignature, Set<PsiMethod>> collectOverrideEquivalents(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(6);
        }
        THashMap<MethodSignature, Set<PsiMethod>> overrideEquivalent = new THashMap<MethodSignature, Set<PsiMethod>>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        GlobalSearchScope resolveScope = aClass2.getResolveScope();
        PsiClass[] supers = aClass2.getSupers();
        for (int i = 0; i < supers.length; ++i) {
            PsiClass superClass2 = supers[i];
            boolean subType = false;
            for (int j = 0; j < supers.length; ++j) {
                if (j == i) continue;
                subType |= supers[j].isInheritor(supers[i], true);
            }
            if (subType) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass2, aClass2, PsiSubstitutor.EMPTY);
            for (HierarchicalMethodSignature hms : superClass2.getVisibleSignatures()) {
                PsiSubstitutor containingClassSubstitutor;
                PsiClass containingClass;
                PsiClass methodClass;
                PsiMethod method = hms.getMethod();
                if (MethodSignatureUtil.findMethodBySignature(aClass2, method.getSignature(superClassSubstitutor), false) != null || (methodClass = method.getContainingClass()) == null || (containingClass = PsiSuperMethodUtil.correctClassByScope(methodClass, resolveScope)) == null || (method = containingClass.findMethodBySignature(method, false)) == null || (containingClassSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, aClass2, PsiSubstitutor.EMPTY)) == null) continue;
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(containingClass, containingClassSubstitutor, hms.getSubstitutor(), false);
                MethodSignatureBackedByPsiMethod signature2 = MethodSignatureBackedByPsiMethod.create(method, finalSubstitutor, false);
                Set methods2 = overrideEquivalent.computeIfAbsent(signature2, __ -> new LinkedHashSet());
                methods2.add(method);
            }
        }
        THashMap<MethodSignature, Set<PsiMethod>> tHashMap = overrideEquivalent;
        if (tHashMap == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(7);
        }
        return tHashMap;
    }

    @Nullable
    public static PsiClass correctClassByScope(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope resolveScope) {
        String qualifiedName2;
        if (psiClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(8);
        }
        if (resolveScope == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(9);
        }
        if ((qualifiedName2 = psiClass.getQualifiedName()) == null) {
            return psiClass;
        }
        PsiFile file2 = psiClass.getContainingFile();
        if (file2 == null || !file2.getViewProvider().isPhysical()) {
            return psiClass;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return psiClass;
        }
        FileIndexFacade index2 = FileIndexFacade.getInstance(file2.getProject());
        if (!(index2.isInSource(vFile) || index2.isInLibrarySource(vFile) || index2.isInLibraryClasses(vFile))) {
            return psiClass;
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(qualifiedName2, resolveScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFinalSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOverrideEquivalents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "obtainFinalSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectOverrideEquivalents";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "correctClassByScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

