/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class ConflictFilterProcessor
extends FilterScopeProcessor<CandidateInfo>
implements NameHint {
    private final PsiConflictResolver[] myResolvers;
    private JavaResolveResult[] myCachedResult;
    protected String myName;
    protected final PsiElement myPlace;
    protected final PsiFile myPlaceFile;

    public ConflictFilterProcessor(String name2, @NotNull ElementFilter filter2, PsiConflictResolver @NotNull [] resolvers, @NotNull List<CandidateInfo> container2, @NotNull PsiElement place, @NotNull PsiFile placeFile) {
        if (filter2 == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(0);
        }
        if (container2 == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(2);
        }
        if (placeFile == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(3);
        }
        if (resolvers == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(4);
        }
        super(filter2, container2);
        this.myResolvers = resolvers;
        this.myName = name2;
        this.myPlace = place;
        this.myPlaceFile = placeFile;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        JavaResolveResult[] cachedResult;
        if (element == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(5);
        }
        if (state2 == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(6);
        }
        if ((cachedResult = this.myCachedResult) != null && cachedResult.length == 1 && this.stopAtFoundResult(cachedResult[0])) {
            return false;
        }
        if (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace)) {
            return super.execute(element, state2);
        }
        return true;
    }

    protected boolean stopAtFoundResult(@NotNull JavaResolveResult cachedResult) {
        if (cachedResult == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(7);
        }
        return cachedResult.isAccessible();
    }

    @Override
    protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(8);
        }
        if (substitutor2 == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(9);
        }
        this.add(new CandidateInfo(element, substitutor2));
    }

    protected void add(@NotNull CandidateInfo info) {
        if (info == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(10);
        }
        this.myCachedResult = null;
        this.myResults.add(info);
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(11);
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myName != null) {
            this.getResult();
        }
    }

    public JavaResolveResult @NotNull [] getResult() {
        JavaResolveResult[] cachedResult = this.myCachedResult;
        if (cachedResult == null) {
            List<CandidateInfo> conflicts = this.getResults();
            if (!conflicts.isEmpty()) {
                for (PsiConflictResolver resolver2 : this.myResolvers) {
                    CandidateInfo candidate2 = resolver2.resolveConflict(conflicts);
                    if (candidate2 == null) continue;
                    conflicts.clear();
                    conflicts.add(candidate2);
                    break;
                }
            }
            cachedResult = conflicts.toArray(JavaResolveResult.EMPTY_ARRAY);
            this.myCachedResult = cachedResult;
        }
        if (cachedResult == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(12);
        }
        return cachedResult;
    }

    @Override
    public String getName(@NotNull ResolveState state2) {
        if (state2 == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(13);
        }
        return this.myName;
    }

    public void setName(String name2) {
        this.myName = name2;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            ConflictFilterProcessor.$$$reportNull$$$0(14);
        }
        if (hintKey == NameHint.KEY) {
            return (T)(this.myName != null ? this : null);
        }
        return super.getHint(hintKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedResult";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/scope/processor/ConflictFilterProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stopAtFoundResult";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

