/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiCatchSectionImpl
extends CompositePsiElement
implements PsiCatchSection,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiCatchSectionImpl.class);
    private final Object myTypesCacheLock = new Object();
    private CachedValue<List<PsiType>> myTypesCache;

    public PsiCatchSectionImpl() {
        super(CATCH_SECTION);
    }

    @Override
    public PsiParameter getParameter() {
        return (PsiParameter)this.findChildByRoleAsPsiElement(15);
    }

    @Override
    public PsiCodeBlock getCatchBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(49);
    }

    @Override
    public PsiType getCatchType() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            return null;
        }
        return parameter.getType();
    }

    @Override
    @NotNull
    public List<PsiType> getPreciseCatchTypes() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            List<PsiType> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiCatchSectionImpl.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List<PsiType> list3 = this.getTypesCache().getValue();
        if (list3 == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(1);
        }
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            this.myTypesCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedValue<List<PsiType>> getTypesCache() {
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            if (this.myTypesCache == null) {
                CachedValuesManager cacheManager = CachedValuesManager.getManager(this.getProject());
                this.myTypesCache = cacheManager.createCachedValue(() -> {
                    List<PsiType> types2 = this.computePreciseCatchTypes(this.getParameter());
                    return CachedValueProvider.Result.create(types2, PsiModificationTracker.MODIFICATION_COUNT);
                }, false);
            }
            return this.myTypesCache;
        }
    }

    private List<PsiType> computePreciseCatchTypes(@Nullable PsiParameter parameter) {
        if (parameter == null) {
            return ContainerUtil.emptyList();
        }
        PsiType declaredType = parameter.getType();
        if (PsiUtil.getLanguageLevel(parameter).isAtLeast(LanguageLevel.JDK_1_7) && PsiCatchSectionImpl.isCatchParameterEffectivelyFinal(parameter, this.getCatchBlock())) {
            PsiTryStatement statement2 = this.getTryStatement();
            Collection<PsiClassType> thrownTypes = PsiCatchSectionImpl.getThrownTypes(statement2);
            if (thrownTypes.isEmpty()) {
                return Collections.emptyList();
            }
            PsiParameter[] parameters2 = statement2.getCatchBlockParameters();
            int currentIdx = ArrayUtil.find(parameters2, parameter);
            List<PsiType> uncaughtTypes = ContainerUtil.mapNotNull(thrownTypes, thrownType -> {
                for (int i = 0; i < currentIdx; ++i) {
                    PsiType catchType = parameters2[i].getType();
                    if (!catchType.isAssignableFrom((PsiType)thrownType)) continue;
                    return null;
                }
                return thrownType;
            });
            if (uncaughtTypes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<PsiType> types2 = new ArrayList<PsiType>();
            for (PsiType type2 : uncaughtTypes) {
                if (!declaredType.isAssignableFrom(type2) && (!ExceptionUtil.isGeneralExceptionType(declaredType) || !(type2 instanceof PsiClassType) || !ExceptionUtil.isUncheckedException((PsiClassType)type2))) continue;
                types2.add(type2);
            }
            if (!types2.isEmpty()) {
                return types2;
            }
        }
        return Collections.singletonList(declaredType);
    }

    private static Collection<PsiClassType> getThrownTypes(@NotNull PsiTryStatement statement2) {
        PsiResourceList resourceList;
        if (statement2 == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(2);
        }
        ArrayList<PsiClassType> types2 = new ArrayList<PsiClassType>();
        PsiCodeBlock tryBlock = statement2.getTryBlock();
        if (tryBlock != null) {
            types2.addAll(ExceptionUtil.getThrownExceptions(tryBlock));
        }
        if ((resourceList = statement2.getResourceList()) != null) {
            types2.addAll(ExceptionUtil.getThrownExceptions(resourceList));
        }
        return types2;
    }

    private static boolean isCatchParameterEffectivelyFinal(final PsiParameter parameter, @Nullable PsiCodeBlock catchBlock) {
        final boolean[] result2 = new boolean[]{true};
        if (catchBlock != null) {
            catchBlock.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    if (expression2.resolve() == parameter && PsiUtil.isAccessedForWriting(expression2)) {
                        result2[0] = false;
                        this.stopWalking();
                    }
                }
            });
        }
        return result2[0];
    }

    @Override
    @NotNull
    public PsiTryStatement getTryStatement() {
        PsiTryStatement psiTryStatement = (PsiTryStatement)this.getParent();
        if (psiTryStatement == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(3);
        }
        return psiTryStatement;
    }

    @Override
    @Nullable
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)((Object)this.findChildByRole(50));
    }

    @Override
    @Nullable
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)((Object)this.findChildByRole(51));
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitCatchSection(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiCatchSection";
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                return null;
            }
            case 15: {
                return this.findChildByType(PARAMETER);
            }
            case 46: {
                return this.findChildByType(CATCH_KEYWORD);
            }
            case 50: {
                return this.findChildByType(LPARENTH);
            }
            case 51: {
                return this.findChildByType(RPARENTH);
            }
            case 49: 
        }
        return this.findChildByType(CODE_BLOCK);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == CODE_BLOCK) {
            return 49;
        }
        if (i == CATCH_KEYWORD) {
            return 46;
        }
        if (i == LPARENTH) {
            return 50;
        }
        if (i == RPARENTH) {
            return 51;
        }
        return 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(6);
        }
        if (state2 == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(7);
        }
        if (place == null) {
            PsiCatchSectionImpl.$$$reportNull$$$0(8);
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        PsiParameter catchParameter = this.getParameter();
        if (catchParameter != null) {
            return processor2.execute(catchParameter, state2);
        }
        return PsiScopesUtil.walkChildrenScopes(this, processor2, state2, lastParent, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseCatchTypes";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryStatement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

