/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ElementVisitor;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class ServiceBinding<T>
implements Binding<T>,
Provider<T> {
    private final Key<T> key;
    private final T instance;
    private final int rank;

    ServiceBinding(BundleContext context2, String clazzName, int maxRank, ServiceReference<T> reference) throws ClassNotFoundException {
        int serviceRanking;
        Class clazz = reference.getBundle().loadClass(clazzName);
        Object name2 = reference.getProperty("name");
        this.key = name2 instanceof String && ((String)name2).length() > 0 ? Key.get(clazz, (Annotation)Names.named((String)name2)) : Key.get(clazz);
        this.instance = context2.getService(reference);
        this.rank = maxRank > Integer.MIN_VALUE ? ((serviceRanking = ServiceBinding.getServiceRanking(reference)) < maxRank ? serviceRanking : maxRank) : Integer.MIN_VALUE;
    }

    @Override
    public Key<T> getKey() {
        return this.key;
    }

    @Override
    public Provider<T> getProvider() {
        return this;
    }

    @Override
    public T get() {
        return this.instance;
    }

    @Override
    public Object getSource() {
        return "OSGi service registry";
    }

    @Override
    public void applyTo(Binder binder) {
    }

    public <V> V acceptVisitor(ElementVisitor<V> visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor2) {
        return null;
    }

    @Override
    public <V> V acceptScopingVisitor(BindingScopingVisitor<V> visitor2) {
        return visitor2.visitScopeAnnotation(Singleton.class);
    }

    boolean isCompatibleWith(BindingSubscriber<T> subscriber) {
        return this.key.getTypeLiteral().getRawType().equals(subscriber.type().getRawType());
    }

    int rank() {
        return this.rank;
    }

    private static int getServiceRanking(ServiceReference<?> reference) {
        Object ranking = reference.getProperty("service.ranking");
        return ranking instanceof Integer ? (Integer)ranking : 0;
    }
}

