/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.sisu.inject.MildValues;

final class MildConcurrentValues<K, V>
extends MildValues<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, Reference<V>> concurrentMap;

    MildConcurrentValues(ConcurrentMap<K, Reference<V>> map2, boolean soft) {
        super(map2, soft);
        this.concurrentMap = map2;
    }

    @Override
    public V putIfAbsent(K key, V value2) {
        Reference<V> oldRef;
        this.compact();
        Reference<V> ref = this.mildValue(key, value2);
        while ((oldRef = this.concurrentMap.putIfAbsent(key, ref)) != null) {
            V oldValue = oldRef.get();
            if (oldValue != null) {
                return oldValue;
            }
            this.concurrentMap.remove(key, oldRef);
        }
        return null;
    }

    @Override
    public V replace(K key, V value2) {
        this.compact();
        Reference<V> ref = this.concurrentMap.replace(key, this.mildValue(key, value2));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue2) {
        this.compact();
        return this.concurrentMap.replace(key, MildConcurrentValues.tempValue(oldValue), this.mildValue(key, newValue2));
    }

    @Override
    public boolean remove(Object key, Object value2) {
        this.compact();
        return this.concurrentMap.remove(key, MildConcurrentValues.tempValue(value2));
    }

    @Override
    void compact() {
        Reference ref;
        while ((ref = this.queue.poll()) != null) {
            this.concurrentMap.remove(((MildValues.InverseMapping)((Object)ref)).key(), ref);
        }
    }
}

