/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.http.HttpTransporter;

@Named(value="http")
public final class HttpTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority = 5.0f;

    public HttpTransporterFactory() {
    }

    @Inject
    HttpTransporterFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public HttpTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, HttpTransporter.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public HttpTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public Transporter newInstance(RepositorySystemSession session2, RemoteRepository repository) throws NoTransporterException {
        return new HttpTransporter(repository, session2, this.logger);
    }
}

