/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ReactorModelPool;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

public class ProjectModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context = "project";
    private List<RemoteRepository> repositories;
    private List<RemoteRepository> pomRepositories;
    private final List<RemoteRepository> externalRepositories;
    private final RepositorySystem resolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;
    private final ReactorModelPool modelPool;
    private final ProjectBuildingRequest.RepositoryMerging repositoryMerging;

    public ProjectModelResolver(RepositorySystemSession session2, RequestTrace trace, RepositorySystem resolver2, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories, ProjectBuildingRequest.RepositoryMerging repositoryMerging, ReactorModelPool modelPool) {
        this.session = session2;
        this.trace = trace;
        this.resolver = resolver2;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.pomRepositories = new ArrayList<RemoteRepository>();
        this.externalRepositories = Collections.unmodifiableList(new ArrayList<RemoteRepository>(repositories));
        this.repositories = new ArrayList<RemoteRepository>();
        this.repositories.addAll(this.externalRepositories);
        this.repositoryMerging = repositoryMerging;
        this.repositoryIds = new HashSet<String>();
        this.modelPool = modelPool;
    }

    private ProjectModelResolver(ProjectModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.resolver = original.resolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.pomRepositories = new ArrayList<RemoteRepository>(original.pomRepositories);
        this.externalRepositories = original.externalRepositories;
        this.repositories = new ArrayList<RemoteRepository>(original.repositories);
        this.repositoryMerging = original.repositoryMerging;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
        this.modelPool = original.modelPool;
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    @Override
    public void addRepository(Repository repository, boolean replace2) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace2) {
                return;
            }
            ProjectModelResolver.removeMatchingRepository(this.repositories, repository.getId());
            ProjectModelResolver.removeMatchingRepository(this.pomRepositories, repository.getId());
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository(repository));
        if (ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT.equals((Object)this.repositoryMerging)) {
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
        } else {
            this.pomRepositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, newRepositories, true);
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, this.externalRepositories, false);
        }
    }

    private static void removeMatchingRepository(Iterable<RemoteRepository> repositories, String id) {
        Iterator<RemoteRepository> iterator2 = repositories.iterator();
        while (iterator2.hasNext()) {
            RemoteRepository next = iterator2.next();
            if (!next.getId().equals(id)) continue;
            iterator2.remove();
        }
    }

    @Override
    public ModelResolver newCopy() {
        return new ProjectModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        File pomFile = null;
        if (this.modelPool != null) {
            pomFile = this.modelPool.get(groupId, artifactId, version);
        }
        if (pomFile == null) {
            Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
            try {
                ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, "project");
                request.setTrace(this.trace);
                pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, e);
            }
            pomFile = pomArtifact.getFile();
        }
        return new FileModelSource(pomFile);
    }

    @Override
    public ModelSource resolveModel(Parent parent2) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(parent2.getGroupId(), parent2.getArtifactId(), "", "pom", parent2.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, "project");
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.resolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested parent version range '%s'", parent2.getVersion()), parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested parent version range '%s' does not specify an upper bound", parent2.getVersion()), parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion());
            }
            parent2.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent2.getGroupId(), parent2.getArtifactId(), parent2.getVersion(), e);
        }
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "", "pom", dependency.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, "project");
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.resolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested dependency version range '%s'", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested dependency version range '%s' does not specify an upper bound", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            dependency.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), e);
        }
    }
}

