/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class PluginExecutionException
extends PluginManagerException {
    private final MojoExecution mojoExecution;

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, String message2) {
        super(mojoExecution.getMojoDescriptor(), project, message2);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, String message2, Throwable cause) {
        super(mojoExecution.getMojoDescriptor(), project, message2, cause);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, Exception cause) {
        super(mojoExecution.getMojoDescriptor(), project, PluginExecutionException.constructMessage(mojoExecution, cause), (Throwable)cause);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, DuplicateArtifactAttachmentException cause) {
        super(mojoExecution.getMojoDescriptor(), project, PluginExecutionException.constructMessage(mojoExecution, cause), (Throwable)cause);
        this.mojoExecution = mojoExecution;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    private static String constructMessage(MojoExecution mojoExecution, Throwable cause) {
        String message2 = mojoExecution != null ? "Execution " + mojoExecution.getExecutionId() + " of goal " + mojoExecution.getMojoDescriptor().getId() + " failed" : "Mojo execution failed";
        message2 = cause != null && StringUtils.isNotEmpty(cause.getMessage()) ? message2 + ": " + cause.getMessage() : message2 + ".";
        return message2;
    }
}

