/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.lifecycle.mapping.LifecycleMojo;
import org.codehaus.plexus.util.StringUtils;

public class LifecyclePhase {
    private List<LifecycleMojo> mojos;

    public LifecyclePhase() {
    }

    public LifecyclePhase(String goals) {
        this.set(goals);
    }

    public List<LifecycleMojo> getMojos() {
        return this.mojos;
    }

    public void setMojos(List<LifecycleMojo> mojos) {
        this.mojos = mojos;
    }

    public void set(String goals) {
        this.mojos = new ArrayList<LifecycleMojo>();
        if (StringUtils.isNotEmpty(goals)) {
            String[] mojoGoals;
            for (String mojoGoal : mojoGoals = StringUtils.split(goals, ",")) {
                LifecycleMojo lifecycleMojo = new LifecycleMojo();
                lifecycleMojo.setGoal(mojoGoal.trim());
                this.mojos.add(lifecycleMojo);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        List<LifecycleMojo> mojos = this.getMojos();
        if (mojos != null) {
            for (LifecycleMojo mojo : mojos) {
                if (first2) {
                    first2 = false;
                } else {
                    sb.append(',');
                }
                sb.append(mojo.getGoal());
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static Map<String, String> toLegacyMap(Map<String, LifecyclePhase> lifecyclePhases) {
        if (lifecyclePhases == null) {
            return null;
        }
        if (lifecyclePhases.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> phases = new LinkedHashMap<String, String>();
        for (Map.Entry<String, LifecyclePhase> e : lifecyclePhases.entrySet()) {
            phases.put(e.getKey(), e.getValue().toString());
        }
        return phases;
    }
}

