/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public class LegacyLocalRepositoryManager
implements LocalRepositoryManager {
    private final ArtifactRepository delegate;
    private final LocalRepository repo;
    private final boolean realLocalRepo;

    public static RepositorySystemSession overlay(ArtifactRepository repository, RepositorySystemSession session2, RepositorySystem system2) {
        if (repository == null || repository.getBasedir() == null) {
            return session2;
        }
        if (session2 != null) {
            LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
            if (lrm != null && lrm.getRepository().getBasedir().equals(new File(repository.getBasedir()))) {
                return session2;
            }
        } else {
            session2 = new DefaultRepositorySystemSession();
        }
        LegacyLocalRepositoryManager llrm = new LegacyLocalRepositoryManager(repository);
        return new DefaultRepositorySystemSession(session2).setLocalRepositoryManager(llrm);
    }

    private LegacyLocalRepositoryManager(ArtifactRepository delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate cannot be null");
        ArtifactRepositoryLayout layout = delegate.getLayout();
        this.repo = new LocalRepository(new File(delegate.getBasedir()), layout != null ? layout.getClass().getSimpleName() : "legacy");
        this.realLocalRepo = layout instanceof DefaultRepositoryLayout && "local".equals(delegate.getId());
    }

    @Override
    public LocalRepository getRepository() {
        return this.repo;
    }

    @Override
    public String getPathForLocalArtifact(org.eclipse.aether.artifact.Artifact artifact) {
        if (this.realLocalRepo) {
            return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact.setVersion(artifact.getBaseVersion())));
        }
        return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact));
    }

    @Override
    public String getPathForRemoteArtifact(org.eclipse.aether.artifact.Artifact artifact, RemoteRepository repository, String context2) {
        return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact));
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata2) {
        return this.delegate.pathOfLocalRepositoryMetadata(new ArtifactMetadataAdapter(metadata2), this.delegate);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata2, RemoteRepository repository, String context2) {
        return this.delegate.pathOfLocalRepositoryMetadata(new ArtifactMetadataAdapter(metadata2), new ArtifactRepositoryAdapter(repository));
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session2, LocalArtifactRequest request) {
        String path2 = this.getPathForLocalArtifact(request.getArtifact());
        File file2 = new File(this.getRepository().getBasedir(), path2);
        LocalArtifactResult result2 = new LocalArtifactResult(request);
        if (file2.isFile()) {
            result2.setFile(file2);
            result2.setAvailable(true);
        }
        return result2;
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session2, LocalMetadataRequest request) {
        Metadata metadata2 = request.getMetadata();
        String path2 = request.getRepository() == null ? this.getPathForLocalMetadata(metadata2) : this.getPathForRemoteMetadata(metadata2, request.getRepository(), request.getContext());
        File file2 = new File(this.getRepository().getBasedir(), path2);
        LocalMetadataResult result2 = new LocalMetadataResult(request);
        if (file2.isFile()) {
            result2.setFile(file2);
        }
        return result2;
    }

    @Override
    public void add(RepositorySystemSession session2, LocalArtifactRegistration request) {
    }

    @Override
    public void add(RepositorySystemSession session2, LocalMetadataRegistration request) {
    }

    static class ArtifactRepositoryAdapter
    implements ArtifactRepository {
        private final RemoteRepository repository;

        ArtifactRepositoryAdapter(RemoteRepository repository) {
            this.repository = repository;
        }

        @Override
        public String pathOf(Artifact artifact) {
            return null;
        }

        @Override
        public String pathOfRemoteRepositoryMetadata(org.apache.maven.artifact.metadata.ArtifactMetadata artifactMetadata) {
            return null;
        }

        @Override
        public String pathOfLocalRepositoryMetadata(org.apache.maven.artifact.metadata.ArtifactMetadata metadata2, ArtifactRepository repository) {
            return null;
        }

        @Override
        public String getUrl() {
            return this.repository.getUrl();
        }

        @Override
        public void setUrl(String url) {
        }

        @Override
        public String getBasedir() {
            return null;
        }

        @Override
        public String getProtocol() {
            return this.repository.getProtocol();
        }

        @Override
        public String getId() {
            return this.repository.getId();
        }

        @Override
        public void setId(String id) {
        }

        @Override
        public ArtifactRepositoryPolicy getSnapshots() {
            return null;
        }

        @Override
        public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        @Override
        public ArtifactRepositoryPolicy getReleases() {
            return null;
        }

        @Override
        public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        @Override
        public ArtifactRepositoryLayout getLayout() {
            return null;
        }

        @Override
        public void setLayout(ArtifactRepositoryLayout layout) {
        }

        @Override
        public String getKey() {
            return this.getId();
        }

        @Override
        public boolean isUniqueVersion() {
            return true;
        }

        @Override
        public boolean isBlacklisted() {
            return false;
        }

        @Override
        public void setBlacklisted(boolean blackListed) {
        }

        @Override
        public Artifact find(Artifact artifact) {
            return null;
        }

        @Override
        public List<String> findVersions(Artifact artifact) {
            return Collections.emptyList();
        }

        @Override
        public boolean isProjectAware() {
            return false;
        }

        @Override
        public void setAuthentication(Authentication authentication) {
        }

        @Override
        public Authentication getAuthentication() {
            return null;
        }

        @Override
        public void setProxy(Proxy proxy2) {
        }

        @Override
        public Proxy getProxy() {
            return null;
        }

        @Override
        public List<ArtifactRepository> getMirroredRepositories() {
            return Collections.emptyList();
        }

        @Override
        public void setMirroredRepositories(List<ArtifactRepository> mirroredRepositories) {
        }
    }

    static class ArtifactMetadataAdapter
    implements org.apache.maven.artifact.metadata.ArtifactMetadata {
        private final Metadata metadata;

        ArtifactMetadataAdapter(Metadata metadata2) {
            this.metadata = metadata2;
        }

        @Override
        public boolean storedInArtifactVersionDirectory() {
            return this.metadata.getVersion().length() > 0;
        }

        @Override
        public boolean storedInGroupDirectory() {
            return this.metadata.getArtifactId().length() <= 0;
        }

        @Override
        public String getGroupId() {
            return this.nullify(this.metadata.getGroupId());
        }

        @Override
        public String getArtifactId() {
            return this.nullify(this.metadata.getArtifactId());
        }

        @Override
        public String getBaseVersion() {
            return this.nullify(this.metadata.getVersion());
        }

        private String nullify(String str) {
            return str == null || str.length() <= 0 ? null : str;
        }

        @Override
        public Object getKey() {
            return this.metadata.toString();
        }

        @Override
        public String getRemoteFilename() {
            return this.metadata.getType();
        }

        @Override
        public String getLocalFilename(ArtifactRepository repository) {
            return this.insertRepositoryKey(this.getRemoteFilename(), repository.getKey());
        }

        private String insertRepositoryKey(String filename, String repositoryKey) {
            int idx = filename.indexOf(46);
            String result2 = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
            return result2;
        }

        @Override
        public void merge(ArtifactMetadata metadata2) {
        }

        @Override
        public void merge(org.apache.maven.artifact.metadata.ArtifactMetadata metadata2) {
        }

        @Override
        public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        }

        @Override
        public String extendedToString() {
            return this.metadata.toString();
        }
    }
}

