/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DuplicateProjectException;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.Result;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.LocalRepositoryNotAccessibleException;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.util.repository.ChainedWorkspaceReader;

@Component(role=Maven.class)
public class DefaultMaven
implements Maven {
    @Requirement
    private Logger logger;
    @Requirement
    protected ProjectBuilder projectBuilder;
    @Requirement
    private LifecycleStarter lifecycleStarter;
    @Requirement
    protected PlexusContainer container;
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private SessionScope sessionScope;
    @Requirement
    private DefaultRepositorySystemSessionFactory repositorySessionFactory;
    @Requirement(hint="graphBuilder")
    private GraphBuilder graphBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        MavenExecutionResult result2;
        try {
            result2 = this.doExecute(request);
        }
        catch (OutOfMemoryError e) {
            result2 = this.addExceptionToResult(new DefaultMavenExecutionResult(), e);
        }
        catch (RuntimeException e) {
            result2 = e.getCause() instanceof ProjectCycleException ? this.addExceptionToResult(new DefaultMavenExecutionResult(), e.getCause()) : this.addExceptionToResult(new DefaultMavenExecutionResult(), new InternalErrorException("Internal error: " + e, e));
        }
        finally {
            this.legacySupport.setSession(null);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request) {
        request.setStartTime(new Date());
        DefaultMavenExecutionResult result2 = new DefaultMavenExecutionResult();
        try {
            this.validateLocalRepository(request);
        }
        catch (LocalRepositoryNotAccessibleException e) {
            return this.addExceptionToResult(result2, e);
        }
        this.sessionScope.enter();
        try {
            DefaultRepositorySystemSession repoSession = (DefaultRepositorySystemSession)this.newRepositorySession(request);
            MavenSession session2 = new MavenSession(this.container, repoSession, request, result2);
            this.sessionScope.seed(MavenSession.class, session2);
            this.legacySupport.setSession(session2);
            MavenExecutionResult mavenExecutionResult = this.doExecute(request, session2, result2, repoSession);
            return mavenExecutionResult;
        }
        finally {
            this.sessionScope.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request, MavenSession session2, MavenExecutionResult result2, DefaultRepositorySystemSession repoSession) {
        WorkspaceReader reactorWorkspace;
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.emptyList())) {
                listener.afterSessionStart(session2);
            }
        }
        catch (MavenExecutionException e) {
            return this.addExceptionToResult(result2, e);
        }
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectDiscoveryStarted, session2, null);
        Result<? extends ProjectDependencyGraph> graphResult = this.buildGraph(session2, result2);
        if (graphResult.hasErrors()) {
            return this.addExceptionToResult(result2, graphResult.getProblems().iterator().next().getException());
        }
        try {
            session2.setProjectMap(this.getProjectMap(session2.getProjects()));
        }
        catch (DuplicateProjectException e) {
            return this.addExceptionToResult(result2, e);
        }
        try {
            reactorWorkspace = this.container.lookup(WorkspaceReader.class, "reactor");
        }
        catch (ComponentLookupException e) {
            return this.addExceptionToResult(result2, e);
        }
        repoSession.setWorkspaceReader(ChainedWorkspaceReader.newInstance(reactorWorkspace, repoSession.getWorkspaceReader()));
        repoSession.setReadOnly();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(session2.getProjects())) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterProjectsRead(session2);
            }
        }
        catch (MavenExecutionException e) {
            MavenExecutionResult listener = this.addExceptionToResult(result2, e);
            return listener;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        graphResult = this.buildGraph(session2, result2);
        if (graphResult.hasErrors()) {
            return this.addExceptionToResult(result2, graphResult.getProblems().iterator().next().getException());
        }
        try {
            MavenExecutionResult e;
            if (result2.hasExceptions()) {
                e = result2;
                return e;
            }
            result2.setTopologicallySortedProjects(session2.getProjects());
            result2.setProject(session2.getTopLevelProject());
            this.validatePrerequisitesForNonMavenPluginProjects(session2.getProjects());
            this.lifecycleStarter.execute(session2);
            this.validateActivatedProfiles(session2.getProjects(), request.getActiveProfiles());
            if (session2.getResult().hasExceptions()) {
                e = this.addExceptionToResult(result2, session2.getResult().getExceptions().get(0));
                return e;
            }
        }
        finally {
            try {
                this.afterSessionEnd(session2.getProjects(), session2);
            }
            catch (MavenExecutionException e) {
                return this.addExceptionToResult(result2, e);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterSessionEnd(Collection<MavenProject> projects, MavenSession session2) throws MavenExecutionException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(projects)) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                listener.afterSessionEnd(session2);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public RepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        return this.repositorySessionFactory.newRepositorySession(request);
    }

    private void validateLocalRepository(MavenExecutionRequest request) throws LocalRepositoryNotAccessibleException {
        File localRepoDir = request.getLocalRepositoryPath();
        this.logger.debug("Using local repository at " + localRepoDir);
        localRepoDir.mkdirs();
        if (!localRepoDir.isDirectory()) {
            throw new LocalRepositoryNotAccessibleException("Could not create local repository at " + localRepoDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader(projectRealm);
                try {
                    lifecycleListeners.addAll(this.container.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    this.logger.warn("Failed to lookup lifecycle participants: " + e.getMessage());
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private MavenExecutionResult addExceptionToResult(MavenExecutionResult result2, Throwable e) {
        if (!result2.getExceptions().contains(e)) {
            result2.addException(e);
        }
        return result2;
    }

    private void validatePrerequisitesForNonMavenPluginProjects(List<MavenProject> projects) {
        for (MavenProject mavenProject : projects) {
            Prerequisites prerequisites;
            if ("maven-plugin".equals(mavenProject.getPackaging()) || (prerequisites = mavenProject.getPrerequisites()) == null || prerequisites.getMaven() == null) continue;
            this.logger.warn("The project " + mavenProject.getId() + " uses prerequisites which is only intended for maven-plugin projects but not for non maven-plugin projects. For such purposes you should use the maven-enforcer-plugin. See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html");
        }
    }

    private void validateActivatedProfiles(List<MavenProject> projects, List<String> activeProfileIds) {
        LinkedHashSet<String> notActivatedProfileIds = new LinkedHashSet<String>(activeProfileIds);
        for (MavenProject project : projects) {
            for (List<String> profileIds : project.getInjectedProfileIds().values()) {
                notActivatedProfileIds.removeAll(profileIds);
            }
        }
        for (String notActivatedProfileId : notActivatedProfileIds) {
            this.logger.warn("The requested profile \"" + notActivatedProfileId + "\" could not be activated because it does not exist.");
        }
    }

    private Map<String, MavenProject> getProjectMap(Collection<MavenProject> projects) throws DuplicateProjectException {
        LinkedHashMap<String, MavenProject> index2 = new LinkedHashMap<String, MavenProject>();
        LinkedHashMap<String, List<File>> collisions = new LinkedHashMap<String, List<File>>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key(project.getGroupId(), project.getArtifactId(), project.getVersion());
            MavenProject collision = (MavenProject)index2.get(projectId);
            if (collision == null) {
                index2.put(projectId, project);
                continue;
            }
            ArrayList<File> pomFiles = (ArrayList<File>)collisions.get(projectId);
            if (pomFiles == null) {
                pomFiles = new ArrayList<File>(Arrays.asList(collision.getFile(), project.getFile()));
                collisions.put(projectId, pomFiles);
                continue;
            }
            pomFiles.add(project.getFile());
        }
        if (!collisions.isEmpty()) {
            throw new DuplicateProjectException("Two or more projects in the reactor have the same identifier, please make sure that <groupId>:<artifactId>:<version> is unique for each project: " + collisions, collisions);
        }
        return index2;
    }

    private Result<? extends ProjectDependencyGraph> buildGraph(MavenSession session2, MavenExecutionResult result2) {
        Result<? extends ProjectDependencyGraph> graphResult = this.graphBuilder.build(session2);
        for (ModelProblem problem : graphResult.getProblems()) {
            if (problem.getSeverity() == ModelProblem.Severity.WARNING) {
                this.logger.warn(problem.toString());
                continue;
            }
            this.logger.error(problem.toString());
        }
        if (!graphResult.hasErrors()) {
            ProjectDependencyGraph projectDependencyGraph = graphResult.get();
            session2.setProjects(projectDependencyGraph.getSortedProjects());
            session2.setAllProjects(projectDependencyGraph.getAllProjects());
            session2.setProjectDependencyGraph(projectDependencyGraph);
        }
        return graphResult;
    }

    @Deprecated
    protected Logger getLogger() {
        return this.logger;
    }
}

