/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Immutable
public class BasicPathHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setPath(!TextUtils.isBlank(value2) ? value2 : "/");
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (!this.match(cookie, origin)) {
            throw new CookieRestrictionViolationException("Illegal path attribute \"" + cookie.getPath() + "\". Path of origin: \"" + origin.getPath() + "\"");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        boolean match2;
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String targetpath = origin.getPath();
        String topmostPath = cookie.getPath();
        if (topmostPath == null) {
            topmostPath = "/";
        }
        if (topmostPath.length() > 1 && topmostPath.endsWith("/")) {
            topmostPath = topmostPath.substring(0, topmostPath.length() - 1);
        }
        if ((match2 = targetpath.startsWith(topmostPath)) && targetpath.length() != topmostPath.length() && !topmostPath.endsWith("/")) {
            match2 = targetpath.charAt(topmostPath.length()) == '/';
        }
        return match2;
    }
}

