/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.SoundexUtils;

public class Soundex
implements StringEncoder {
    public static final String US_ENGLISH_MAPPING_STRING = "01230120022455012623010202";
    private static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    private int maxLength = 4;
    private final char[] soundexMapping;

    public Soundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
    }

    public Soundex(char[] mapping2) {
        this.soundexMapping = new char[mapping2.length];
        System.arraycopy(mapping2, 0, this.soundexMapping, 0, mapping2.length);
    }

    public Soundex(String mapping2) {
        this.soundexMapping = mapping2.toCharArray();
    }

    public int difference(String s1, String s2) throws EncoderException {
        return SoundexUtils.difference(this, s1, s2);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)pObject);
    }

    public String encode(String pString) {
        return this.soundex(pString);
    }

    private char getMappingCode(String str, int index2) {
        char preHWChar;
        char firstCode;
        char hwChar;
        char mappedChar = this.map(str.charAt(index2));
        if (!(index2 <= 1 || mappedChar == '0' || 'H' != (hwChar = str.charAt(index2 - 1)) && 'W' != hwChar || (firstCode = this.map(preHWChar = str.charAt(index2 - 2))) != mappedChar && 'H' != preHWChar && 'W' != preHWChar)) {
            return '\u0000';
        }
        return mappedChar;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    private char[] getSoundexMapping() {
        return this.soundexMapping;
    }

    private char map(char ch) {
        int index2 = ch - 65;
        if (index2 < 0 || index2 >= this.getSoundexMapping().length) {
            throw new IllegalArgumentException("The character is not mapped: " + ch);
        }
        return this.getSoundexMapping()[index2];
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String soundex(String str) {
        if (str == null) {
            return null;
        }
        if ((str = SoundexUtils.clean(str)).length() == 0) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count2 = 1;
        out[0] = str.charAt(0);
        char last2 = this.getMappingCode(str, 0);
        while (incount < str.length() && count2 < out.length) {
            char mapped;
            if ((mapped = this.getMappingCode(str, incount++)) == '\u0000') continue;
            if (mapped != '0' && mapped != last2) {
                out[count2++] = mapped;
            }
            last2 = mapped;
        }
        return new String(out);
    }
}

