/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.dependencies.maven;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.dependencies.ExternalDependenciesResolver;
import kotlin.script.experimental.dependencies.RepositoryCoordinates;
import kotlin.script.experimental.dependencies.impl.ResolverNamedOptionsKt;
import kotlin.script.experimental.dependencies.impl.ResolverUtilsKt;
import kotlin.script.experimental.dependencies.maven.MavenRepositoryCoordinates;
import kotlin.script.experimental.dependencies.maven.impl.AetherKt;
import kotlin.script.experimental.dependencies.maven.impl.AetherResolveSession;
import kotlin.text.StringsKt;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J7\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a0\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lkotlin/script/experimental/dependencies/maven/MavenDependenciesResolver;", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver;", "()V", "localRepo", "Ljava/io/File;", "getLocalRepo", "()Ljava/io/File;", "repos", "Ljava/util/ArrayList;", "Lorg/eclipse/aether/repository/RemoteRepository;", "getRepos", "()Ljava/util/ArrayList;", "acceptsArtifact", "", "artifactCoordinates", "", "acceptsRepository", "repositoryCoordinates", "Lkotlin/script/experimental/dependencies/RepositoryCoordinates;", "addRepository", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "options", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;", "sourceCodeLocation", "Lkotlin/script/experimental/api/SourceCode$LocationWithId;", "allRepositories", "", "", "remoteRepositories", "resolve", "(Ljava/lang/String;Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver$Options;Lkotlin/script/experimental/api/SourceCode$LocationWithId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryResolveEnvironmentVariable", "str", "toMavenArtifact", "Lorg/eclipse/aether/artifact/DefaultArtifact;", "kotlin-scripting-dependencies-maven"})
public final class MavenDependenciesResolver
implements ExternalDependenciesResolver {
    @NotNull
    private final File localRepo;
    @NotNull
    private final ArrayList<RemoteRepository> repos;

    public MavenDependenciesResolver() {
        String string2 = System.getProperty("user.home");
        Intrinsics.checkNotNull(string2);
        this.localRepo = new File(new File(string2, ".m2"), "repository");
        boolean bl = false;
        this.repos = new ArrayList();
    }

    @Override
    public boolean acceptsArtifact(@NotNull String artifactCoordinates) {
        Intrinsics.checkNotNullParameter(artifactCoordinates, "artifactCoordinates");
        return this.toMavenArtifact(artifactCoordinates) != null;
    }

    @Override
    public boolean acceptsRepository(@NotNull RepositoryCoordinates repositoryCoordinates) {
        Intrinsics.checkNotNullParameter(repositoryCoordinates, "repositoryCoordinates");
        return ResolverUtilsKt.toRepositoryUrlOrNull(repositoryCoordinates) != null;
    }

    @NotNull
    public final File getLocalRepo() {
        return this.localRepo;
    }

    @NotNull
    public final ArrayList<RemoteRepository> getRepos() {
        return this.repos;
    }

    private final ArrayList<RemoteRepository> remoteRepositories() {
        ArrayList<RemoteRepository> arrayList;
        if (this.repos.isEmpty()) {
            RemoteRepository[] remoteRepositoryArray = new RemoteRepository[]{AetherKt.getMavenCentral()};
            arrayList = CollectionsKt.arrayListOf(remoteRepositoryArray);
        } else {
            arrayList = this.repos;
        }
        return arrayList;
    }

    private final List<Object> allRepositories() {
        return CollectionsKt.plus((Collection)this.remoteRepositories(), this.localRepo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DefaultArtifact toMavenArtifact(String $this$toMavenArtifact) {
        CharSequence charSequence = $this$toMavenArtifact;
        boolean bl = false;
        if (StringsKt.isBlank(charSequence)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        CharSequence $this$count$iv = $this$toMavenArtifact;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence2 = $this$count$iv;
        for (int i = 0; i < charSequence2.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence2.charAt(i);
            boolean bl3 = false;
            if (!(it == ':')) continue;
            ++count$iv;
        }
        if (count$iv < 2) return null;
        DefaultArtifact defaultArtifact = new DefaultArtifact($this$toMavenArtifact);
        return defaultArtifact;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object resolve(@NotNull String artifactCoordinates, @NotNull ExternalDependenciesResolver.Options options, @Nullable SourceCode.LocationWithId sourceCodeLocation, @NotNull Continuation<? super ResultWithDiagnostics<? extends List<? extends File>>> $completion) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        DefaultArtifact defaultArtifact = this.toMavenArtifact(artifactCoordinates);
        Intrinsics.checkNotNull(defaultArtifact);
        DefaultArtifact artifactId = defaultArtifact;
        try {
            List<String> list2;
            List<String> list3 = ResolverNamedOptionsKt.getDependencyScopes(options);
            if (list3 == null) {
                String[] stringArray = new String[]{"compile", "runtime"};
                list2 = CollectionsKt.listOf(stringArray);
            } else {
                list2 = list3;
            }
            List<String> dependencyScopes = list2;
            List deps = AetherResolveSession.resolve$default(new AetherResolveSession(this.getLocalRepo(), (List<RemoteRepository>)this.remoteRepositories()), artifactId, CollectionsKt.joinToString$default(dependencyScopes, ",", null, null, 0, null, null, 62, null), null, 4, null);
            if (deps != null) {
                Collection<File> collection;
                void $this$mapTo$iv$iv2;
                $this$map$iv = deps;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Artifact artifact = (Artifact)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    File file2 = it.getFile();
                    collection.add(file2);
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 2;
                List list4 = null;
                List list5 = collection;
                return new ResultWithDiagnostics.Success(list5, list4, n, defaultConstructorMarker);
            }
        }
        catch (DependencyResolutionException e) {
            String deps = e.getMessage();
            return ResolverUtilsKt.makeResolveFailureResult(deps == null ? "unknown error" : deps, sourceCodeLocation);
        }
        Iterable $this$map$iv2 = this.allRepositories();
        boolean $i$f$map = false;
        $this$map$iv = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it + ": " + artifactId + " not found";
            collection.add(string2);
        }
        return ResolverUtilsKt.makeResolveFailureResult((List)destination$iv$iv, sourceCodeLocation);
    }

    private final String tryResolveEnvironmentVariable(String str) {
        String string2;
        if (StringsKt.startsWith$default(str, "$", false, 2, null)) {
            String string3 = str;
            int n = 1;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
            String string6 = System.getenv(string5);
            string2 = string6 == null ? str : string6;
        } else {
            string2 = str;
        }
        return string2;
    }

    @Override
    @NotNull
    public ResultWithDiagnostics<Boolean> addRepository(@NotNull RepositoryCoordinates repositoryCoordinates, @NotNull ExternalDependenciesResolver.Options options, @Nullable SourceCode.LocationWithId sourceCodeLocation) {
        Intrinsics.checkNotNullParameter(repositoryCoordinates, "repositoryCoordinates");
        Intrinsics.checkNotNullParameter(options, "options");
        URL uRL = ResolverUtilsKt.toRepositoryUrlOrNull(repositoryCoordinates);
        if (uRL == null) {
            return ErrorHandlingKt.asSuccess$default(false, null, 1, null);
        }
        URL url = uRL;
        RemoteRepository.Builder repo = new RemoteRepository.Builder(repositoryCoordinates.getString(), "default", url.toString());
        if (repositoryCoordinates instanceof MavenRepositoryCoordinates) {
            String string2;
            boolean bl;
            String string3;
            String string4;
            String string5 = ((MavenRepositoryCoordinates)repositoryCoordinates).getUsername();
            if (string5 == null) {
                string4 = null;
            } else {
                string3 = string5;
                boolean bl2 = false;
                bl = false;
                String p0 = string3;
                boolean bl3 = false;
                string4 = this.tryResolveEnvironmentVariable(p0);
            }
            String username = string4;
            string3 = ((MavenRepositoryCoordinates)repositoryCoordinates).getPassword();
            if (string3 == null) {
                string2 = null;
            } else {
                String string6 = string3;
                bl = false;
                boolean bl4 = false;
                String p0 = string6;
                boolean bl5 = false;
                string2 = this.tryResolveEnvironmentVariable(p0);
            }
            String password = string2;
            if (username != null) {
                AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
                bl = false;
                boolean bl6 = false;
                AuthenticationBuilder $this$addRepository_u24lambda_u2d4 = authenticationBuilder;
                boolean bl7 = false;
                $this$addRepository_u24lambda_u2d4.addUsername(username);
                if (password != null) {
                    $this$addRepository_u24lambda_u2d4.addPassword(password);
                }
                AuthenticationBuilder auth = authenticationBuilder;
                repo.setAuthentication(auth.build());
            }
        }
        this.repos.add(repo.build());
        return ErrorHandlingKt.asSuccess$default(true, null, 1, null);
    }
}

