/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuite
implements Test {
    private String fName;
    private Vector<Test> fTests = new Vector(10);

    public static Test createTest(Class<? extends TestCase> theClass, String name2) {
        TestCase test;
        Constructor<? extends TestCase> constructor2;
        try {
            constructor2 = TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e) {
            return TestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()");
        }
        try {
            if (constructor2.getParameterTypes().length == 0) {
                test = constructor2.newInstance(new Object[0]);
                if (test instanceof TestCase) {
                    test.setName(name2);
                }
            } else {
                test = constructor2.newInstance(name2);
            }
        }
        catch (InstantiationException e) {
            return TestSuite.warning("Cannot instantiate test case: " + name2 + " (" + TestSuite.exceptionToString(e) + ")");
        }
        catch (InvocationTargetException e) {
            return TestSuite.warning("Exception in constructor: " + name2 + " (" + TestSuite.exceptionToString(e.getTargetException()) + ")");
        }
        catch (IllegalAccessException e) {
            return TestSuite.warning("Cannot access test case: " + name2 + " (" + TestSuite.exceptionToString(e) + ")");
        }
        return test;
    }

    public static Constructor<? extends TestCase> getTestConstructor(Class<? extends TestCase> theClass) throws NoSuchMethodException {
        Class[] args2 = new Class[]{String.class};
        try {
            return theClass.getConstructor(args2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return theClass.getConstructor(new Class[0]);
        }
    }

    public static Test warning(final String message2) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail(message2);
            }
        };
    }

    private static String exceptionToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public TestSuite() {
    }

    public TestSuite(Class<? extends TestCase> theClass) {
        this.fName = theClass.getName();
        try {
            TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e) {
            this.addTest(TestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(TestSuite.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class<? extends TestCase> superClass2 = theClass;
        ArrayList<String> names2 = new ArrayList<String>();
        while (Test.class.isAssignableFrom(superClass2)) {
            Method[] methodArray = superClass2.getDeclaredMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method each = methodArray[n];
                this.addTestMethod(each, names2, theClass);
                ++n;
            }
            superClass2 = superClass2.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(TestSuite.warning("No tests found in " + theClass.getName()));
        }
    }

    public TestSuite(Class<? extends TestCase> theClass, String name2) {
        this(theClass);
        this.setName(name2);
    }

    public TestSuite(String name2) {
        this.setName(name2);
    }

    public TestSuite(Class<? extends TestCase> ... classes2) {
        Class<? extends TestCase>[] classArray = classes2;
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<? extends TestCase> each = classArray[n];
            this.addTest(new TestSuite(each));
            ++n;
        }
    }

    public TestSuite(Class<? extends TestCase>[] classes2, String name2) {
        this(classes2);
        this.setName(name2);
    }

    public void addTest(Test test) {
        this.fTests.add(test);
    }

    public void addTestSuite(Class<? extends TestCase> testClass) {
        this.addTest(new TestSuite(testClass));
    }

    @Override
    public int countTestCases() {
        int count2 = 0;
        for (Test each : this.fTests) {
            count2 += each.countTestCases();
        }
        return count2;
    }

    public String getName() {
        return this.fName;
    }

    @Override
    public void run(TestResult result2) {
        for (Test each : this.fTests) {
            if (result2.shouldStop()) break;
            this.runTest(each, result2);
        }
    }

    public void runTest(Test test, TestResult result2) {
        test.run(result2);
    }

    public void setName(String name2) {
        this.fName = name2;
    }

    public Test testAt(int index2) {
        return this.fTests.get(index2);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration<Test> tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    private void addTestMethod(Method m3, List<String> names2, Class<? extends TestCase> theClass) {
        String name2 = m3.getName();
        if (names2.contains(name2)) {
            return;
        }
        if (!this.isPublicTestMethod(m3)) {
            if (this.isTestMethod(m3)) {
                this.addTest(TestSuite.warning("Test method isn't public: " + m3.getName()));
            }
            return;
        }
        names2.add(name2);
        this.addTest(TestSuite.createTest(theClass, name2));
    }

    private boolean isPublicTestMethod(Method m3) {
        return this.isTestMethod(m3) && Modifier.isPublic(m3.getModifiers());
    }

    private boolean isTestMethod(Method m3) {
        String name2 = m3.getName();
        Class<?>[] parameters2 = m3.getParameterTypes();
        Class<?> returnType2 = m3.getReturnType();
        return parameters2.length == 0 && name2.startsWith("test") && returnType2.equals(Void.TYPE);
    }
}

