/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.reddit;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.announce.RedditAnnouncer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.reddit.RedditSdk;
import org.jreleaser.sdk.reddit.RedditSdkException;
import org.jreleaser.util.StringUtils;

public class RedditAnnouncer
implements Announcer<org.jreleaser.model.api.announce.RedditAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.RedditAnnouncer reddit;

    public RedditAnnouncer(JReleaserContext context) {
        this.context = context;
        this.reddit = context.getModel().getAnnounce().getReddit();
    }

    public org.jreleaser.model.api.announce.RedditAnnouncer getAnnouncer() {
        return this.reddit.asImmutable();
    }

    public String getName() {
        return "reddit";
    }

    public boolean isEnabled() {
        return this.reddit.isEnabled();
    }

    public void announce() throws AnnounceException {
        String subreddit = this.reddit.getSubreddit();
        String title = this.reddit.getResolvedTitle(this.context);
        String text = "";
        String url = "";
        if (this.reddit.getSubmissionType() == RedditAnnouncer.SubmissionType.SELF) {
            if (StringUtils.isNotBlank((String)this.reddit.getText())) {
                text = this.reddit.getResolvedText(this.context);
            } else {
                TemplateContext props = new TemplateContext();
                this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
                text = this.reddit.getResolvedTextTemplate(this.context, props);
            }
        } else {
            url = this.reddit.getResolvedUrl(this.context);
        }
        this.context.getLogger().info(RB.$((String)"reddit.submission.creating", (Object[])new Object[0]), new Object[]{this.reddit.getSubmissionType().formatted(), this.reddit.getSubreddit()});
        this.context.getLogger().debug(RB.$((String)"reddit.submission.title", (Object[])new Object[0]), new Object[]{title});
        if (this.reddit.getSubmissionType() == RedditAnnouncer.SubmissionType.SELF) {
            this.context.getLogger().debug(RB.$((String)"reddit.submission.text", (Object[])new Object[0]), new Object[]{text});
        } else {
            this.context.getLogger().debug(RB.$((String)"reddit.submission.url", (Object[])new Object[0]), new Object[]{url});
        }
        try {
            RedditSdk sdk = RedditSdk.builder(this.context.asImmutable()).clientId(this.reddit.getClientId()).clientSecret(this.reddit.getClientSecret()).username(this.reddit.getUsername()).password(this.reddit.getPassword()).connectTimeout(this.reddit.getConnectTimeout()).readTimeout(this.reddit.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            TemplateContext props = this.context.fullProps();
            props.set("redditTitle", (Object)title);
            props.set("redditSubreddit", (Object)MustacheUtils.passThrough((String)"{{redditSubreddit}}"));
            MustacheUtils.applyTemplates((TemplateContext)props, (Map)this.reddit.resolvedExtraProperties());
            title = MustacheUtils.applyTemplate((String)title, (TemplateContext)props);
            if (this.reddit.getSubmissionType() == RedditAnnouncer.SubmissionType.SELF) {
                text = MustacheUtils.applyTemplate((String)text, (TemplateContext)props);
                sdk.submitTextPost(subreddit, title, text);
            } else {
                url = MustacheUtils.applyTemplate((String)url, (TemplateContext)props);
                sdk.submitLinkPost(subreddit, title, url);
            }
        }
        catch (RedditSdkException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new AnnounceException((Throwable)e);
        }
    }
}

