/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.model.api.packagers.WingetPackager;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class WingetPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.WingetPackager, WingetPackager> {
    private static final long serialVersionUID = -9015011090998365168L;
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final WingetRepository repository = new WingetRepository();
    private final List<String> tags = new ArrayList<String>();
    @JsonProperty(value="package")
    private final Package pack = new Package();
    private final Publisher publisher = new Publisher();
    private final Installer installer = new Installer();
    private String defaultLocale;
    private String author;
    private String moniker;
    private String minimumOsVersion;
    private String productCode;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.WingetPackager immutable = new org.jreleaser.model.api.packagers.WingetPackager(){
        private static final long serialVersionUID = -6514405944610257520L;

        public WingetPackager.Package getPackage() {
            return WingetPackager.this.getPackage().asImmutable();
        }

        public WingetPackager.Publisher getPublisher() {
            return WingetPackager.this.getPublisher().asImmutable();
        }

        public WingetPackager.Installer getInstaller() {
            return WingetPackager.this.getInstaller().asImmutable();
        }

        public String getDefaultLocale() {
            return WingetPackager.this.getDefaultLocale();
        }

        public String getAuthor() {
            return WingetPackager.this.getAuthor();
        }

        public String getMoniker() {
            return WingetPackager.this.getMoniker();
        }

        public List<String> getTags() {
            return Collections.unmodifiableList(WingetPackager.this.getTags());
        }

        public String getMinimumOsVersion() {
            return WingetPackager.this.getMinimumOsVersion();
        }

        public String getProductCode() {
            return WingetPackager.this.getProductCode();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return WingetPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return WingetPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return WingetPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(WingetPackager.this.getSkipTemplates());
        }

        public String getType() {
            return WingetPackager.this.getType();
        }

        public String getDownloadUrl() {
            return WingetPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return WingetPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return WingetPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return WingetPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return WingetPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return WingetPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return WingetPackager.this.isContinueOnError();
        }

        public boolean isSkipPublishing() {
            return WingetPackager.this.isSkipPublishing();
        }

        public Active getActive() {
            return WingetPackager.this.getActive();
        }

        public boolean isEnabled() {
            return WingetPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(WingetPackager.this.asMap(full));
        }

        public String getPrefix() {
            return WingetPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(WingetPackager.this.getExtraProperties());
        }
    };

    public WingetPackager() {
        super("winget");
    }

    @Override
    public org.jreleaser.model.api.packagers.WingetPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(WingetPackager source) {
        super.merge(source);
        this.defaultLocale = this.merge(this.defaultLocale, source.defaultLocale);
        this.author = this.merge(this.author, source.author);
        this.moniker = this.merge(this.moniker, source.moniker);
        this.minimumOsVersion = this.merge(this.minimumOsVersion, source.minimumOsVersion);
        this.productCode = this.merge(this.productCode, source.productCode);
        this.setPackage(source.pack);
        this.setPublisher(source.publisher);
        this.setInstaller(source.installer);
        this.setRepository(source.repository);
        this.setTags(this.merge(this.tags, source.tags));
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMoniker() {
        return this.moniker;
    }

    public void setMoniker(String moniker) {
        this.moniker = moniker;
    }

    public String getMinimumOsVersion() {
        return this.minimumOsVersion;
    }

    public void setMinimumOsVersion(String minimumOsVersion) {
        this.minimumOsVersion = minimumOsVersion;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    @JsonProperty(value="package")
    public Package getPackage() {
        return this.pack;
    }

    public void setPackage(Package pack) {
        this.pack.merge(pack);
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher.merge(publisher);
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public void setInstaller(Installer installer) {
        this.installer.merge(installer);
    }

    public WingetRepository getRepository() {
        return this.repository;
    }

    public void setRepository(WingetRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("defaultLocale", this.defaultLocale);
        props.put("author", this.author);
        props.put("moniker", this.moniker);
        props.put("minimumOsVersion", this.minimumOsVersion);
        props.put("productCode", this.productCode);
        props.put("package", this.pack.asMap(full));
        props.put("publisher", this.publisher.asMap(full));
        props.put("installer", this.installer.asMap(full));
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipWinget"));
    }

    static {
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.BINARY, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.JLINK, CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()}));
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.MSI.extension(), FileType.EXE.extension()}));
    }

    public static final class WingetRepository
    extends PackagerRepository {
        private static final long serialVersionUID = -3859984358170896375L;

        public WingetRepository() {
            super("winget", "winget");
        }
    }

    public static final class Package
    extends AbstractModelObject<Package>
    implements Domain {
        private static final long serialVersionUID = -8531840172639009180L;
        private String identifier;
        private String name;
        private String version;
        private String url;
        @JsonIgnore
        private final WingetPackager.Package immutable = new WingetPackager.Package(){
            private static final long serialVersionUID = -681067573112565263L;

            public String getIdentifier() {
                return this.getIdentifier();
            }

            public String getName() {
                return this.getName();
            }

            public String getUrl() {
                return this.getUrl();
            }

            public String getVersion() {
                return this.getVersion();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WingetPackager.Package asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Package source) {
            this.identifier = this.merge(this.identifier, source.identifier);
            this.name = this.merge(this.name, source.name);
            this.version = this.merge(this.version, source.version);
            this.url = this.merge(this.url, source.url);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("identifier", this.identifier);
            props.put("name", this.name);
            props.put("version", this.version);
            props.put("url", this.url);
            return props;
        }
    }

    public static final class Publisher
    extends AbstractModelObject<Publisher>
    implements Domain {
        private static final long serialVersionUID = -3812598331451051428L;
        private String name;
        private String url;
        private String supportUrl;
        @JsonIgnore
        private final WingetPackager.Publisher immutable = new WingetPackager.Publisher(){
            private static final long serialVersionUID = -5458105963902729331L;

            public String getName() {
                return this.getName();
            }

            public String getUrl() {
                return this.getUrl();
            }

            public String getSupportUrl() {
                return this.getSupportUrl();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WingetPackager.Publisher asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Publisher source) {
            this.name = this.merge(this.name, source.name);
            this.url = this.merge(this.url, source.url);
            this.supportUrl = this.merge(this.supportUrl, source.supportUrl);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getSupportUrl() {
            return this.supportUrl;
        }

        public void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("name", this.name);
            props.put("url", this.url);
            props.put("supportUrl", this.supportUrl);
            return props;
        }
    }

    public static final class Installer
    extends AbstractModelObject<Installer>
    implements Domain {
        private static final long serialVersionUID = 4609121090512808243L;
        private final Set<WingetPackager.Installer.Mode> modes = new LinkedHashSet<WingetPackager.Installer.Mode>();
        private final Dependencies dependencies = new Dependencies();
        private WingetPackager.Installer.Type type = WingetPackager.Installer.Type.WIX;
        private WingetPackager.Installer.Scope scope = WingetPackager.Installer.Scope.MACHINE;
        private WingetPackager.Installer.UpgradeBehavior upgradeBehavior = WingetPackager.Installer.UpgradeBehavior.INSTALL;
        private String command;
        @JsonIgnore
        private final WingetPackager.Installer immutable = new WingetPackager.Installer(){
            private static final long serialVersionUID = 8677697915447641476L;

            public WingetPackager.Installer.Type getType() {
                return this.getType();
            }

            public WingetPackager.Installer.Scope getScope() {
                return this.getScope();
            }

            public Set<WingetPackager.Installer.Mode> getModes() {
                return Collections.unmodifiableSet(this.getModes());
            }

            public WingetPackager.Installer.UpgradeBehavior getUpgradeBehavior() {
                return this.getUpgradeBehavior();
            }

            public String getCommand() {
                return this.getCommand();
            }

            public WingetPackager.Dependencies getDependencies() {
                return this.getDependencies().asImmutable();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WingetPackager.Installer asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Installer source) {
            this.type = this.merge(this.type, source.type);
            this.scope = this.merge(this.scope, source.scope);
            this.upgradeBehavior = this.merge(this.upgradeBehavior, source.upgradeBehavior);
            this.command = this.merge(this.command, source.command);
            this.setModes(this.merge(this.modes, source.modes));
            this.setDependencies(source.dependencies);
        }

        public WingetPackager.Installer.Type getType() {
            return this.type;
        }

        public void setType(WingetPackager.Installer.Type type) {
            this.type = type;
        }

        public void setType(String str) {
            this.setType(WingetPackager.Installer.Type.of((String)str));
        }

        public WingetPackager.Installer.Scope getScope() {
            return this.scope;
        }

        public void setScope(WingetPackager.Installer.Scope scope) {
            this.scope = scope;
        }

        public void setScope(String str) {
            this.setScope(WingetPackager.Installer.Scope.of((String)str));
        }

        public WingetPackager.Installer.UpgradeBehavior getUpgradeBehavior() {
            return this.upgradeBehavior;
        }

        public void setUpgradeBehavior(WingetPackager.Installer.UpgradeBehavior upgradeBehavior) {
            this.upgradeBehavior = upgradeBehavior;
        }

        public void setUpgradeBehavior(String str) {
            this.setUpgradeBehavior(WingetPackager.Installer.UpgradeBehavior.of((String)str));
        }

        public Set<WingetPackager.Installer.Mode> getModes() {
            return this.modes;
        }

        public void setModes(Set<WingetPackager.Installer.Mode> modes) {
            this.modes.clear();
            this.modes.addAll(modes);
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public Dependencies getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Dependencies dependencies) {
            this.dependencies.merge(dependencies);
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("type", this.type);
            props.put("scope", this.scope);
            props.put("upgradeBehavior", this.upgradeBehavior);
            props.put("modes", this.modes);
            props.put("command", this.command);
            props.put("dependencies", this.dependencies.asMap(full));
            return props;
        }
    }

    public static final class PackageDependency
    extends AbstractModelObject<PackageDependency>
    implements Domain,
    Comparable<PackageDependency> {
        private static final long serialVersionUID = -4450142474645845838L;
        private String packageIdentifier;
        private String minimumVersion;
        @JsonIgnore
        private final WingetPackager.PackageDependency immutable = new WingetPackager.PackageDependency(){
            private static final long serialVersionUID = -8028336005839082886L;

            public String getPackageIdentifier() {
                return packageIdentifier;
            }

            public String getMinimumVersion() {
                return minimumVersion;
            }

            public Map<String, Object> asMap(boolean full) {
                return this.asMap(full);
            }
        };

        public WingetPackager.PackageDependency asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(PackageDependency source) {
            this.packageIdentifier = this.merge(this.packageIdentifier, source.packageIdentifier);
            this.minimumVersion = this.merge(this.minimumVersion, source.minimumVersion);
        }

        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        public void setPackageIdentifier(String packageIdentifier) {
            this.packageIdentifier = packageIdentifier;
        }

        public String getMinimumVersion() {
            return this.minimumVersion;
        }

        public void setMinimumVersion(String minimumVersion) {
            this.minimumVersion = minimumVersion;
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("packageIdentifier", this.packageIdentifier);
            props.put("minimumVersion", this.minimumVersion);
            return props;
        }

        @Override
        public int compareTo(PackageDependency o) {
            return Comparator.comparing(PackageDependency::getPackageIdentifier).compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageDependency that = (PackageDependency)o;
            return this.packageIdentifier.equals(that.packageIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.packageIdentifier);
        }
    }

    public static final class Dependencies
    extends AbstractModelObject<Dependencies>
    implements Domain {
        private static final long serialVersionUID = 8335992485241726722L;
        private final Set<String> windowsFeatures = new LinkedHashSet<String>();
        private final Set<String> windowsLibraries = new LinkedHashSet<String>();
        private final Set<String> externalDependencies = new LinkedHashSet<String>();
        private final Set<PackageDependency> packageDependencies = new LinkedHashSet<PackageDependency>();
        @JsonIgnore
        private final WingetPackager.Dependencies immutable = new WingetPackager.Dependencies(){
            private static final long serialVersionUID = -2782564782601367602L;

            public Set<String> getWindowsFeatures() {
                return Collections.unmodifiableSet(this.getWindowsFeatures());
            }

            public Set<String> getWindowsLibraries() {
                return Collections.unmodifiableSet(this.getWindowsLibraries());
            }

            public Set<String> getExternalDependencies() {
                return Collections.unmodifiableSet(this.getExternalDependencies());
            }

            public Set<WingetPackager.PackageDependency> getPackageDependencies() {
                return Collections.unmodifiableSet(this.asImmutable().getPackageDependencies());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public WingetPackager.Dependencies asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Dependencies source) {
            this.setWindowsFeatures(this.merge(this.windowsFeatures, source.windowsFeatures));
            this.setWindowsLibraries(this.merge(this.windowsLibraries, source.windowsLibraries));
            this.setExternalDependencies(this.merge(this.externalDependencies, source.externalDependencies));
            this.setPackageDependencies(this.mergeModel(this.packageDependencies, source.packageDependencies));
        }

        public boolean hasDependencies() {
            return !this.windowsFeatures.isEmpty() || !this.windowsLibraries.isEmpty() || !this.externalDependencies.isEmpty() || !this.packageDependencies.isEmpty();
        }

        public boolean hasWindowsFeatures() {
            return !this.windowsFeatures.isEmpty();
        }

        public boolean hasWindowsLibraries() {
            return !this.windowsLibraries.isEmpty();
        }

        public boolean hasExternalDependencies() {
            return !this.externalDependencies.isEmpty();
        }

        public boolean hasPackageDependencies() {
            return !this.packageDependencies.isEmpty();
        }

        public Set<String> getWindowsFeatures() {
            return this.windowsFeatures;
        }

        public void setWindowsFeatures(Set<String> windowsFeatures) {
            this.windowsFeatures.clear();
            this.windowsFeatures.addAll(windowsFeatures);
        }

        public Set<String> getWindowsLibraries() {
            return this.windowsLibraries;
        }

        public void setWindowsLibraries(Set<String> windowsLibraries) {
            this.windowsLibraries.clear();
            this.windowsLibraries.addAll(windowsLibraries);
        }

        public Set<String> getExternalDependencies() {
            return this.externalDependencies;
        }

        public void setExternalDependencies(Set<String> externalDependencies) {
            this.externalDependencies.clear();
            this.externalDependencies.addAll(externalDependencies);
        }

        public Set<PackageDependency> getPackageDependencies() {
            return this.packageDependencies;
        }

        public void setPackageDependencies(Set<PackageDependency> packageDependencies) {
            this.packageDependencies.clear();
            this.packageDependencies.addAll(packageDependencies);
        }

        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("windowsFeatures", this.windowsFeatures);
            props.put("windowsLibraries", this.windowsLibraries);
            props.put("externalDependencies", this.externalDependencies);
            LinkedHashMap<String, Map<String, Object>> mappedDependencies = new LinkedHashMap<String, Map<String, Object>>();
            int i = 0;
            for (PackageDependency dependency : this.packageDependencies) {
                mappedDependencies.put("packageDependency " + i++, dependency.asMap(full));
            }
            props.put("packageDependencies", mappedDependencies);
            return props;
        }

        public void addPackageDependency(PackageDependency packageDependency) {
            this.setPackageDependencies(this.mergeModel(this.packageDependencies, Collections.singleton(packageDependency)));
        }
    }
}

