/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.cli.Main;
import org.jreleaser.engine.context.ModelAutoConfigurer;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="release")
public class Release
extends AbstractPlatformAwareModelCommand<Main> {
    @CommandLine.Option(names={"--dry-run"})
    Boolean dryrun;
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-d", "--distribution", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xd", "--exclude-distribution", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-y", "--deployer", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-yn", "--deployer-name", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xy", "--exclude-deployer", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xyn", "--exclude-deployer-name", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-u", "--uploader", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-un", "--uploader-name", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xu", "--exclude-uploader", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xun", "--exclude-uploader-name", "1.5.0"));
    }

    @Override
    protected JReleaserContext createContext() {
        JReleaserContext context = super.createContext();
        if (null != this.composite) {
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setIncludedDeployerTypes(this.collectEntries(this.composite.includedDeployerTypes(), true));
            context.setIncludedDeployerNames(this.collectEntries(this.composite.includedDeployerNames()));
            context.setIncludedUploaderTypes(this.collectEntries(this.composite.includedUploaderTypes(), true));
            context.setIncludedUploaderNames(this.collectEntries(this.composite.includedUploaderNames()));
            context.setIncludedCatalogers(this.collectEntries(this.composite.includedCatalogers(), true));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
            context.setExcludedDeployerTypes(this.collectEntries(this.composite.excludedDeployerTypes(), true));
            context.setExcludedDeployerNames(this.collectEntries(this.composite.excludedDeployerNames()));
            context.setExcludedUploaderTypes(this.collectEntries(this.composite.excludedUploaderTypes(), true));
            context.setExcludedUploaderNames(this.collectEntries(this.composite.excludedUploaderNames()));
            context.setExcludedCatalogers(this.collectEntries(this.composite.excludedCatalogers(), true));
        }
        return context;
    }

    @Override
    protected void execute() {
        if (null == this.composite || !this.composite.isAutoConfig()) {
            super.execute();
            return;
        }
        this.basedir();
        this.initLogger();
        JReleaserContext context = ModelAutoConfigurer.builder().logger(this.logger).basedir(this.actualBasedir).outputDirectory(this.getOutputDirectory()).yolo(this.yolo()).dryrun(this.dryrun()).gitRootSearch(this.gitRootSearch()).strict(this.strict()).projectName(this.composite.autoConfig.projectName).projectVersion(this.composite.autoConfig.projectVersion).projectVersionPattern(this.composite.autoConfig.projectVersionPattern).projectSnapshotPattern(this.composite.autoConfig.projectSnapshotPattern).projectSnapshotLabel(this.composite.autoConfig.projectSnapshotLabel).projectSnapshotFullChangelog(this.composite.autoConfig.projectSnapshotFullChangelog).projectCopyright(this.composite.autoConfig.projectCopyright).projectDescription(this.composite.autoConfig.projectDescription).projectInceptionYear(this.composite.autoConfig.projectInceptionYear).projectStereotype(this.composite.autoConfig.projectStereotype).authors(this.collectEntries(this.composite.autoConfig.authors)).tagName(this.composite.autoConfig.tagName).previousTagName(this.composite.autoConfig.previousTagName).releaseName(this.composite.autoConfig.releaseName).milestoneName(this.composite.autoConfig.milestoneName).branch(this.composite.autoConfig.branch).prerelease(this.composite.autoConfig.prerelease).prereleasePattern(this.composite.autoConfig.prereleasePattern).draft(this.composite.autoConfig.draft).overwrite(this.composite.autoConfig.overwrite).update(this.composite.autoConfig.update).updateSections(this.collectUpdateSections()).skipTag(this.composite.autoConfig.skipTag).skipRelease(this.composite.autoConfig.skipRelease).skipChecksums(this.composite.autoConfig.skipChecksums).changelog(this.composite.autoConfig.changelog).changelogFormatted(this.composite.autoConfig.changelogFormatted).username(this.composite.autoConfig.username).commitAuthorName(this.composite.autoConfig.commitAuthorName).commitAuthorEmail(this.composite.autoConfig.commitAuthorEmail).signing(this.composite.autoConfig.signing).armored(this.composite.autoConfig.armored).files(this.collectEntries(this.composite.autoConfig.files)).globs(this.collectEntries(this.composite.autoConfig.globs)).selectedPlatforms(this.collectSelectedPlatforms()).rejectedPlatforms(this.collectRejectedPlatforms()).autoConfigure();
        this.doExecute(context);
    }

    private Set<UpdateSection> collectUpdateSections() {
        LinkedHashSet<UpdateSection> set = new LinkedHashSet<UpdateSection>();
        if (null != this.composite.autoConfig.updateSections && this.composite.autoConfig.updateSections.length > 0) {
            for (String updateSection : this.composite.autoConfig.updateSections) {
                set.add(UpdateSection.of((String)updateSection.trim()));
            }
        }
        return set;
    }

    private void basedir() {
        Path path = this.actualBasedir = null != this.basedir ? this.basedir : Paths.get(".", new String[0]).normalize();
        if (!Files.exists(this.actualBasedir, new LinkOption[0])) {
            throw this.halt(this.$("ERROR_missing_required_option", "--basedir=<basedir>"));
        }
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        Workflows.release((JReleaserContext)context).execute();
    }

    @Override
    protected Boolean dryrun() {
        return this.dryrun;
    }

    private HaltExecutionException halt(String message) throws HaltExecutionException {
        this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(message));
        this.spec.commandLine().usage(((Main)this.parent()).getOut());
        throw new HaltExecutionException();
    }

    @Override
    protected JReleaserCommand getCommand() {
        return JReleaserCommand.RELEASE;
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;
        @CommandLine.ArgGroup(exclusive=false, order=3, headingKey="auto-config.header")
        AutoConfigGroup autoConfig;

        Composite() {
        }

        String[] includedDistributions() {
            return null != this.include ? this.include.includedDistributions : null;
        }

        String[] excludedDistributions() {
            return null != this.exclude ? this.exclude.excludedDistributions : null;
        }

        String[] includedDeployerTypes() {
            return null != this.include ? this.include.includedDeployerTypes : null;
        }

        String[] includedDeployerNames() {
            return null != this.include ? this.include.includedDeployerNames : null;
        }

        String[] excludedDeployerTypes() {
            return null != this.exclude ? this.exclude.excludedDeployerTypes : null;
        }

        String[] excludedDeployerNames() {
            return null != this.exclude ? this.exclude.excludedDeployerNames : null;
        }

        String[] includedUploaderTypes() {
            return null != this.include ? this.include.includedUploaderTypes : null;
        }

        String[] includedUploaderNames() {
            return null != this.include ? this.include.includedUploaderNames : null;
        }

        String[] excludedUploaderTypes() {
            return null != this.exclude ? this.exclude.excludedUploaderTypes : null;
        }

        String[] excludedUploaderNames() {
            return null != this.exclude ? this.exclude.excludedUploaderNames : null;
        }

        String[] includedCatalogers() {
            return null != this.include ? this.include.includedCatalogers : null;
        }

        String[] excludedCatalogers() {
            return null != this.exclude ? this.exclude.excludedCatalogers : null;
        }

        boolean isAutoConfig() {
            return null != this.autoConfig && this.autoConfig.autoConfig;
        }
    }

    static class AutoConfigGroup {
        @CommandLine.Option(names={"--auto-config"})
        boolean autoConfig;
        @CommandLine.Option(names={"--project-name"}, paramLabel="<name>")
        String projectName;
        @CommandLine.Option(names={"--project-version"}, paramLabel="<version>")
        String projectVersion;
        @CommandLine.Option(names={"--project-version-pattern"}, paramLabel="<pattern>")
        String projectVersionPattern;
        @CommandLine.Option(names={"--project-snapshot-pattern"}, paramLabel="<pattern>")
        String projectSnapshotPattern;
        @CommandLine.Option(names={"--project-snapshot-label"}, paramLabel="<label>")
        String projectSnapshotLabel;
        @CommandLine.Option(names={"--project-snapshot-full-changelog"})
        boolean projectSnapshotFullChangelog;
        @CommandLine.Option(names={"--project-copyright"}, paramLabel="<copyright>")
        String projectCopyright;
        @CommandLine.Option(names={"--project-description"}, paramLabel="<description>")
        String projectDescription;
        @CommandLine.Option(names={"--project-inception-year"}, paramLabel="<year>")
        String projectInceptionYear;
        @CommandLine.Option(names={"--project-stereotype"}, paramLabel="<stereotype>")
        String projectStereotype;
        @CommandLine.Option(names={"--author"}, paramLabel="<author>")
        String[] authors;
        @CommandLine.Option(names={"--tag-name"}, paramLabel="<tag>")
        String tagName;
        @CommandLine.Option(names={"--previous-tag-name"}, paramLabel="<tag>")
        String previousTagName;
        @CommandLine.Option(names={"--release-name"}, paramLabel="<name>")
        String releaseName;
        @CommandLine.Option(names={"--milestone-name"}, paramLabel="<name>")
        String milestoneName;
        @CommandLine.Option(names={"--prerelease"})
        Boolean prerelease;
        @CommandLine.Option(names={"--prerelease-pattern"}, paramLabel="<pattern>")
        String prereleasePattern;
        @CommandLine.Option(names={"--draft"})
        Boolean draft;
        @CommandLine.Option(names={"--overwrite"})
        boolean overwrite;
        @CommandLine.Option(names={"--update"})
        boolean update;
        @CommandLine.Option(names={"--update-section"}, paramLabel="<section>")
        String[] updateSections;
        @CommandLine.Option(names={"--skip-tag"})
        boolean skipTag;
        @CommandLine.Option(names={"--skip-release"})
        boolean skipRelease;
        @CommandLine.Option(names={"--skip-checksums"})
        boolean skipChecksums;
        @CommandLine.Option(names={"--branch"})
        String branch;
        @CommandLine.Option(names={"--changelog"})
        String changelog;
        @CommandLine.Option(names={"--changelog-formatted"})
        boolean changelogFormatted;
        @CommandLine.Option(names={"--username"})
        String username;
        @CommandLine.Option(names={"--commit-author-name"}, paramLabel="<name>")
        String commitAuthorName;
        @CommandLine.Option(names={"--commit-author-email"}, paramLabel="<email>")
        String commitAuthorEmail;
        @CommandLine.Option(names={"--signing-enabled"})
        boolean signing;
        @CommandLine.Option(names={"--signing-armored"})
        boolean armored;
        @CommandLine.Option(names={"--file"}, paramLabel="<file>")
        String[] files;
        @CommandLine.Option(names={"--glob"}, paramLabel="<glob>")
        String[] globs;

        AutoConfigGroup() {
        }
    }

    static class Exclude {
        @CommandLine.Option(names={"-xd", "--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;
        @CommandLine.Option(names={"-xy", "--exclude-deployer"}, paramLabel="<deployer>")
        String[] excludedDeployerTypes;
        @CommandLine.Option(names={"-xyn", "--exclude-deployer-name"}, paramLabel="<name>")
        String[] excludedDeployerNames;
        @CommandLine.Option(names={"-xu", "--exclude-uploader"}, paramLabel="<uploader>")
        String[] excludedUploaderTypes;
        @CommandLine.Option(names={"-xun", "--exclude-uploader-name"}, paramLabel="<name>")
        String[] excludedUploaderNames;
        @CommandLine.Option(names={"--exclude-cataloger"}, paramLabel="<cataloger>")
        String[] excludedCatalogers;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;
        @CommandLine.Option(names={"-y", "--deployer"}, paramLabel="<deployer>")
        String[] includedDeployerTypes;
        @CommandLine.Option(names={"-yn", "--deployer-name"}, paramLabel="<name>")
        String[] includedDeployerNames;
        @CommandLine.Option(names={"-u", "--uploader"}, paramLabel="<uploader>")
        String[] includedUploaderTypes;
        @CommandLine.Option(names={"-un", "--uploader-name"}, paramLabel="<name>")
        String[] includedUploaderNames;
        @CommandLine.Option(names={"--cataloger"}, paramLabel="<cataloger>")
        String[] includedCatalogers;

        Include() {
        }
    }
}

