/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.MacportsPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class MacportsPackagerValidator {
    private MacportsPackagerValidator() {
    }

    public static void validateMacports(JReleaserContext context, Distribution distribution, MacportsPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        MacportsPackager parentPackager = model.getPackagers().getMacports();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".macports"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        context.getModel().getChecksum().getAlgorithms().add(Algorithm.RMD160);
        if (null == packager.getRevision()) {
            packager.setRevision(parentPackager.getRevision());
        }
        if (null == packager.getRevision()) {
            packager.setRevision(0);
        }
        if (packager.getMaintainers().isEmpty()) {
            packager.setMaintainers(parentPackager.getMaintainers());
        }
        if (packager.getCategories().isEmpty()) {
            packager.setCategories(parentPackager.getCategories());
        }
        if (packager.getCategories().isEmpty()) {
            packager.setCategories(Collections.singletonList("devel"));
        }
        if (distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE) {
            if (!packager.getExtraProperties().containsKey("appName") && parentPackager.getExtraProperties().containsKey("appName")) {
                packager.getExtraProperties().put("appName", parentPackager.getExtraProperties().get("appName"));
            }
            if (!packager.getExtraProperties().containsKey("appName")) {
                packager.getExtraProperties().put("appName", distribution.getName() + ".app");
            }
        }
        Validator.validateCommitAuthor(packager, parentPackager);
        MacportsPackager.MacportsRepository repository = packager.getRepository();
        Validator.validateRepository(context, distribution, repository, parentPackager.getRepository(), "macports.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        if ((distribution.getType() == Distribution.DistributionType.JAVA_BINARY || distribution.getType() == Distribution.DistributionType.SINGLE_JAR || DistributionsValidator.isGraalVMDistribution(distribution)) && StringUtils.isBlank((String)distribution.getJava().getVersion())) {
            errors.configuration(RB.$((String)"validation_is_missing", (Object[])new Object[]{"distribution." + distribution.getName() + ".java.version"}));
        }
        if (errors.hasErrors()) {
            packager.disable();
        }
    }
}

