/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.hooks;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.hooks.CommandHook;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.model.internal.validation.common.MatrixValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class CommandHooksValidator {
    private CommandHooksValidator() {
    }

    public static void validateCommandHooks(JReleaserContext context, Errors errors) {
        int i;
        context.getLogger().debug("hooks.command");
        CommandHooks hooks = context.getModel().getHooks().getCommand();
        boolean activeSet = hooks.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)hooks, "hooks.command", "ALWAYS");
        hooks.resolveEnabled(context.getModel().getProject());
        if (hooks.getMatrix().isEmpty()) {
            hooks.setMatrix(context.getModel().getHooks().getMatrix());
        }
        if (hooks.isApplyDefaultMatrix()) {
            hooks.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hooks.getMatrix(), "hooks.command.matrix", errors);
        for (i = 0; i < hooks.getBefore().size(); ++i) {
            CommandHooksValidator.validateCommandHook(context, hooks.getBefore().get(i), "before", i, errors);
        }
        for (i = 0; i < hooks.getSuccess().size(); ++i) {
            CommandHooksValidator.validateCommandHook(context, hooks.getSuccess().get(i), "success", i, errors);
        }
        for (i = 0; i < hooks.getFailure().size(); ++i) {
            CommandHooksValidator.validateCommandHook(context, hooks.getFailure().get(i), "failure", i, errors);
        }
        if (hooks.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = hooks.getBefore().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getSuccess().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getFailure().stream().anyMatch(AbstractActivatable::isEnabled);
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                hooks.disable();
            }
        }
    }

    private static void validateCommandHook(JReleaserContext context, CommandHook hook, String type, int index, Errors errors) {
        context.getLogger().debug("hooks.command.{}[{}]", new Object[]{type, index});
        Validator.resolveActivatable(context, (Activatable)hook, "hooks.command." + type + "." + index, "ALWAYS");
        if (!hook.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (hook.getMatrix().isEmpty()) {
            hook.setMatrix(context.getModel().getHooks().getCommand().getMatrix());
        }
        if (hook.isApplyDefaultMatrix()) {
            hook.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hook.getMatrix(), "hooks.command." + type + "[" + index + "].matrix", errors);
        if (StringUtils.isBlank((String)hook.getCmd())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"hook.cmd"}));
        }
    }
}

