/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.download;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.ScpDownloader;
import org.jreleaser.model.internal.validation.common.SshValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class ScpDownloaderValidator {
    private ScpDownloaderValidator() {
    }

    public static void validateScpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, ScpDownloader> scp = context.getModel().getDownload().getScp();
        if (!scp.isEmpty()) {
            context.getLogger().debug("download.scp");
        }
        for (Map.Entry<String, ScpDownloader> e : scp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateDownload()) continue;
            ScpDownloaderValidator.validateScpDownloader(context, e.getValue(), errors);
        }
    }

    private static void validateScpDownloader(JReleaserContext context, ScpDownloader downloader, Errors errors) {
        context.getLogger().debug("download.scp.{}", new Object[]{downloader.getName()});
        Validator.resolveActivatable(context, (Activatable)downloader, CollectionUtils.listOf((Object[])new String[]{"download.scp." + downloader.getName(), "download.scp"}), "ALWAYS");
        if (!downloader.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        SshValidator.validateSsh(context, downloader, downloader.getType(), downloader.getName(), "download.", errors);
        Validator.validateTimeout(downloader);
        if (downloader.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"download.scp." + downloader.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : downloader.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"download.scp." + downloader.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

