/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.util.StringUtils;

public interface ExtraProperties
extends Serializable {
    public String prefix();

    public Map<String, Object> getExtraProperties();

    public void setExtraProperties(Map<String, Object> var1);

    public void addExtraProperties(Map<String, Object> var1);

    default public void addExtraProperty(String key, Object value) {
        boolean valueIsNotBlank;
        boolean bl = valueIsNotBlank = value instanceof CharSequence && StringUtils.isNotBlank((String)String.valueOf(value));
        if (valueIsNotBlank || null != value) {
            this.getExtraProperties().put(key, value);
        }
    }

    default public Map<String, Object> resolvedExtraProperties() {
        return this.resolvedExtraProperties(this.prefix());
    }

    default public Map<String, Object> resolvedExtraProperties(String prefix) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        this.getExtraProperties().forEach((key, value) -> {
            if (null == value) {
                return;
            }
            boolean split = key.endsWith("_split");
            String k = key;
            Object v = value;
            if (split) {
                k = key.substring(0, key.length() - "_split".length());
                v = StringUtils.splitValue((String)String.valueOf(value));
            }
            if (key.startsWith(prefix)) {
                props.put(k, v);
            } else {
                props.put(prefix + StringUtils.capitalize((String)k), v);
            }
        });
        return props;
    }

    default public String getExtraProperty(String key) {
        if (this.getExtraProperties().containsKey(key)) {
            return String.valueOf(this.getExtraProperties().get(key));
        }
        return null;
    }

    default public boolean extraPropertyIsTrue(String key) {
        return this.getExtraProperties().containsKey(key) && StringUtils.isTrue((Object)this.getExtraProperties().get(key));
    }
}

