/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.TeamsAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class TeamsAnnouncerValidator {
    private static final String DEFAULT_TEAMS_TPL = "src/jreleaser/templates/teams.tpl";

    private TeamsAnnouncerValidator() {
    }

    public static void validateTeams(JReleaserContext context, TeamsAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.teams");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.teams", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setWebhook(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.teams.webhook", "TEAMS_WEBHOOK"}), "announce.teams.webhook", announcer.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            announcer.setMessageTemplate(DEFAULT_TEAMS_TPL);
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"teams.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

