/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.util.Date;
import java.util.Properties;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.TestDriver;

public abstract class TestWorker
extends Thread {
    protected final Properties config;
    protected int msgSize = 80;
    protected final byte[] commitData;
    protected final byte[][] commitDataRecord = new byte[1][];
    protected int infoSize = 80;
    protected final byte[] infoData;
    protected final byte[][] infoDataRecord = new byte[1][];
    protected final byte[] doneData;
    protected final byte[][] doneDataRecord = new byte[1][];
    protected int count = 50;
    protected int workerID = 0;
    protected int msgForceInterval = 1;
    protected boolean doTimeStamp = false;
    public long latency = 0L;
    protected final TestDriver driver;
    protected final Logger log;
    public long bytesLogged = 0L;
    protected int tnl = 0;
    public Exception exception = null;
    public int transactions = 0;
    protected long delayBeforeDone = 0L;

    void parseProperties() {
        String val = null;
        String key = null;
        key = "msg.size";
        val = this.config.getProperty("msg.size", Integer.toString(this.msgSize)).trim();
        this.msgSize = Integer.parseInt(val);
        if (this.msgSize <= 0) {
            throw new IllegalArgumentException(key + "must be > 0");
        }
        key = "msg.count";
        val = this.config.getProperty("msg.count", Integer.toString(this.count)).trim();
        this.count = Integer.parseInt(val);
        if (this.count <= 0) {
            throw new IllegalArgumentException(key + "must be > 0");
        }
        key = "msg.timestamp";
        val = this.config.getProperty("msg.timestamp", "false").trim().toLowerCase();
        this.doTimeStamp = val.equals("true");
        key = "msg.force.interval";
        val = this.config.getProperty("msg.force.interval", Integer.toString(this.msgForceInterval)).trim();
        this.msgForceInterval = Integer.parseInt(val);
        if (this.msgForceInterval < 0) {
            throw new IllegalArgumentException(key + "must be >= 0");
        }
        key = "info.size";
        val = this.config.getProperty("info.size", Integer.toString(this.infoSize)).trim();
        this.infoSize = Integer.parseInt(val);
        if (this.infoSize <= 0) {
            throw new IllegalArgumentException(key + "must be > 0");
        }
    }

    byte[] initCommitData() {
        byte[] commitData = new byte[this.msgSize];
        int msgSize = commitData.length;
        for (int i = 0; i < msgSize; ++i) {
            commitData[i] = (byte)(32 + i % 94);
        }
        commitData[msgSize - 2] = 13;
        commitData[msgSize - 1] = 10;
        String threadName = "[xxxx.xxxx]COMMIT:" + Thread.currentThread().getName() + " ";
        this.tnl = threadName.length();
        if (this.tnl < commitData.length) {
            System.arraycopy(threadName.getBytes(), 0, commitData, 0, this.tnl);
        }
        return commitData;
    }

    protected void updateRecordData(int id) {
        byte[] now;
        int j;
        if (id == 1) {
            int val = this.workerID;
            for (j = 4; j > 0; --j) {
                this.commitData[j] = (byte)(48 + val % 10);
                val /= 10;
            }
            val = id;
        }
        int msg = id;
        for (j = 9; j > 5; --j) {
            this.commitData[j] = (byte)(48 + msg % 10);
            msg /= 10;
        }
        if (this.doTimeStamp && (now = new Date().toString().getBytes()).length < this.commitData.length - this.tnl) {
            System.arraycopy(now, 0, this.commitData, this.tnl, now.length);
        }
        System.arraycopy(this.commitData, 1, this.doneData, 1, 9);
        System.arraycopy(this.commitData, 1, this.infoData, 1, 9);
    }

    byte[] initInfoData() {
        byte[] infoData = ("[xxxx.xxxx]INFO :" + Thread.currentThread().getName() + "\n").getBytes();
        return infoData;
    }

    byte[] initDoneData() {
        byte[] doneData = ("[xxxx.xxxx]DONE  :" + Thread.currentThread().getName() + "\n").getBytes();
        return doneData;
    }

    protected TestWorker(TestDriver driver) {
        this.driver = driver;
        this.config = driver.getProperties();
        this.log = driver.getLogger();
        this.parseProperties();
        this.commitData = this.initCommitData();
        this.commitDataRecord[0] = this.commitData;
        this.infoData = this.initInfoData();
        this.infoDataRecord[0] = this.infoData;
        this.doneData = this.initDoneData();
        this.doneDataRecord[0] = this.doneData;
    }

    public void setWorkerIndex(int workerID) {
        this.workerID = workerID;
    }

    public void setDelayBeforeDone(long delayBeforeDone) {
        this.delayBeforeDone = delayBeforeDone;
    }
}

