/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.bootstrap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.carol.util.bootstrap.JVMConfiguration;
import org.objectweb.carol.util.bootstrap.ProcessException;
import org.objectweb.carol.util.bootstrap.RemoteProcessesManager;

public class ProcessesManager
implements RemoteProcessesManager {
    private static boolean verbose = false;
    public static boolean CLEAN_PROCESSES = true;
    public static final int START_WAIT_TIME = 1000;
    public static String JAVA_CMD = "java ";
    public static Hashtable processes = new Hashtable();
    public static Hashtable commands = new Hashtable();
    public static Hashtable directories = new Hashtable();
    private static int idIcrement = 0;

    public ProcessesManager() throws RemoteException {
    }

    public ProcessesManager(boolean cleanb, boolean vb) throws RemoteException {
        CLEAN_PROCESSES = cleanb;
        verbose = vb;
    }

    private synchronized String getNewID() {
        return "p_" + ++idIcrement;
    }

    private void cleanProcess(String id) {
        File dirName = (File)directories.get(id);
        processes.remove(id);
        commands.remove(id);
        directories.remove(id);
        this.recursiveRemoveDir(dirName);
    }

    private void recursiveRemoveDir(File dir) {
        if (dir != null) {
            if (verbose) {
                System.out.println("Delete dir: " + dir);
            }
            if (System.getProperty("user.dir").trim().equals(dir.getParent().trim())) {
                String[] filelist = dir.list();
                File tmpFile = null;
                int i = 0;
                while (i < filelist.length) {
                    if (verbose) {
                        System.out.println("Delete Sub directory or file : " + filelist[i]);
                    }
                    if ((tmpFile = new File(dir.getAbsolutePath(), filelist[i])).isDirectory()) {
                        this.recursiveRemoveDir(tmpFile);
                    } else if (tmpFile.isFile()) {
                        tmpFile.delete();
                    }
                    ++i;
                }
                dir.delete();
            }
        }
    }

    private File createDir(String dir) throws ProcessException {
        File pDirFile = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + dir);
        if (pDirFile.exists()) {
            if (!pDirFile.isDirectory()) {
                throw new ProcessException(pDirFile + " file is not a directory");
            }
            if (!pDirFile.canRead()) {
                throw new ProcessException("Un-readable directory :" + pDirFile);
            }
            if (!pDirFile.canWrite()) {
                throw new ProcessException("Un-writable directory :" + pDirFile);
            }
        } else if (!pDirFile.mkdir()) {
            throw new ProcessException("Can not mkdir directory :" + pDirFile);
        }
        return pDirFile;
    }

    protected String getProcessOutput(Process p) {
        try {
            InputStream pOutputStream = p.getInputStream();
            byte[] b = new byte[pOutputStream.available()];
            pOutputStream.read(b);
            pOutputStream.close();
            return new String(b);
        }
        catch (Exception pe) {
            return null;
        }
    }

    protected String getProcessError(Process p) {
        try {
            InputStream pErrorStream = p.getErrorStream();
            byte[] b = new byte[pErrorStream.available()];
            pErrorStream.read(b);
            pErrorStream.close();
            return new String(b);
        }
        catch (Exception pe) {
            return null;
        }
    }

    public String startJVM(JVMConfiguration jvmConf, String[] envp) throws ProcessException, RemoteException {
        return this.startProcess(JAVA_CMD + jvmConf.getCommandString(), envp);
    }

    public String startJVM(JVMConfiguration jvmConf, String[] envp, String processDir) throws ProcessException, RemoteException {
        return this.startProcess(JAVA_CMD + jvmConf.getCommandString(), envp, processDir);
    }

    public void startJVM(JVMConfiguration jvmConf, String[] envp, String processDir, String id) throws ProcessException, RemoteException {
        this.startProcess(JAVA_CMD + jvmConf.getCommandString(), envp, processDir, id);
    }

    public String startProcess(String processLine, String[] envp) throws ProcessException, RemoteException {
        String newid = this.getNewID();
        String processDir = "tmp_" + newid;
        this.startProcess(processLine, envp, processDir, newid);
        return newid;
    }

    public String startProcess(String processLine, String[] envp, String processDir) throws ProcessException, RemoteException {
        String newid = this.getNewID();
        this.startProcess(processLine, envp, processDir, newid);
        return newid;
    }

    public void startProcess(String processLine, String[] envp, String processDir, String id) throws ProcessException, RemoteException {
        Process p = null;
        if (verbose) {
            System.out.println("Start a new Process with id: " + id);
            System.out.println("and with : " + processLine);
            System.out.println("in : " + processDir);
        }
        File pDir = this.createDir(processDir);
        if (commands.get(id) != null || processes.get(id) != null || directories.get(id) != null) {
            throw new ProcessException("Process Name already exist");
        }
        try {
            p = Runtime.getRuntime().exec(processLine, envp, pDir);
            Thread.sleep(1000L);
            int ev = p.exitValue();
            String processErr = "\nProcess error  :\n" + this.getProcessOutput(p);
            String processOut = "\nProcess output  :\n" + this.getProcessError(p);
            this.cleanProcess(id);
            throw new ProcessException("The Process just stop after starting, exit value= " + ev + processErr + processOut);
        }
        catch (IllegalThreadStateException ite) {
            processes.put(id, p);
            commands.put(id, processLine);
            directories.put(id, pDir);
            if (CLEAN_PROCESSES) {
                ProcessStopThread s = new ProcessStopThread(p, id);
                s.start();
            }
        }
        catch (IOException ioe) {
            throw new ProcessException("The Process is not started" + ioe.getMessage());
        }
        catch (InterruptedException ite) {
            throw new ProcessException("The Process is not started" + ite.getMessage());
        }
    }

    public synchronized void killProcess(String id) throws ProcessException, RemoteException {
        if (verbose) {
            System.out.println("Kill a Process with id: " + id);
        }
        if (!processes.containsKey(id)) {
            this.cleanProcess(id);
            throw new ProcessException("Process with id: id doesn't exist");
        }
        ((Process)processes.get(id)).destroy();
        this.cleanProcess(id);
    }

    public synchronized void killAllProcesses() throws RemoteException {
        if (verbose) {
            System.out.println("Kill all Process");
        }
        Enumeration e = processes.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            ((Process)processes.get(s)).destroy();
            this.cleanProcess(s);
        }
        commands.clear();
        directories.clear();
        processes.clear();
    }

    public synchronized boolean pingProcess(String id) throws ProcessException, RemoteException {
        if (verbose) {
            System.out.println("ping Process");
        }
        if (processes.containsKey(id)) {
            try {
                ((Process)processes.get(id)).exitValue();
                return false;
            }
            catch (IllegalThreadStateException ite) {
                return true;
            }
        }
        return false;
    }

    public int getProcessExitValue(String id) throws ProcessException, RemoteException {
        if (verbose) {
            System.out.println("search exit value of Process with id: " + id);
        }
        if (processes.containsKey(id)) {
            try {
                int ev_value = ((Process)processes.get(id)).exitValue();
                return ev_value;
            }
            catch (IllegalThreadStateException ite) {
                throw new ProcessException("Process with id: " + id + " is not yet stopped");
            }
        }
        throw new ProcessException("Process with id: " + id + "doens'nt exist");
    }

    public String getProcessCommand(String id) throws ProcessException, RemoteException {
        if (verbose) {
            System.out.println("get Process id " + id + " commande line");
        }
        if (processes.containsKey(id)) {
            try {
                int ev_value = ((Process)processes.get(id)).exitValue();
                throw new ProcessException("Process with id: " + id + " is stop with exit value: " + ev_value);
            }
            catch (IllegalThreadStateException ite) {
                return (String)commands.get(id);
            }
        }
        throw new ProcessException("Process with id: " + id + "doens'nt exist");
    }

    public String getProcessDirectory(String id) throws ProcessException, RemoteException {
        if (verbose) {
            System.out.println("get Process id " + id + " directory");
        }
        if (processes.containsKey(id)) {
            try {
                int ev_value = ((Process)processes.get(id)).exitValue();
                throw new ProcessException("Process with id: " + id + " is stop with exit value: " + ev_value);
            }
            catch (IllegalThreadStateException ite) {
                return (String)directories.get(id);
            }
        }
        throw new ProcessException("Process with id: " + id + "doens'nt exist");
    }

    public Hashtable getAllProcess() throws RemoteException {
        if (verbose) {
            System.out.println("get all Process");
        }
        return commands;
    }

    public String readProcessOutput(String id) throws ProcessException, RemoteException {
        try {
            Process p = (Process)processes.get(id);
            if (p != null) {
                InputStream pOutputStream = p.getInputStream();
                byte[] b = new byte[pOutputStream.available()];
                pOutputStream.read(b);
                return new String(b);
            }
            throw new ProcessException("Process with id: " + id + "doens'nt exist");
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
    }

    public String readProcessError(String id) throws ProcessException, RemoteException {
        try {
            Process p = (Process)processes.get(id);
            if (p != null) {
                InputStream pErrorStream = p.getErrorStream();
                byte[] b = new byte[pErrorStream.available()];
                pErrorStream.read(b);
                return new String(b);
            }
            throw new ProcessException("Process with id: " + id + "doens'nt exist");
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
    }

    public void writeProcessInput(String id, String s) throws ProcessException, RemoteException {
        try {
            Process p = (Process)processes.get(id);
            if (p == null) {
                throw new ProcessException("Process with id: " + id + "doens'nt exist");
            }
            OutputStream pInStream = p.getOutputStream();
            pInStream.write(s.getBytes());
            pInStream.flush();
        }
        catch (Exception e) {
            throw new ProcessException(e);
        }
    }

    public void sendFile(String dirName, String fileName, byte[] b) throws RemoteException {
        try {
            this.createDir(dirName);
            File dirC = this.createDir(dirName);
            if (dirC != null) {
                FileOutputStream fou = new FileOutputStream(new File(dirC + System.getProperty("file.separator") + fileName));
                fou.write(b);
                fou.flush();
                fou.close();
            }
        }
        catch (Exception e) {
            throw new RemoteException("" + e);
        }
    }

    public void stop() throws RemoteException {
        this.killAllProcesses();
        System.exit(0);
    }

    public class ProcessStopThread
    extends Thread {
        Process process;
        String processID;

        ProcessStopThread(Process p, String id) {
            this.process = p;
            this.processID = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.process.waitFor();
                if (verbose) {
                    System.out.println("Stopping process " + this.processID);
                    System.out.println("Error:");
                    System.out.println(ProcessesManager.this.getProcessError(this.process));
                    System.out.println("Output:");
                    System.out.println(ProcessesManager.this.getProcessOutput(this.process));
                }
                ProcessStopThread processStopThread = this;
                synchronized (processStopThread) {
                    ProcessesManager.this.cleanProcess(this.processID);
                }
            }
            catch (Exception ie) {
                System.out.println("error in run " + ie);
            }
        }
    }
}

