/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.resolvers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarFile;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;

public class ClasspathBasedJarFileResolver
implements JarFileResolver {
    private final String classpath;
    private Set<JarFile> jarFiles;

    public ClasspathBasedJarFileResolver(String classpath) {
        this.classpath = classpath;
    }

    @Override
    public Set<JarFile> resolveJarFiles() {
        if (null != this.jarFiles) {
            return this.jarFiles;
        }
        LinkedHashSet<JarFile> set = new LinkedHashSet<JarFile>();
        for (String s : this.classpath.split(File.pathSeparator)) {
            Path file = Path.of(s, new String[0]);
            if (Files.notExists(file, new LinkOption[0])) continue;
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw new JarvizException(RB.$("ERROR_PATH_IS_NOT_A_FILE", file.toAbsolutePath()));
            }
            if (!Files.isReadable(file)) {
                throw new JarvizException(RB.$("ERROR_PATH_IS_NOT_READABLE", file.toAbsolutePath()));
            }
            if (!file.getFileName().toString().endsWith(".jar")) {
                throw new JarvizException(RB.$("ERROR_PATH_IS_NOT_JAR", file.toAbsolutePath()));
            }
            try {
                set.add(new JarFile(file.toFile()));
            }
            catch (IOException e) {
                throw new JarvizException(RB.$("ERROR_OPENING_JAR", file.toAbsolutePath()));
            }
        }
        this.jarFiles = set;
        return this.jarFiles;
    }
}

