/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;

public class ServicesListJarProcessor
implements JarProcessor<Optional<Set<String>>> {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private final JarFileResolver jarFileResolver;
    private Integer release;

    public ServicesListJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
    }

    public Integer getRelease() {
        return this.release;
    }

    public void setRelease(Integer release) {
        this.release = release;
    }

    @Override
    public Set<JarProcessor.JarFileResult<Optional<Set<String>>>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<Optional<Set<String>>>> set = new TreeSet<JarProcessor.JarFileResult<Optional<Set<String>>>>();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarFile(jarFile));
        }
        return set;
    }

    private JarProcessor.JarFileResult<Optional<Set<String>>> processJarFile(JarFile jarFile) {
        JarProcessor.JarFileResult<Optional<Set<String>>> jarFileResult;
        block9: {
            TreeSet<String> services = new TreeSet<String>();
            boolean foundServices = false;
            JarFile jarFile2 = jarFile;
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(META_INF_SERVICES) || name.length() <= META_INF_SERVICES.length()) continue;
                    foundServices = true;
                    services.add(name.substring(META_INF_SERVICES.length()));
                }
                jarFileResult = JarProcessor.JarFileResult.of(jarFile, foundServices ? Optional.of(Collections.unmodifiableSet(services)) : Optional.empty());
                if (jarFile2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile2 != null) {
                        try {
                            jarFile2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return JarProcessor.JarFileResult.of(jarFile, foundServices ? Optional.of(Collections.unmodifiableSet(services)) : Optional.empty());
                }
            }
            jarFile2.close();
        }
        return jarFileResult;
    }
}

