/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import org.kordamp.jarviz.core.JarvizException;

public interface JarProcessor<R> {
    public Set<JarFileResult<R>> getResult() throws JarvizException;

    public static class JarFileResult<R>
    implements Comparable<JarFileResult<R>> {
        private final JarFile jarFile;
        private final R result;

        public static <R> JarFileResult<R> of(JarFile jarFile, R result) {
            return new JarFileResult<R>(jarFile, result);
        }

        private JarFileResult(JarFile jarFile, R result) {
            this.jarFile = jarFile;
            this.result = result;
        }

        public JarFile getJarFile() {
            return this.jarFile;
        }

        public R getResult() {
            return this.result;
        }

        public Path getJarPath() {
            return Path.of(this.jarFile.getName(), new String[0]);
        }

        public String getJarFileName() {
            return Path.of(this.jarFile.getName(), new String[0]).getFileName().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JarFileResult result = (JarFileResult)o;
            return this.getJarFileName().equals(result.getJarFileName());
        }

        public int hashCode() {
            return Objects.hash(this.getJarFileName());
        }

        @Override
        public int compareTo(JarFileResult<R> o) {
            if (null == o) {
                return -1;
            }
            return this.getJarFileName().compareTo(o.getJarFileName());
        }
    }
}

