/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.component;

import org.gradle.api.component.SoftwareComponentVariant;

public interface MavenPublishingAwareVariant
extends SoftwareComponentVariant {
    public ScopeMapping getScopeMapping();

    public static ScopeMapping scopeForVariant(SoftwareComponentVariant variant) {
        if (variant instanceof MavenPublishingAwareVariant) {
            return ((MavenPublishingAwareVariant)variant).getScopeMapping();
        }
        String name = variant.getName();
        if ("api".equals(name) || "apiElements".equals(name)) {
            return ScopeMapping.compile;
        }
        return ScopeMapping.runtime;
    }

    public static enum ScopeMapping {
        compile("compile", false),
        runtime("runtime", false),
        compile_optional("compile", true),
        runtime_optional("runtime", true);

        private final String scope;
        private final boolean optional;

        private ScopeMapping(String scope, boolean optional) {
            this.scope = scope;
            this.optional = optional;
        }

        public String getScope() {
            return this.scope;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public static ScopeMapping of(String scope, boolean optional) {
            if (optional) {
                scope = scope + "_optional";
            }
            return ScopeMapping.valueOf(scope);
        }
    }
}

