/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\bJ\u001c\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\bJ\u001e\u0010\u000e\u001a\u00020\u000f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\bJ&\u0010\u0010\u001a\u00020\u00112\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000e\u001a\u00020\u000fj\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/CfgTraverseDirection;", "", "<init>", "(Ljava/lang/String;I)V", "Forward", "Backward", "nodes", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "next", "node", "previous", "edge", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "isUsedInCfg", "", "checkers"})
public final class CfgTraverseDirection
extends Enum<CfgTraverseDirection> {
    public static final /* enum */ CfgTraverseDirection Forward = new CfgTraverseDirection();
    public static final /* enum */ CfgTraverseDirection Backward = new CfgTraverseDirection();
    private static final /* synthetic */ CfgTraverseDirection[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    @NotNull
    public final List<CFGNode<?>> nodes(@NotNull ControlFlowGraph graph2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                list = graph2.getNodes();
                break;
            }
            case 2: {
                list = CollectionsKt.asReversed(graph2.getNodes());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @NotNull
    public final List<CFGNode<?>> next(@NotNull CFGNode<?> node) {
        List<CFGNode<?>> list;
        Intrinsics.checkNotNullParameter(node, (String)"node");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                list = node.getFollowingNodes();
                break;
            }
            case 2: {
                list = node.getPreviousNodes();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @NotNull
    public final List<CFGNode<?>> previous(@NotNull CFGNode<?> node) {
        List<CFGNode<?>> list;
        Intrinsics.checkNotNullParameter(node, (String)"node");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                list = node.getPreviousNodes();
                break;
            }
            case 2: {
                list = node.getFollowingNodes();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @NotNull
    public final Edge edge(@NotNull CFGNode<?> previous, @NotNull CFGNode<?> next) {
        Edge edge;
        Intrinsics.checkNotNullParameter(previous, (String)"previous");
        Intrinsics.checkNotNullParameter(next, (String)"next");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                edge = next.edgeFrom(previous);
                break;
            }
            case 2: {
                edge = previous.edgeFrom(next);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return edge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUsedInCfg(@NotNull CFGNode<?> previous, @NotNull CFGNode<?> next, @NotNull Edge edge) {
        boolean bl;
        Intrinsics.checkNotNullParameter(previous, (String)"previous");
        Intrinsics.checkNotNullParameter(next, (String)"next");
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        EdgeKind kind = edge.getKind();
        if (!kind.getUsedInCfa()) return false;
        if (!kind.isDead()) return true;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                bl = next.isDead();
                break;
            }
            case 2: {
                bl = previous.isDead();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    public static CfgTraverseDirection[] values() {
        return (CfgTraverseDirection[])$VALUES.clone();
    }

    public static CfgTraverseDirection valueOf(String value2) {
        return Enum.valueOf(CfgTraverseDirection.class, value2);
    }

    @NotNull
    public static EnumEntries<CfgTraverseDirection> getEntries() {
        return $ENTRIES;
    }

    static {
        $VALUES = cfgTraverseDirectionArray = new CfgTraverseDirection[]{CfgTraverseDirection.Forward, CfgTraverseDirection.Backward};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CfgTraverseDirection.values().length];
            try {
                nArray[CfgTraverseDirection.Forward.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CfgTraverseDirection.Backward.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

