/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.antlr.AntlrTask;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;

public class AntlrSpecFactory {
    public AntlrSpec create(AntlrTask antlrTask, Set<File> grammarFiles, FileCollection sourceSetDirectories) {
        LinkedList arguments = Lists.newLinkedList(antlrTask.getArguments());
        if (antlrTask.isTrace() && !arguments.contains("-trace")) {
            arguments.add("-trace");
        }
        if (antlrTask.isTraceLexer() && !arguments.contains("-traceLexer")) {
            arguments.add("-traceLexer");
        }
        if (antlrTask.isTraceParser() && !arguments.contains("-traceParser")) {
            arguments.add("-traceParser");
        }
        if (antlrTask.isTraceTreeWalker() && !arguments.contains("-traceTreeWalker")) {
            arguments.add("-traceTreeWalker");
        }
        Set sourceSetDirectoriesFiles = sourceSetDirectories == null ? Collections.emptySet() : sourceSetDirectories.getFiles();
        return new AntlrSpec(arguments, grammarFiles, sourceSetDirectoriesFiles, antlrTask.getOutputDirectory(), antlrTask.getMaxHeapSize());
    }
}

