/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.ContextAwareException;
import org.gradle.internal.exceptions.ExceptionContextVisitor;
import org.gradle.internal.exceptions.FailureResolutionAware;

public class LocationAwareException
extends ContextAwareException
implements FailureResolutionAware {
    private final String sourceDisplayName;
    private final Integer lineNumber;

    public LocationAwareException(Throwable cause, ScriptSource source, Integer lineNumber) {
        this(cause, source != null ? source.getDisplayName() : null, lineNumber);
    }

    public LocationAwareException(Throwable cause, @Nullable String sourceDisplayName, @Nullable Integer lineNumber) {
        super(cause);
        this.sourceDisplayName = sourceDisplayName;
        this.lineNumber = lineNumber;
    }

    @Nullable
    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    @Nullable
    public String getLocation() {
        if (this.sourceDisplayName == null) {
            return null;
        }
        String sourceMsg = StringUtils.capitalize((String)this.sourceDisplayName);
        if (this.lineNumber == null) {
            return sourceMsg;
        }
        return String.format("%s line: %d", sourceMsg, this.lineNumber);
    }

    @Nullable
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Nullable
    public String getMessage() {
        String location = this.getLocation();
        String message = this.getCause().getMessage();
        if (location == null && message == null) {
            return null;
        }
        if (location == null) {
            return message;
        }
        if (message == null) {
            return location;
        }
        return String.format("%s%n%s", location, message);
    }

    @Override
    public void appendResolutions(FailureResolutionAware.Context context) {
        if (this.getCause() instanceof FailureResolutionAware) {
            FailureResolutionAware resolutionAware = (FailureResolutionAware)((Object)this.getCause());
            resolutionAware.appendResolutions(context);
        }
    }

    @Override
    public void accept(ExceptionContextVisitor contextVisitor) {
        super.accept(contextVisitor);
        String location = this.getLocation();
        if (location != null) {
            contextVisitor.visitLocation(location);
        }
    }
}

