/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.immutable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryInterner;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class ImmutableAttributesSchemaFactory {
    private final InMemoryInterner<ImmutableAttributesSchema> schemas;
    private final InMemoryLoadingCache<SchemaPair, ImmutableAttributesSchema> mergedSchemas;

    public ImmutableAttributesSchemaFactory(InMemoryCacheFactory cacheFactory) {
        this.schemas = cacheFactory.createInterner();
        this.schemas.intern((Object)ImmutableAttributesSchema.EMPTY);
        this.mergedSchemas = cacheFactory.create(this::doConcatSchemas);
    }

    public ImmutableAttributesSchema create(ImmutableMap<Attribute<?>, ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<?>> strategies, ImmutableList<Attribute<?>> precedence) {
        return (ImmutableAttributesSchema)this.schemas.intern((Object)new ImmutableAttributesSchema(strategies, precedence));
    }

    public ImmutableAttributesSchema create(AttributesSchemaInternal mutable) {
        return this.create(ImmutableAttributesSchemaFactory.convertStrategies(mutable), ImmutableList.copyOf(mutable.getAttributePrecedence()));
    }

    private static ImmutableMap<Attribute<?>, ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<?>> convertStrategies(AttributesSchemaInternal mutable) {
        ImmutableMap.Builder strategies = ImmutableMap.builder();
        for (Map.Entry<Attribute<?>, DefaultAttributeMatchingStrategy<?>> entry : mutable.getStrategies().entrySet()) {
            strategies.put(entry.getKey(), ImmutableAttributesSchemaFactory.convertStrategy(entry.getValue()));
        }
        return strategies.build();
    }

    private static <T> ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<T> convertStrategy(DefaultAttributeMatchingStrategy<T> mutableStrategy) {
        return new ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy(ImmutableList.copyOf(mutableStrategy.getCompatibilityRules().getRules()), ImmutableList.copyOf(mutableStrategy.getDisambiguationRules().getRules()));
    }

    public ImmutableAttributesSchema concat(ImmutableAttributesSchema consumer, ImmutableAttributesSchema producer) {
        return (ImmutableAttributesSchema)this.mergedSchemas.get((Object)new SchemaPair(consumer, producer));
    }

    private ImmutableAttributesSchema doConcatSchemas(SchemaPair pair) {
        return this.create(ImmutableAttributesSchemaFactory.mergeStrategies(pair.consumer, pair.producer), ImmutableAttributesSchemaFactory.mergePrecedence(((SchemaPair)pair).consumer.precedence, ((SchemaPair)pair).producer.precedence));
    }

    private static ImmutableMap<Attribute<?>, ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<?>> mergeStrategies(ImmutableAttributesSchema consumer, ImmutableAttributesSchema producer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Attribute attribute : Sets.union((Set)producer.strategies.keySet(), (Set)consumer.strategies.keySet())) {
            builder.put((Object)attribute, ImmutableAttributesSchemaFactory.mergeStrategyFor(attribute, consumer, producer));
        }
        return builder.build();
    }

    private static <T> ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<T> mergeStrategyFor(Attribute<T> attribute, ImmutableAttributesSchema consumer, ImmutableAttributesSchema producer) {
        ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<T> consumerStrategy = consumer.getStrategy(attribute);
        ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<T> producerStrategy = producer.getStrategy(attribute);
        assert (consumerStrategy != null || producerStrategy != null);
        if (consumerStrategy == null) {
            return producerStrategy;
        }
        if (producerStrategy == null) {
            return consumerStrategy;
        }
        return ImmutableAttributesSchemaFactory.doMergeStrategies(consumerStrategy, producerStrategy);
    }

    public static <T> ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<T> doMergeStrategies(ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<T> consumer, ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy<T> producer) {
        return new ImmutableAttributesSchema.ImmutableAttributeMatchingStrategy(ImmutableList.builder().addAll(consumer.compatibilityRules.rules).addAll(producer.compatibilityRules.rules).build(), ImmutableList.builder().addAll(consumer.disambiguationRules.rules).addAll(producer.disambiguationRules.rules).build());
    }

    private static <T> ImmutableList<T> mergePrecedence(ImmutableList<T> consumer, ImmutableList<T> producer) {
        return ImmutableSet.builder().addAll(consumer).addAll(producer).build().asList();
    }

    private static class SchemaPair {
        private final ImmutableAttributesSchema consumer;
        private final ImmutableAttributesSchema producer;
        private final int hashCode;

        SchemaPair(ImmutableAttributesSchema consumer, ImmutableAttributesSchema producer) {
            this.consumer = consumer;
            this.producer = producer;
            this.hashCode = SchemaPair.computeHashCode(consumer, producer);
        }

        private static int computeHashCode(ImmutableAttributesSchema consumer, ImmutableAttributesSchema producer) {
            int result = consumer.hashCode();
            result = 31 * result + producer.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SchemaPair other = (SchemaPair)obj;
            return this.consumer == other.consumer && this.producer == other.producer;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

