/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.NativePlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;

public abstract class ExtendableToolChain<T extends NativePlatformToolChain>
implements NativeToolChainInternal {
    private final String name;
    protected final OperatingSystem operatingSystem;
    private final PathToFileResolver fileResolver;
    protected final MutableActionSet<T> configureActions = new MutableActionSet();
    protected final BuildOperationExecutor buildOperationExecutor;

    protected ExtendableToolChain(String name, BuildOperationExecutor buildOperationExecutor, OperatingSystem operatingSystem, PathToFileResolver fileResolver) {
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.fileResolver = fileResolver;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public String getName() {
        return this.name;
    }

    protected abstract String getTypeName();

    public String getDisplayName() {
        return "Tool chain '" + this.getName() + "' (" + this.getTypeName() + ")";
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getOutputType() {
        return this.getName() + "-" + this.operatingSystem.getName();
    }

    public void eachPlatform(Action<? super T> action) {
        this.configureActions.add(action);
    }

    protected File resolve(Object path) {
        return this.fileResolver.resolve(path);
    }

    @Override
    public void assertSupported() {
    }
}

