/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import org.apache.catalina.util.RequestUtil;

public class SecurityCollection
implements Serializable {
    private String description = null;
    private String[] methods = new String[0];
    private String[] methodOmissions = new String[0];
    private String name = null;
    private String[] patterns = new String[0];

    public SecurityCollection() {
        this(null, null);
    }

    public SecurityCollection(String name) {
        this(name, null);
    }

    public SecurityCollection(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addMethod(String method) {
        if (method == null) {
            return;
        }
        String[] results = new String[this.methods.length + 1];
        for (int i = 0; i < this.methods.length; ++i) {
            results[i] = this.methods[i];
        }
        results[this.methods.length] = method;
        this.methods = results;
    }

    public void addMethodOmission(String methodOmission) {
        if (methodOmission == null) {
            return;
        }
        String[] results = new String[this.methodOmissions.length + 1];
        for (int i = 0; i < this.methodOmissions.length; ++i) {
            results[i] = this.methodOmissions[i];
        }
        results[this.methodOmissions.length] = methodOmission;
        this.methodOmissions = results;
    }

    public void addPattern(String pattern) {
        if (pattern == null) {
            return;
        }
        pattern = RequestUtil.URLDecode(pattern);
        String[] results = new String[this.patterns.length + 1];
        for (int i = 0; i < this.patterns.length; ++i) {
            results[i] = this.patterns[i];
        }
        results[this.patterns.length] = pattern;
        this.patterns = results;
    }

    public boolean findMethod(String method) {
        if (this.methods.length == 0) {
            return true;
        }
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].equals(method)) continue;
            return true;
        }
        return false;
    }

    public String[] findMethods() {
        return this.methods;
    }

    public boolean findMethodOmission(String methodOmission) {
        if (this.methodOmissions.length == 0) {
            return false;
        }
        for (int i = 0; i < this.methodOmissions.length; ++i) {
            if (!this.methodOmissions[i].equals(methodOmission)) continue;
            return true;
        }
        return false;
    }

    public String[] findMethodOmissions() {
        return this.methodOmissions;
    }

    public boolean findPattern(String pattern) {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public String[] findPatterns() {
        return this.patterns;
    }

    public void removeMethod(String method) {
        if (method == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].equals(method)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.methods.length - 1];
            for (int i = 0; i < this.methods.length; ++i) {
                if (i == n) continue;
                results[j++] = this.methods[i];
            }
            this.methods = results;
        }
    }

    public void removeMethodOmission(String methodOmission) {
        if (methodOmission == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.methodOmissions.length; ++i) {
            if (!this.methodOmissions[i].equals(methodOmission)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.methodOmissions.length - 1];
            for (int i = 0; i < this.methodOmissions.length; ++i) {
                if (i == n) continue;
                results[j++] = this.methodOmissions[i];
            }
            this.methodOmissions = results;
        }
    }

    public void removePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].equals(pattern)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            int j = 0;
            String[] results = new String[this.patterns.length - 1];
            for (int i = 0; i < this.patterns.length; ++i) {
                if (i == n) continue;
                results[j++] = this.patterns[i];
            }
            this.patterns = results;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SecurityCollection[");
        sb.append(this.name);
        if (this.description != null) {
            sb.append(", ");
            sb.append(this.description);
        }
        sb.append("]");
        return sb.toString();
    }
}

