/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.intf.config.VirtualServer;
import org.glassfish.admin.amx.intf.config.grizzly.Http;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admin.amx.intf.config.grizzly.Protocol;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebHandlers {
    public static void getAllHttpPorts(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        AMXProxy listeners = V3AMX.getInstance().getConfig(configName).getNetworkConfig().child("network-listeners");
        Map networkListeners = listeners.childrenMap("network-listener");
        StringBuffer sb = new StringBuffer();
        for (AMXProxy oneListener : networkListeners.values()) {
            sb.append(oneListener.attributesMap().get("Port"));
            sb.append(" ,");
        }
        String ports = sb.length() == 0 ? "" : sb.substring(0, sb.length() - 2);
        handlerCtx.setOutputValue("ports", (Object)ports);
    }

    public static void createNetworkListener(HandlerContext handlerCtx) {
        AMXConfigProxy amx;
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        String protocolChoice = (String)attrMap.get("protocolChoice");
        String protocolName = "";
        String securityEnabled = attrMap.get("SecurityEnabled") == null ? "false" : "true";
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        if ("create".equals(protocolChoice)) {
            HashMap httpAttrs = new HashMap();
            httpAttrs.put("DefaultVirtualServer", attrMap.get("DefaultVirtualServer"));
            aMap.put(Util.deduceType(Http.class), httpAttrs);
            aMap.put("Name", attrMap.get("newProtocolName"));
            aMap.put("SecurityEnabled", securityEnabled);
            amx = (AMXConfigProxy)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().child("protocols");
            AMXConfigProxy pp = amx.createChild("protocol", aMap);
            protocolName = pp.getName();
        } else {
            protocolName = (String)attrMap.get("existingProtocolName");
            AMXProxy amx2 = (AMXProxy)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().child("protocols").childrenMap("protocol").get(protocolName);
            V3AMX.setAttribute((ObjectName)amx2.objectName(), (Attribute)new Attribute("SecurityEnabled", securityEnabled));
        }
        HashMap<String, String> nMap = new HashMap<String, String>();
        WebHandlers.putA(nMap, attrMap, "Name");
        WebHandlers.putA(nMap, attrMap, "Address");
        WebHandlers.putA(nMap, attrMap, "Port");
        WebHandlers.putA(nMap, attrMap, "Transport");
        WebHandlers.putA(nMap, attrMap, "ThreadPool");
        WebHandlers.putA(nMap, attrMap, "Enabled", "false");
        WebHandlers.putA(nMap, attrMap, "JkEnabled", "false");
        nMap.put("Protocol", protocolName);
        amx = (AMXConfigProxy)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().child("network-listeners");
        amx.createChild("network-listener", nMap);
        Protocol protocol = (Protocol)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().getProtocols().getProtocol().get(protocolName);
        if (protocol.getHttp() != null) {
            String vsName = protocol.getHttp().getDefaultVirtualServer();
            WebHandlers.changeNetworkListenersInVS(vsName, (String)nMap.get("Name"), true);
        }
    }

    private static void changeNetworkListenersInVS(String vsName, String listenerName, boolean addFlag) {
        if (GuiUtil.isEmpty((String)vsName) || GuiUtil.isEmpty((String)listenerName)) {
            return;
        }
        VirtualServer vsProxy = (VirtualServer)V3AMX.getInstance().getConfig("server-config").getHttpService().getVirtualServer().get(vsName);
        List listeners = GuiUtil.parseStringList((String)vsProxy.getNetworkListeners(), (String)",");
        if (addFlag) {
            if (!listeners.contains(listenerName)) {
                listeners.add(listenerName);
            }
        } else if (listeners.contains(listenerName)) {
            listeners.remove(listenerName);
        }
        String ll = GuiUtil.listToString((List)listeners, (String)",");
        vsProxy.setNetworkListeners(ll);
    }

    public static void findHttpProtocol(HandlerContext handlerCtx) {
        String listenerName = (String)handlerCtx.getInputValue("listenerName");
        Map nls = ((NetworkConfig)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener();
        NetworkListener listener = (NetworkListener)nls.get(listenerName);
        String http = listener.findHttpProtocol().getName();
        handlerCtx.setOutputValue("httpProtocolName", (Object)http);
        handlerCtx.setOutputValue("sameAsProtocol", (Object)http.equals(listener.findProtocol().getName()));
    }

    public static void addNetworkListenerInfo(HandlerContext handlerCtx) {
        List listOfMap = (List)handlerCtx.getInputValue("protocolListOfRows");
        for (Map oneRow : listOfMap) {
            String pName = (String)oneRow.get("Name");
            Protocol protocol = (Protocol)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().getProtocols().getProtocol().get(pName);
            List<NetworkListener> listenerList = WebHandlers.findNetworkListeners(protocol);
            ArrayList<String> nameList = new ArrayList<String>();
            for (NetworkListener one : listenerList) {
                nameList.add(one.getName());
            }
            oneRow.put("listenerList", nameList);
        }
        handlerCtx.setOutputValue("result", (Object)listOfMap);
    }

    public static void deleteNetworkListeners(HandlerContext handlerCtx) {
        NetworkConfig nConfig = (NetworkConfig)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().as(NetworkConfig.class);
        Map nls = nConfig.getNetworkListeners().getNetworkListener();
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String listenerName = (String)oneRow.get("Name");
                NetworkListener listener = (NetworkListener)nls.get(listenerName);
                Protocol protocol = listener.findProtocol();
                List<NetworkListener> listenerList = WebHandlers.findNetworkListeners(protocol);
                nConfig.getNetworkListeners().removeChild("network-listener", listenerName);
                if (protocol.getHttp() != null) {
                    WebHandlers.changeNetworkListenersInVS(protocol.getHttp().getDefaultVirtualServer(), listenerName, false);
                }
                if (listenerList.size() != 1 || !protocol.getName().equals(listenerName + GuiUtil.getMessage((String)"org.glassfish.web.admingui.Strings", (String)"grizzly.protocolExtension"))) continue;
                nConfig.getProtocols().removeChild("protocol", protocol.getName());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void updateNetworkListenerInVS(HandlerContext handlerCtx) {
        String previousVSName = (String)handlerCtx.getInputValue("previousVSName");
        String protocolName = (String)handlerCtx.getInputValue("protocolName");
        Protocol protocol = (Protocol)((NetworkConfig)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().as(NetworkConfig.class)).getProtocols().getProtocol().get(protocolName);
        if (protocol.getHttp() == null) {
            return;
        }
        String newVSName = protocol.getHttp().getDefaultVirtualServer();
        if (newVSName.equals(previousVSName)) {
            return;
        }
        List<NetworkListener> listenerList = WebHandlers.findNetworkListeners(protocol);
        for (NetworkListener one : listenerList) {
            WebHandlers.changeNetworkListenersInVS(previousVSName, one.getName(), false);
            WebHandlers.changeNetworkListenersInVS(newVSName, one.getName(), true);
        }
    }

    public static void deleteProtocol(HandlerContext handlerCtx) {
        NetworkConfig nConfig = (NetworkConfig)V3AMX.getInstance().getConfig("server-config").getNetworkConfig().as(NetworkConfig.class);
        Map ps = nConfig.getProtocols().getProtocol();
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String protocolName = (String)oneRow.get("Name");
                Protocol protocol = (Protocol)ps.get(protocolName);
                List<NetworkListener> listenerList = WebHandlers.findNetworkListeners(protocol);
                for (NetworkListener one : listenerList) {
                    if (protocol.getHttp() != null) {
                        WebHandlers.changeNetworkListenersInVS(protocol.getHttp().getDefaultVirtualServer(), one.getName(), false);
                    }
                    nConfig.getNetworkListeners().removeChild("network-listener", one.getName());
                }
                nConfig.getProtocols().removeChild("protocol", protocolName);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static List<NetworkListener> findNetworkListeners(Protocol protocol) {
        ArrayList<NetworkListener> result = new ArrayList<NetworkListener>();
        Map nMap = V3AMX.getInstance().getConfig("server-config").getNetworkConfig().getNetworkListeners().getNetworkListener();
        String nm = protocol.getName();
        for (NetworkListener one : nMap.values()) {
            if (!one.findProtocol().getName().equals(nm)) continue;
            result.add(one);
        }
        return result;
    }

    private static void putA(Map nMap, Map attrMap, String key) {
        String val = (String)attrMap.get(key);
        if (!GuiUtil.isEmpty((String)val)) {
            nMap.put(key, val);
        }
    }

    private static void putA(Map nMap, Map attrMap, String key, String defaultValue) {
        String val = (String)attrMap.get(key);
        if (!GuiUtil.isEmpty((String)val)) {
            nMap.put(key, val);
        } else {
            nMap.put(key, defaultValue);
        }
    }
}

