/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl;

import com.sun.enterprise.registration.RegistrationAccount;
import com.sun.enterprise.registration.RegistrationDescriptor;
import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.RegistrationServiceConfig;
import com.sun.enterprise.registration.impl.RegistrationLogger;
import com.sun.enterprise.registration.impl.RepositoryManager;
import com.sun.enterprise.registration.impl.SOAccount;
import com.sun.enterprise.registration.impl.ServiceTag;
import com.sun.enterprise.registration.impl.StringManager;
import com.sun.enterprise.registration.impl.SysnetTransferManager;
import com.sun.scn.client.comm.RegistrationWrapper;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.servicetags.EnvironmentInformation;
import com.sun.scn.servicetags.SunOnlineAccount;
import com.sun.scn.servicetags.SvcTag;
import java.io.File;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysnetRegistrationService
implements RegistrationService {
    private final RegistrationWrapper regWrapper;
    private final File localRepositoryFile;
    private static final String REGISTRATION_ID = "glassfish";
    private static final String AIX = "AIX";
    private static final Logger logger = RegistrationLogger.getLogger();

    public SysnetRegistrationService(File localRepositoryFile) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(this.getDefaultRegistrationID());
    }

    public SysnetRegistrationService(File localRepositoryFile, String registrationID) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(registrationID);
    }

    public SysnetRegistrationService(File localRepositoryFile, String proxyHost, int proxyPort) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(this.getDefaultRegistrationID(), proxyHost, proxyPort);
    }

    public SysnetRegistrationService(File localRepositoryFile, String proxyHost, int proxyPort, String registrationID) {
        this.localRepositoryFile = localRepositoryFile;
        this.regWrapper = new RegistrationWrapper(registrationID, proxyHost, proxyPort);
    }

    public SysnetRegistrationService(Object[] params) {
        this.localRepositoryFile = (File)params[0];
        this.regWrapper = new RegistrationWrapper(this.getDefaultRegistrationID(), (String)params[1], (Integer)params[2]);
    }

    public SysnetRegistrationService(RegistrationServiceConfig rc) {
        Object[] params = rc.getParams();
        this.localRepositoryFile = (File)params[0];
        this.regWrapper = params.length == 1 ? new RegistrationWrapper(this.getDefaultRegistrationID()) : (params.length == 2 ? new RegistrationWrapper((String)params[1]) : (params.length == 3 ? new RegistrationWrapper((String)params[1], (String)rc.getParams()[1], (Integer)rc.getParams()[2]) : new RegistrationWrapper((String)rc.getParams()[3], (String)rc.getParams()[1], (Integer)rc.getParams()[2])));
    }

    private String getDefaultRegistrationID() {
        return REGISTRATION_ID;
    }

    @Override
    public boolean isRegistrationEnabled() {
        if (AIX.equalsIgnoreCase(System.getProperty("os.name"))) {
            return false;
        }
        return this.localRepositoryFile.canWrite();
    }

    @Override
    public void register(RegistrationAccount account) throws RegistrationException, ConnectException, UnknownHostException {
        try {
            List serviceTags = this.getRegistrationDescriptors(RegistrationDescriptor.RegistrationStatus.NOT_REGISTERED);
            if (serviceTags.size() == 0) {
                logger.log(Level.WARNING, "No unregistered tags found");
                return;
            }
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage());
            }
            EnvironmentInformation env = new EnvironmentInformation(hostName, "", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), "", "", "", "");
            List<SvcTag> svcTags = ServiceTag.getSvcTags(serviceTags);
            String registryURN = "urn:st:" + UUID.randomUUID().toString();
            logger.log(Level.FINEST, "registryURN = " + registryURN);
            logger.log(Level.FINE, "Attempting to  register " + svcTags.size() + " servicetags");
            SOAccount soAccount = (SOAccount)account;
            this.regWrapper.registerServiceTags(env, svcTags, registryURN, soAccount.getUserID(), soAccount.getPassword());
            this.setRegistrationStatus(RegistrationService.RegistrationStatus.REGISTERED);
            logger.log(Level.INFO, "Registered " + svcTags.size() + " tags");
        }
        catch (SvcTagException ex) {
            throw new RegistrationException(ex);
        }
    }

    @Override
    public void createRegistrationAccount(RegistrationAccount soa) throws RegistrationException {
        try {
            SunOnlineAccount account = ((SOAccount)soa).getSunOnlineAccount();
            this.regWrapper.createSunOnlineAccount(account);
        }
        catch (SvcTagException ex) {
            throw new RegistrationException(ex);
        }
    }

    public List getRegistrationDescriptors() throws RegistrationException {
        RepositoryManager rm = this.getRepositoryManager();
        rm.updateRuntimeValues();
        return rm.getServiceTags();
    }

    public List getRegistrationDescriptors(String productURN) throws RegistrationException {
        List st1 = this.getRegistrationDescriptors();
        ArrayList<ServiceTag> st2 = new ArrayList<ServiceTag>();
        for (int i = 0; i < st1.size(); ++i) {
            ServiceTag st = (ServiceTag)st1.get(i);
            if (!st.getProductURN().equals(productURN)) continue;
            st2.add(st);
        }
        return st2;
    }

    public List getRegistrationDescriptors(RegistrationDescriptor.RegistrationStatus status) throws RegistrationException {
        List st1 = this.getRegistrationDescriptors();
        ArrayList<ServiceTag> st2 = new ArrayList<ServiceTag>();
        RepositoryManager rm = this.getRepositoryManager();
        for (int i = 0; i < st1.size(); ++i) {
            ServiceTag st = (ServiceTag)st1.get(i);
            if (!rm.getRegistrationStatus(st).equals((Object)status)) continue;
            st2.add(st);
        }
        return st2;
    }

    @Override
    public List<String> getAvailableCountries() {
        return this.regWrapper.getAvailableCountries();
    }

    @Override
    public List getAvailableCountries(Locale locale) {
        String cts = StringManager.getString("COUNTRY_LIST_TOTAL_COUNT", new Object[0]);
        int count = Integer.parseInt(cts);
        ArrayList<String> displayList = new ArrayList<String>();
        ArrayList<String> actualList = new ArrayList<String>();
        for (int i = 1; i < count + 1; ++i) {
            displayList.add(StringManager.getString("COUNTRY-" + i, new Object[0]));
            actualList.add(StringManager.getString("en_COUNTRY-" + i, new Object[0]));
        }
        ArrayList<ArrayList<String>> ret = new ArrayList<ArrayList<String>>(2);
        ret.add(0, displayList);
        ret.add(1, actualList);
        return ret;
    }

    public List<String> getAvailableSecurityQuestions() {
        return this.regWrapper.getAvailableSecurityQuestions();
    }

    @Override
    public RegistrationService.RegistrationReminder getRegistrationReminder() throws RegistrationException {
        return this.getRepositoryManager().getRegistrationReminder();
    }

    @Override
    public void setRegistrationReminder(RegistrationService.RegistrationReminder reminder) throws RegistrationException {
        this.getRepositoryManager().setRegistrationReminder(reminder);
    }

    @Override
    public RegistrationService.RegistrationStatus getRegistrationStatus() throws RegistrationException {
        return this.getRepositoryManager().getRegistrationStatus();
    }

    public void setRegistrationStatus(RegistrationService.RegistrationStatus status) throws RegistrationException {
        this.getRepositoryManager().setRegistrationStatus(status);
    }

    @Override
    public String getPasswordHelpURL() {
        return "https://reg.sun.com/accounthelp";
    }

    @Override
    public boolean isRegistrationAccountValid(RegistrationAccount account) throws RegistrationException, UnknownHostException, ConnectException {
        SOAccount soAccount = (SOAccount)account;
        try {
            this.regWrapper.authenticate(soAccount.getUserID(), soAccount.getPassword());
        }
        catch (SvcTagException sve) {
            throw new RegistrationException(sve);
        }
        return true;
    }

    public void transferEligibleServiceTagsToSysNet() throws RegistrationException {
        SysnetTransferManager transferManager = new SysnetTransferManager(this.localRepositoryFile);
        transferManager.transferServiceTags();
    }

    private RepositoryManager getRepositoryManager() throws RegistrationException {
        return new RepositoryManager(this.localRepositoryFile);
    }
}

