/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="mail-resource")
@I18n(value="add.resources")
public class JavaMailResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JavaMailResourceManager.class);
    private static final String DESCRIPTION = "description";
    String mailHost = null;
    String mailUser = null;
    String fromAddress = null;
    String jndiName = null;
    String storeProtocol = null;
    String storeProtocolClass = null;
    String transportProtocol = null;
    String transportProtocolClass = null;
    String enabled = null;
    String debug = null;
    String description = null;

    public String getResourceType() {
        return "mail-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        this.setParams(attrList);
        if (this.mailHost == null) {
            String msg = localStrings.getLocalString("create.mail.resource.noHostName", "No host name defined for Mail Resource.");
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
        if (this.mailUser == null) {
            String msg = localStrings.getLocalString("create.mail.resource.noUserName", "No user name defined for Mail Resource.");
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
        if (this.fromAddress == null) {
            String msg = localStrings.getLocalString("create.mail.resource.noFrom", "From not defined for Mail Resource.");
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof BindableResource) || !((BindableResource)resource).getJndiName().equals(this.jndiName)) continue;
            String msg = localStrings.getLocalString("create.mail.resource.duplicate.1", "A Mail Resource named {0} already exists.", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    MailResource newResource = (MailResource)param.createChild(MailResource.class);
                    newResource.setJndiName(JavaMailResourceManager.this.jndiName);
                    newResource.setFrom(JavaMailResourceManager.this.fromAddress);
                    newResource.setUser(JavaMailResourceManager.this.mailUser);
                    newResource.setHost(JavaMailResourceManager.this.mailHost);
                    newResource.setEnabled(JavaMailResourceManager.this.enabled.toString());
                    newResource.setStoreProtocol(JavaMailResourceManager.this.storeProtocol);
                    newResource.setStoreProtocolClass(JavaMailResourceManager.this.storeProtocolClass);
                    newResource.setTransportProtocol(JavaMailResourceManager.this.transportProtocol);
                    newResource.setTransportProtocolClass(JavaMailResourceManager.this.transportProtocolClass);
                    newResource.setDebug(JavaMailResourceManager.this.debug.toString());
                    if (JavaMailResourceManager.this.description != null) {
                        newResource.setDescription(JavaMailResourceManager.this.description);
                    }
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled.toString(), this.jndiName);
            }
            String msg = localStrings.getLocalString("create.mail.resource.success", "Mail Resource {0} created.", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(0, msg, true);
            return status;
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.mail.resource.fail", "Unable to create Mail Resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            ResourceStatus status = new ResourceStatus(1, msg, true);
            return status;
        }
    }

    private void setParams(HashMap attrList) {
        this.jndiName = (String)attrList.get("jndi-name");
        this.mailHost = (String)attrList.get("host");
        this.mailUser = (String)attrList.get("user");
        this.fromAddress = (String)attrList.get("from");
        this.storeProtocol = (String)attrList.get("store-protocol");
        this.storeProtocolClass = (String)attrList.get("store-protocol-class");
        this.transportProtocol = (String)attrList.get("transport-protocol");
        this.transportProtocolClass = (String)attrList.get("transport-protocol-class");
        this.debug = (String)attrList.get("debug");
        this.enabled = (String)attrList.get("enabled");
        this.description = (String)attrList.get(DESCRIPTION);
    }
}

