/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.GroupMap;
import com.sun.enterprise.config.serverbeans.PrincipalMap;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="work-security-map")
@I18n(value="add.resources")
public class ConnectorWorkSecurityMapResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorWorkSecurityMapResourceManager.class);
    String raName;
    Properties principalsMap;
    Properties groupsMap;
    String description;
    String mapName;

    public String getResourceType() {
        return "work-security-map";
    }

    public ResourceStatus create(Resources resources, HashMap attrList, Properties props, Server targetServer) throws Exception {
        this.setParams(attrList);
        if (this.mapName == null) {
            String msg = localStrings.getLocalString("create.connector.work.security.map.noMapName", "No mapname defined for connector work security map.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.raName == null) {
            String msg = localStrings.getLocalString("create.connector.work.security.map.noRaName", "No raname defined for connector work security map.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.principalsMap == null && this.groupsMap == null) {
            String msg = localStrings.getLocalString("create.connector.work.security.map.noMap", "No principalsmap or groupsmap defined for connector work security map.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.principalsMap != null && this.groupsMap != null) {
            String msg = localStrings.getLocalString("create.connector.work.security.map.specifyPrincipalsOrGroupsMap", "A work-security-map can have either (any number of) group mapping  or (any number of) principals mapping but not both. Specify--principalsmap or --groupsmap.");
            return new ResourceStatus(1, msg, true);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof WorkSecurityMap) || !((WorkSecurityMap)resource).getName().equals(this.mapName) || !((WorkSecurityMap)resource).getResourceAdapterName().equals(this.raName)) continue;
            String msg = localStrings.getLocalString("create.connector.work.security.map.duplicate", "A connector work security map named {0} for resource adapter {1} already exists.", new Object[]{this.mapName, this.raName});
            return new ResourceStatus(1, msg, true);
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    WorkSecurityMap workSecurityMap = (WorkSecurityMap)param.createChild(WorkSecurityMap.class);
                    workSecurityMap.setName(ConnectorWorkSecurityMapResourceManager.this.mapName);
                    workSecurityMap.setResourceAdapterName(ConnectorWorkSecurityMapResourceManager.this.raName);
                    if (ConnectorWorkSecurityMapResourceManager.this.principalsMap != null) {
                        for (Map.Entry<Object, Object> e : ConnectorWorkSecurityMapResourceManager.this.principalsMap.entrySet()) {
                            PrincipalMap principalMap = (PrincipalMap)workSecurityMap.createChild(PrincipalMap.class);
                            principalMap.setEisPrincipal((String)e.getKey());
                            principalMap.setMappedPrincipal((String)e.getValue());
                            workSecurityMap.getPrincipalMap().add(principalMap);
                        }
                    } else if (ConnectorWorkSecurityMapResourceManager.this.groupsMap != null) {
                        for (Map.Entry<Object, Object> e : ConnectorWorkSecurityMapResourceManager.this.groupsMap.entrySet()) {
                            GroupMap groupMap = (GroupMap)workSecurityMap.createChild(GroupMap.class);
                            groupMap.setEisGroup((String)e.getKey());
                            groupMap.setMappedGroup((String)e.getValue());
                            workSecurityMap.getGroupMap().add(groupMap);
                        }
                    }
                    param.getResources().add(workSecurityMap);
                    return workSecurityMap;
                }
            }, resources);
            String msg = localStrings.getLocalString("create.work.security.map.success", "Work security map {0} created.", new Object[]{this.mapName});
            return new ResourceStatus(0, msg, true);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.connector.work.security.map.fail", "Unable to create connector work security map {0}.", new Object[]{this.mapName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
    }

    private void setParams(HashMap attrList) {
        this.raName = (String)attrList.get("resource-adapter-name");
        this.mapName = (String)attrList.get("name");
        this.description = (String)attrList.get("description");
        this.principalsMap = (Properties)attrList.get("principal-map");
        this.groupsMap = (Properties)attrList.get("group-map");
    }
}

