/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="connector-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.resource")
public class ConnectorResourceManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorResourceManager.class);
    private String poolName = null;
    private String enabled = Boolean.TRUE.toString();
    private String jndiName = null;
    private String description = null;
    private String objectType = "user";

    public String getResourceType() {
        return "connector-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        String msg;
        this.setParams(attrList);
        if (this.jndiName == null) {
            String msg2 = localStrings.getLocalString("create.connector.resource.noJndiName", "No JNDI name defined for connector resource.");
            return new ResourceStatus(1, msg2);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof BindableResource) || !((BindableResource)resource).getJndiName().equals(this.jndiName)) continue;
            String msg3 = localStrings.getLocalString("create.connector.resource.duplicate", "A resource named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg3);
        }
        if (!this.isConnPoolExists(resources, this.poolName)) {
            msg = localStrings.getLocalString("create.connector.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of connector connection pools.", new Object[]{this.poolName});
            return new ResourceStatus(1, msg);
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ConnectorResource newResource = (ConnectorResource)param.createChild(ConnectorResource.class);
                    newResource.setJndiName(ConnectorResourceManager.this.jndiName);
                    if (ConnectorResourceManager.this.description != null) {
                        newResource.setDescription(ConnectorResourceManager.this.description);
                    }
                    newResource.setPoolName(ConnectorResourceManager.this.poolName);
                    newResource.setEnabled(ConnectorResourceManager.this.enabled.toString());
                    newResource.setObjectType(ConnectorResourceManager.this.objectType);
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled.toString(), this.jndiName);
            }
        }
        catch (TransactionFailure tfe) {
            String msg4 = localStrings.getLocalString("create.connector.resource.fail", "Connector resource {0} create failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg4);
        }
        msg = localStrings.getLocalString("create.connector.resource.success", "Connector resource {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    public void setParams(HashMap attrList) {
        this.poolName = (String)attrList.get("pool-name");
        this.enabled = (String)attrList.get("enabled");
        this.jndiName = (String)attrList.get("jndi-name");
        this.description = (String)attrList.get(DESCRIPTION);
        this.objectType = (String)attrList.get("object-type");
    }

    private boolean isConnPoolExists(Resources resources, String poolName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof ConnectorConnectionPool) || !((ConnectorConnectionPool)resource).getName().equals(poolName)) continue;
            return true;
        }
        return false;
    }
}

