/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.glassfish.deployapi.DeploymentStatusImpl;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;

public class ProgressObjectSink
extends DFProgressObject
implements ProgressListener {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");
    private Vector registeredPL = new Vector();
    private Vector deliveredEvents = new Vector();
    private StateType finalStateType = StateType.COMPLETED;
    private String finalMessage;
    private Vector targetModuleIDs = new Vector();
    private Vector sources = new Vector();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProgressObjectSink.class);
    DFDeploymentStatus completedStatus = new DFDeploymentStatus();
    private boolean completedStatusReady = false;

    public void sinkProgressObject(ProgressObject source) {
        this.sources.add(source);
        source.addProgressListener((ProgressListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleProgressEvent(ProgressEvent progressEvent) {
        ProgressEvent forwardedEvent;
        TargetModuleID[] ids;
        DeploymentStatus forwardedDS = progressEvent.getDeploymentStatus();
        if (!forwardedDS.isRunning()) {
            Object source;
            if (forwardedDS.isFailed()) {
                this.finalStateType = StateType.FAILED;
            }
            if ((source = progressEvent.getSource()) instanceof ProgressObject) {
                ProgressObject po = (ProgressObject)source;
                po.removeProgressListener((ProgressListener)this);
                this.sources.remove(source);
                if (forwardedDS.isCompleted()) {
                    ids = po.getResultTargetModuleIDs();
                    for (int i = 0; i < ids.length; ++i) {
                        this.targetModuleIDs.add(ids[i]);
                    }
                }
            } else {
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.client.noprogressobject", "Progress event does not contain a ProgressObject source"));
            }
            this.updateCompletedStatus(forwardedDS);
            DeploymentStatusImpl forwardedStatus = new DeploymentStatusImpl();
            forwardedStatus.setState(StateType.RUNNING);
            forwardedStatus.setMessage(forwardedDS.getMessage());
            forwardedStatus.setCommand(forwardedDS.getCommand());
            forwardedEvent = new ProgressEvent((Object)this, progressEvent.getTargetModuleID(), (DeploymentStatus)forwardedStatus);
        } else {
            forwardedEvent = new ProgressEvent((Object)this, progressEvent.getTargetModuleID(), forwardedDS);
        }
        ProgressEvent finalEvent = null;
        ids = this.registeredPL;
        synchronized (this.registeredPL) {
            Collection clone = (Collection)this.registeredPL.clone();
            this.deliveredEvents.add(forwardedEvent);
            if (this.sources.isEmpty()) {
                this.prepareCompletedStatus();
                DeploymentStatusImpl status = new DeploymentStatusImpl();
                status.setState(this.finalStateType);
                if (this.finalStateType.equals(StateType.FAILED)) {
                    status.setMessage(localStrings.getLocalString("enterprise.deployment.client.aggregatefailure", "At least one operation failed"));
                } else {
                    status.setMessage(localStrings.getLocalString("enterprise.deployment.client.aggregatesuccess", "All operations completed successfully"));
                }
                finalEvent = new ProgressEvent((Object)this, progressEvent.getTargetModuleID(), (DeploymentStatus)status);
                this.deliveredEvents.add(finalEvent);
            }
            // ** MonitorExit[ids] (shouldn't be in output)
            for (ProgressListener pl : clone) {
                pl.handleProgressEvent(forwardedEvent);
            }
            if (finalEvent != null) {
                for (ProgressListener pl : clone) {
                    pl.handleProgressEvent(finalEvent);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener progressListener) {
        Collection clone;
        Vector vector = this.registeredPL;
        synchronized (vector) {
            this.registeredPL.add(progressListener);
            clone = (Collection)this.deliveredEvents.clone();
        }
        for (ProgressEvent pe : clone) {
            progressListener.handleProgressEvent(pe);
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.registeredPL.remove(progressListener);
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        DeploymentStatusImpl status = new DeploymentStatusImpl();
        if (this.sources.isEmpty()) {
            status.setState(this.finalStateType);
            status.setMessage(this.finalMessage);
        } else {
            status.setState(StateType.RUNNING);
        }
        return status;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        Object[] ids = new TargetModuleID[this.targetModuleIDs.size()];
        this.targetModuleIDs.copyInto(ids);
        return ids;
    }

    public boolean isCancelSupported() {
        for (ProgressObject source : this.getSources()) {
            if (source.isCancelSupported()) continue;
            return false;
        }
        return true;
    }

    public boolean isStopSupported() {
        for (ProgressObject source : this.getSources()) {
            if (source.isStopSupported()) continue;
            return false;
        }
        return true;
    }

    public void cancel() throws OperationUnsupportedException {
        if (!this.isCancelSupported()) {
            throw new OperationUnsupportedException("cancel");
        }
        for (ProgressObject source : this.getSources()) {
            source.cancel();
        }
    }

    public void stop() throws OperationUnsupportedException {
        if (!this.isStopSupported()) {
            throw new OperationUnsupportedException("stop");
        }
        for (ProgressObject source : this.getSources()) {
            source.stop();
        }
    }

    private Collection getSources() {
        return (Collection)this.sources.clone();
    }

    private void prepareCompletedStatus() {
        DFDeploymentStatus.Status worstStatus = DFDeploymentStatus.Status.NOTINITIALIZED;
        StringBuffer msgs = new StringBuffer();
        DFDeploymentStatus.Status newWorstStatus = this.aggregateStages(worstStatus, msgs, this.completedStatus);
        this.completedStatus.setStageStatus(newWorstStatus);
        this.completedStatus.setStageStatusMessage(msgs.toString());
        this.completedStatusReady = true;
    }

    private DFDeploymentStatus.Status aggregateStages(DFDeploymentStatus.Status worstStatusSoFar, StringBuffer msgs, DFDeploymentStatus stage) {
        DFDeploymentStatus.Status stageStatus = stage.getStageStatus();
        if (stageStatus.isWorseThan(worstStatusSoFar)) {
            worstStatusSoFar = stageStatus;
            msgs.delete(0, msgs.length());
        }
        if (stageStatus == worstStatusSoFar) {
            msgs.append(stage.getStageStatusMessage()).append(LINE_SEPARATOR);
        }
        Iterator it = stage.getSubStages();
        while (it.hasNext()) {
            DFDeploymentStatus substage = (DFDeploymentStatus)it.next();
            worstStatusSoFar = this.aggregateStages(worstStatusSoFar, msgs, substage);
        }
        return worstStatusSoFar;
    }

    public DFDeploymentStatus getCompletedStatus() {
        DFDeploymentStatus answer = null;
        if (this.completedStatusReady) {
            answer = this.completedStatus;
        }
        return answer;
    }

    private void updateCompletedStatus(DeploymentStatus ds) {
        DFDeploymentStatus newStageStatus = null;
        if (ds instanceof DeploymentStatusImpl) {
            DeploymentStatusImpl dsi = (DeploymentStatusImpl)ds;
            newStageStatus = dsi.progressObject.getCompletedStatus();
        } else {
            newStageStatus = new DFDeploymentStatus(this.completedStatus);
            Object msgKey = null;
            int stageStatus = -1;
            this.reviseStatusAndMessage(ds, newStageStatus);
        }
        if (newStageStatus != null) {
            this.completedStatus.addSubStage(newStageStatus);
        } else {
            System.err.println("A newStageStatus was null");
        }
    }

    private void reviseStatusAndMessage(DeploymentStatus ds, DFDeploymentStatus newStageStatus) {
        String msgKey = null;
        DFDeploymentStatus.Status stageStatus = DFDeploymentStatus.Status.NOTINITIALIZED;
        if (ds.isCompleted()) {
            msgKey = "enterprise.deployment.client.action_completed";
            stageStatus = DFDeploymentStatus.Status.SUCCESS;
        } else {
            msgKey = "enterprise.deployment.client.action_failed";
            stageStatus = DFDeploymentStatus.Status.FAILURE;
        }
        String i18msg = localStrings.getLocalString(msgKey, ds.getMessage());
        newStageStatus.setStageStatus(stageStatus);
        newStageStatus.setStageStatusMessage(i18msg);
    }
}

